/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.EvolvingSchemaMap;
import com.ibm.disthubmq.impl.formats.EvolvingTupleCursor;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaViolationException;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.impl.formats.VacuousTupleCursor;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

final class EvolvingSchemaCursor
implements SchemaCursor,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("EvolvingSchemaCursor");
    private EvolvingSchemaMap map;
    private SchemaCursor encoding;
    private TupleCursor tupleCache;
    private static TupleDef emptyTupleDef = new TupleDef();
    static TupleCursor emptyTuple = new TupleCursor(){

        public TupleDef getTupleDef() {
            return emptyTupleDef;
        }

        public TupleCursor newRow() {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }

        public TupleCursor nextRow() {
            return null;
        }

        public void truncateRows() {
            throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1280, null));
        }

        public boolean getBoolean(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public byte getByte(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public short getShort(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public char getChar(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public int getInt(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public long getLong(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public float getFloat(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public double getDouble(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public String getString(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public byte[] getObject(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public byte[] getByteArray(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public Object getValue(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public Schema getSchema(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public Schema getEncodingSchema(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public int getChoice(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public int getChoice(int n, Schema schema) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public TupleCursor getContents(int n) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public TupleCursor getContents(int n, Schema schema) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setBoolean(int n, boolean bl) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setByte(int n, byte by) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setShort(int n, short s) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setChar(int n, char c) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setInt(int n, int n2) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setLong(int n, long l) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setFloat(int n, float f) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setDouble(int n, double d) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setString(int n, String string) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setObject(int n, byte[] byArray) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setByteArray(int n, byte[] byArray) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setValue(int n, Object object) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public void setSchema(int n, Schema schema) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }

        public TupleCursor setChoice(int n, int n2) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1279, null));
        }
    };

    EvolvingSchemaCursor(EvolvingSchemaMap evolvingSchemaMap, SchemaCursor schemaCursor) {
        this.map = evolvingSchemaMap;
        this.encoding = schemaCursor;
    }

    public short getInterpreterId() {
        short s = this.encoding.getInterpreterId();
        return s;
    }

    public Schema getSchema() {
        return this.map.access;
    }

    public Schema getEncodingSchema() {
        return this.encoding.getEncodingSchema();
    }

    public Schema[] getSchemata() {
        Schema[] schemaArray = this.encoding.getSchemata();
        return schemaArray;
    }

    public ByteSequence getRawMessage() {
        ByteSequence byteSequence = this.encoding.getRawMessage();
        return byteSequence;
    }

    public void decode(ByteSequence byteSequence, int n, int n2, MessageEncrypter messageEncrypter) {
        this.encoding.decode(byteSequence, n, n2, messageEncrypter);
        this.tupleCache = null;
    }

    public void clear() {
        this.encoding.clear();
        this.tupleCache = null;
    }

    public boolean needsEncoding() {
        boolean bl = this.encoding.needsEncoding();
        return bl;
    }

    public int encode(ByteSequence byteSequence, int n, MessageEncrypter messageEncrypter) {
        int n2 = this.encoding.encode(byteSequence, n, messageEncrypter);
        return n2;
    }

    public int getChoice() {
        int n = this.encoding.getChoice();
        if (n >= this.map.map.length) {
            if (this.map.noDefault) {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
            }
            n = 0;
        }
        return n;
    }

    public TupleCursor getContents() {
        TupleCursor tupleCursor = this.tupleCache;
        if (this.tupleCache == null) {
            int n = this.encoding.getChoice();
            if (n >= this.map.map.length) {
                if (this.map.noDefault) {
                    throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
                }
                tupleCursor = emptyTuple;
            } else {
                tupleCursor = this.tupleCache = new EvolvingTupleCursor(this.map.map[n], this.encoding.getContents());
            }
        }
        return tupleCursor;
    }

    public TupleCursor setChoice(int n) {
        if (n >= this.map.map.length) {
            if (this.map.noDefault) {
                throw new SchemaViolationException(ExceptionBuilder.buildReasonString(1281, null));
            }
            this.encoding.setChoice(0);
            this.tupleCache = new VacuousTupleCursor(this.map.access.getTupleDef(n));
        } else {
            this.tupleCache = new EvolvingTupleCursor(this.map.map[n], this.encoding.setChoice(n));
        }
        return this.tupleCache;
    }
}

