/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ColumnDef;
import com.ibm.disthubmq.impl.formats.FlatTupleMap;
import com.ibm.disthubmq.impl.formats.MessageVal;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.formats.SchemaMap;
import com.ibm.disthubmq.impl.formats.TupleMap;
import com.ibm.disthubmq.impl.formats.UninitializedAccessException;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.util.Stack;

public final class ColumnMap
implements SchemaCodes,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("ColumnMap");
    public ColumnDef def;
    public SchemaMap subMap;
    TupleMap parent;
    int pos;

    ColumnMap(ColumnDef columnDef, TupleMap tupleMap, int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ColumnMap", columnDef, tupleMap, new Integer(n));
        }
        this.def = columnDef;
        this.parent = tupleMap;
        this.pos = n;
        if (columnDef.getTypeCode() == 0 && tupleMap != null) {
            ColumnMap columnMap = new ColumnMap(columnDef, null, n);
            columnMap.subMap = this.subMap = new SchemaMap(columnDef.getSchema(), columnMap);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ColumnMap");
        }
    }

    int getAbsoluteOffset(MessageVal messageVal) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAbsoluteOffset", messageVal);
        }
        if (messageVal.flatTuple == null) {
            throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{this.def.getFullName()}));
        }
        int n = this.getAbsoluteOffset(messageVal.flatTuple, messageVal.oTable, messageVal.dataOffset);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAbsoluteOffset", new Integer(n));
        }
        return n;
    }

    int getAbsoluteOffset(FlatTupleMap flatTupleMap, int[] nArray, int n) {
        FlatTupleMap.Remap remap;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAbsoluteOffset", flatTupleMap, nArray, new Integer(n));
        }
        if ((remap = flatTupleMap.getRemap(this)) == null) {
            throw new UninitializedAccessException(ExceptionBuilder.buildReasonString(1285, new Object[]{this.def.getFullName()}));
        }
        int n2 = remap.offsetIndex;
        n2 = n2 < 0 ? 0 : nArray[n2];
        int n3 = n + n2 + remap.fixedIncr;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAbsoluteOffset", new Integer(n3));
        }
        return n3;
    }

    public void dumpLogical(String string, Stack stack) {
        if (this.subMap != null) {
            if (!stack.empty() && stack.peek() == this) {
                System.err.println(string + "...");
                stack.pop();
            } else {
                stack.push(this);
                this.subMap.dump(string, stack);
            }
        } else {
            System.err.println(string + SchemaCodes.typeNames[this.def.getTypeCode() - -4]);
        }
    }

    public String dumpPhysical(FlatTupleMap flatTupleMap) {
        FlatTupleMap.Remap remap = flatTupleMap.getRemap(this);
        return "" + this.parent.uniqueIndex + '.' + this.pos + '[' + remap.offsetIndex + "]+" + remap.fixedIncr;
    }
}

