/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.Names;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCodes;
import com.ibm.disthubmq.impl.formats.TupleDef;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.Serializable;

public final class ColumnDef
implements SchemaCodes,
Serializable,
ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("ColumnDef");
    private byte typeCode;
    private byte access = (byte)-110;
    private Schema schema;
    private String name;
    TupleDef parent;

    public void setName(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setName", string);
        }
        this.name = string;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setName");
        }
    }

    public void setAccess(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setAccess", string);
        }
        switch (string.charAt(0)) {
            case 'm': {
                this.access = (byte)-110;
                break;
            }
            case 'h': {
                this.access = (byte)-100;
                break;
            }
            case 'a': {
                this.access = (byte)-101;
                break;
            }
            case 'n': {
                this.access = (byte)-128;
                break;
            }
            default: {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1287, new Object[]{new Character(string.charAt(0))}));
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setAccess");
        }
    }

    public void setNames(Names names, TupleDef tupleDef) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setNames", names, tupleDef);
        }
        this.setName(names.name);
        this.parent = tupleDef;
        if (this.schema != null && names.subNames != null) {
            int n = 0;
            while (n < this.schema.getChoiceCount()) {
                this.schema.getTupleDef(n).setNames(names.subNames[n], this);
                ++n;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setNames");
        }
    }

    public String getName() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getName");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getName", this.name);
        }
        return this.name;
    }

    public String getFullName() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFullName");
        }
        String string = this.name;
        if (this.parent != null) {
            string = this.parent.getFullName() + "." + this.name;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getFullName", string);
        }
        return string;
    }

    public String getShortName() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getShortName");
        }
        String string = null;
        if (this.name.length() > 0) {
            string = this.name;
        } else if (this.parent != null) {
            string = this.parent.getShortName();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getShortName", string);
        }
        return string;
    }

    public String getCppFullName() {
        String string = this.parent.getCppFullName(true);
        if (string == null || string.length() == 0) {
            return this.name;
        }
        if (this.name == null || this.name.length() == 0) {
            return string;
        }
        return string + "." + this.name;
    }

    public byte getTypeCode() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTypeCode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTypeCode", new Byte(this.typeCode));
        }
        return this.typeCode;
    }

    public byte getAccess() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAccess");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAccess", new Byte(this.access));
        }
        return this.access;
    }

    public Schema getSchema() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSchema");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSchema", this.schema);
        }
        return this.schema;
    }

    public ColumnDef(byte by) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ColumnDef", new Byte(by));
        }
        this.typeCode = by;
        this.name = "";
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ColumnDef");
        }
    }

    public ColumnDef(Schema schema) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ColumnDef", schema);
        }
        this.typeCode = 0;
        this.schema = schema;
        this.name = "";
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ColumnDef");
        }
    }

    ColumnDef(byte[] byArray, int n, int n2) {
        this(byArray, new int[]{n, n + n2});
    }

    ColumnDef(byte[] byArray, int[] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ColumnDef", byArray, nArray);
        }
        this.name = "";
        this.typeCode = Schema.getByte(byArray, nArray);
        if (this.typeCode <= -100) {
            this.access = this.typeCode;
            this.typeCode = Schema.getByte(byArray, nArray);
        } else {
            this.access = (byte)-110;
        }
        if (this.typeCode == 0) {
            this.schema = new Schema(byArray, nArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ColumnDef");
        }
    }

    int encodedSize() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "encodedSize");
        }
        int n = this.typeCode != 0 ? 1 : 1 + this.schema.encodedSize();
        if (this.access != -110) {
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "encodedSize", new Integer(n));
        }
        return n;
    }

    void encode(byte[] byArray, int[] nArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "encode", byArray, nArray);
        }
        if (this.access != -110) {
            Schema.setByte(byArray, nArray, this.access);
        }
        Schema.setByte(byArray, nArray, this.typeCode);
        if (this.typeCode == 0) {
            this.schema.encode(byArray, nArray);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "encode");
        }
    }

    public String toString() {
        String string = this.schema != null ? this.schema.toString() : SchemaCodes.typeNames[this.typeCode - -4];
        return (this.name == null || this.name.length() == 0 ? string : this.name + ": " + string) + " ";
    }
}

