/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.formats;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.ArrayUtil;
import com.ibm.disthubmq.impl.util.UTF;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;

public class ByteSequence
implements ExceptionConstants,
LogConstants {
    private static final DebugObject debug = new DebugObject("ByteSequence");
    private static final int CHUNKSIZE = 256;
    public int length;
    public int framelen;
    public byte[] frame;
    public int offset;
    public ByteSequence next;
    private boolean spare;

    public ByteSequence() {
        this(new byte[256], 0, 0);
        this.spare = true;
    }

    public ByteSequence(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteSequence(byte[] byArray, int n, int n2) {
        this.frame = byArray;
        this.offset = n;
        this.length = this.framelen = n2;
    }

    public void reset() {
        this.length = 0;
        this.offset = 0;
        this.next = null;
        this.spare = true;
    }

    public void append(ByteSequence byteSequence) {
        if (this.next == null) {
            this.next = byteSequence;
        } else {
            this.next.append(byteSequence);
        }
        this.getLength();
    }

    private void insert(ByteSequence byteSequence) {
        if (this.next != null) {
            byteSequence.append(this.next);
        }
        this.next = byteSequence;
    }

    private void split(int n) {
        ByteSequence byteSequence = new ByteSequence(this.frame, this.offset + n, this.framelen - n);
        if (this.next != null) {
            byteSequence.append(this.next);
        }
        this.framelen = n;
        this.next = byteSequence;
        this.getLength();
    }

    private int getLength() {
        this.length = this.next == null ? this.framelen : this.framelen + this.next.getLength();
        return this.length;
    }

    public void insert(ByteSequence byteSequence, int n) {
        if (n > this.framelen) {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            this.next.insert(byteSequence, n - this.framelen);
        } else if (n == this.framelen) {
            this.insert(byteSequence);
        } else {
            this.split(n);
            this.insert(byteSequence);
        }
        this.getLength();
    }

    public ByteSequence remove(int n, int n2) {
        ByteSequence byteSequence = this;
        if (n2 != 0) {
            if (n == 0) {
                if (n2 > this.framelen) {
                    if (this.next == null) {
                        throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
                    }
                    byteSequence = this.next.remove(0, n2 - this.framelen);
                } else if (n2 == this.framelen) {
                    byteSequence = this.next;
                } else {
                    this.framelen -= n2;
                    this.offset += n2;
                    this.getLength();
                }
            } else if (n >= this.framelen) {
                if (this.next == null) {
                    throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
                }
                this.next = this.next.remove(n - this.framelen, n2);
                this.getLength();
            } else {
                int n3 = n + n2;
                if (n3 > this.framelen) {
                    this.next = this.next.remove(0, n3 - this.framelen);
                    n3 = this.framelen;
                } else if (n3 < this.framelen) {
                    this.split(n3);
                }
                this.framelen = n;
                this.getLength();
            }
        }
        return byteSequence;
    }

    public byte[] linearize() {
        if (this.next != null || this.offset != 0 || this.framelen != this.frame.length) {
            this.linearize(new byte[this.length]);
        }
        return this.frame;
    }

    private void linearize(byte[] byArray) {
        int n = 0;
        ByteSequence byteSequence = this;
        do {
            System.arraycopy(byteSequence.frame, byteSequence.offset, byArray, n, byteSequence.framelen);
            n += byteSequence.framelen;
        } while ((byteSequence = byteSequence.next) != null);
        this.frame = byArray;
        this.offset = 0;
        this.framelen = this.length = n;
        this.next = null;
    }

    private void ensure(int n) {
        if (this.next == null && this.spare && this.offset + n <= this.frame.length) {
            this.framelen = this.length = n;
        } else if (n < this.length) {
            this.linearize(new byte[this.length]);
        } else {
            this.linearize(new byte[n + 256]);
            this.spare = true;
            this.framelen = this.length = n;
        }
    }

    public byte readByte(int n) {
        byte by;
        if (n < this.framelen) {
            by = this.frame[this.offset + n];
        } else {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            by = this.next.readByte(n - this.framelen);
        }
        return by;
    }

    public short readShort(int n) {
        short s;
        if (n <= this.framelen - 2) {
            s = ArrayUtil.readShort(this.frame, this.offset + n);
        } else {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            s = n < this.framelen ? ArrayUtil.readShort(this.linearize(), n) : this.next.readShort(n - this.framelen);
        }
        return s;
    }

    public int readInt(int n) {
        int n2;
        if (n <= this.framelen - 4) {
            n2 = ArrayUtil.readInt(this.frame, this.offset + n);
        } else {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            n2 = n < this.framelen ? ArrayUtil.readInt(this.linearize(), n) : this.next.readInt(n - this.framelen);
        }
        return n2;
    }

    public long readLong(int n) {
        long l;
        if (n <= this.framelen - 8) {
            l = ArrayUtil.readLong(this.frame, this.offset + n);
        } else {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            l = n < this.framelen ? ArrayUtil.readLong(this.linearize(), n) : this.next.readLong(n - this.framelen);
        }
        return l;
    }

    public void read(int n, byte[] byArray, int n2, int n3) {
        if (n <= this.framelen - n3) {
            System.arraycopy(this.frame, this.offset + n, byArray, n2, n3);
        } else {
            if (this.next == null) {
                throw new ArrayIndexOutOfBoundsException(ExceptionBuilder.buildReasonString(1278, null));
            }
            if (n < this.framelen) {
                System.arraycopy(this.linearize(), n, byArray, n2, n3);
            } else {
                this.next.read(n - this.framelen, byArray, n2, n3);
            }
        }
    }

    public void writeByte(int n, byte by) {
        if (n < this.framelen) {
            this.frame[this.offset + n] = by;
        } else if (this.next == null) {
            this.ensure(n + 1);
            this.frame[this.offset + n] = by;
        } else {
            this.next.writeByte(n - this.framelen, by);
        }
        this.getLength();
    }

    public void writeShort(int n, short s) {
        if (n <= this.framelen - 2) {
            ArrayUtil.writeShort(this.frame, this.offset + n, s);
        } else if (n < this.framelen || this.next == null) {
            this.ensure(n + 2);
            ArrayUtil.writeShort(this.frame, this.offset + n, s);
        } else {
            this.next.writeShort(n - this.framelen, s);
        }
        this.getLength();
    }

    public void writeInt(int n, int n2) {
        if (n <= this.framelen - 4) {
            ArrayUtil.writeInt(this.frame, this.offset + n, n2);
        } else if (n < this.framelen || this.next == null) {
            this.ensure(n + 4);
            ArrayUtil.writeInt(this.frame, this.offset + n, n2);
        } else {
            this.next.writeInt(n - this.framelen, n2);
        }
        this.getLength();
    }

    public void writeLong(int n, long l) {
        if (n <= this.framelen - 8) {
            ArrayUtil.writeLong(this.frame, this.offset + n, l);
        } else if (n < this.framelen || this.next == null) {
            this.ensure(n + 8);
            ArrayUtil.writeLong(this.frame, this.offset + n, l);
        } else {
            this.next.writeLong(n - this.framelen, l);
        }
        this.getLength();
    }

    public void write(int n, byte[] byArray, int n2, int n3) {
        if (n <= this.framelen - n3) {
            System.arraycopy(byArray, n2, this.frame, this.offset + n, n3);
        } else if (n < this.framelen || this.next == null) {
            this.ensure(n + n3);
            System.arraycopy(byArray, n2, this.frame, this.offset + n, n3);
        } else {
            this.next.write(n - this.framelen, byArray, n2, n3);
        }
        this.getLength();
    }

    public void writeUnicode(int n, int n2, char[] cArray, int n3, int n4) {
        if (n <= this.framelen - n2) {
            UTF.charsToUTF(cArray, n3, this.frame, this.offset + n, n4);
        } else if (n < this.framelen || this.next == null) {
            this.ensure(n + n2);
            UTF.charsToUTF(cArray, n3, this.frame, this.offset + n, n4);
        } else {
            this.next.writeUnicode(n - this.framelen, n2, cArray, n3, n4);
        }
        this.getLength();
    }
}

