/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.client;

import com.ibm.disthubmq.client.Message;
import com.ibm.disthubmq.client.Topic;
import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.ConnectorImpl;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.TopicImpl;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MessageImpl
implements Message,
LogConstants,
ExceptionConstants,
Cloneable {
    private static final DebugObject debug = new DebugObject("MessageImpl");
    public SchemaCursor cursor;
    private TupleCursor msgTuple;
    private boolean topicsArePrefixed;
    private TupleCursor payload;
    private TupleCursor body;
    private static final int JMSBODY = 7;
    private Serializable cachedObjectBody;

    public MessageImpl(TopicImpl topicImpl) {
        this(ConnectorImpl.newNormalMessage(MessageImpl.toDefaultExternalTopic(topicImpl.fullName), 4, null, 0));
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl", topicImpl);
        }
        this.topicsArePrefixed = true;
        this.defaults();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    private void defaults() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "defaults");
        }
        this.body.setChoice(0, 0);
        this.body.setChoice(2, 0);
        this.body.setChoice(1, 0);
        this.body.setChoice(6, 0);
        this.body.setBoolean(3, false);
        this.body.setBoolean(5, false);
        this.body.setLong(4, 0L);
        this.body.setChoice(7, 1);
        this.cachedObjectBody = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "defaults");
        }
    }

    public MessageImpl(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl", schemaCursor);
        }
        this.cursor = schemaCursor;
        this.msgTuple = schemaCursor.getContents();
        this.topicsArePrefixed = this.msgTuple.getChoice(6) == 1 ? this.msgTuple.getContents(6).getChoice(0) == 0 : true;
        this.payload = this.msgTuple.getContents(7);
        this.body = this.payload.getContents(3);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    protected MessageImpl(SchemaCursor schemaCursor, TupleCursor tupleCursor, TupleCursor tupleCursor2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl", schemaCursor, tupleCursor, tupleCursor2);
        }
        this.cursor = schemaCursor;
        this.msgTuple = schemaCursor.getContents();
        this.topicsArePrefixed = this.msgTuple.getChoice(6) == 1 ? this.msgTuple.getContents(6).getChoice(0) == 0 : true;
        this.payload = tupleCursor;
        this.body = tupleCursor2;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    public MessageImpl() {
        this(ConnectorImpl.newNormalMessage("", 4, null, 0));
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl");
        }
        this.topicsArePrefixed = true;
        this.defaults();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    public Object clone() {
        ByteSequence byteSequence;
        if (this.cursor.needsEncoding()) {
            byteSequence = new ByteSequence();
            this.cursor.encode(byteSequence, 0, null);
        } else {
            byteSequence = this.cursor.getRawMessage();
        }
        if (byteSequence != null) {
            byteSequence = new ByteSequence((byte[])byteSequence.linearize().clone());
            SchemaCursor schemaCursor = SchemaRegistry.getSchemaCursor(this.cursor.getInterpreterId(), this.cursor.getSchema().getId());
            schemaCursor.decode(byteSequence, 0, -1, null);
            return new MessageImpl(schemaCursor);
        }
        return new MessageImpl();
    }

    IllegalStateException stateException(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stateException", new Integer(n));
        }
        return new IllegalStateException(ExceptionBuilder.buildReasonString(n, null));
    }

    public int getMessageType() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMessageType");
        }
        int n = this.body.getChoice(7);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMessageType", new Integer(n));
        }
        return n;
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearBody");
        }
        this.body.setChoice(7, 1);
        this.cachedObjectBody = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearBody");
        }
    }

    public byte[] getBytesBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getBytesBody");
        }
        byte[] byArray = null;
        if (this.body.getChoice(7) != 3) {
            throw this.stateException(1067);
        }
        byArray = this.body.getContents(7).getByteArray(0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getBytesBody", byArray);
        }
        return byArray;
    }

    public void setBytesBody(byte[] byArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBytesBody", byArray);
        }
        this.body.setChoice(7, 3).setByteArray(0, byArray);
        this.cachedObjectBody = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBytesBody");
        }
    }

    public String getTextBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTextBody");
        }
        String string = null;
        if (this.body.getChoice(7) != 4) {
            throw this.stateException(1068);
        }
        string = this.body.getContents(7).getString(0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTextBody", string);
        }
        return string;
    }

    public void setTextBody(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTextBody", string);
        }
        this.body.setChoice(7, 4).setString(0, string);
        this.cachedObjectBody = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTextBody");
        }
    }

    public Serializable getObjectBody() throws IOException, ClassNotFoundException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObjectBody");
        }
        if (this.cachedObjectBody == null) {
            if (this.body.getChoice(7) == 2) {
                byte[] byArray = this.getObjectRaw();
                if (byArray == null) {
                    return null;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.cachedObjectBody = (Serializable)new ObjectInputStream(byteArrayInputStream).readObject();
            } else {
                throw this.stateException(1075);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObjectBody", this.cachedObjectBody);
        }
        return this.cachedObjectBody;
    }

    public byte[] getObjectRaw() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObjectRaw");
        }
        byte[] byArray = this.body.getContents(7).getObject(0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObjectRaw", byArray);
        }
        return byArray;
    }

    public void setObjectBody(Serializable serializable) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObjectBody", serializable);
        }
        if (serializable == null) {
            this.setObjectRaw(null);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(serializable);
            this.setObjectRaw(byteArrayOutputStream.toByteArray());
        }
        this.cachedObjectBody = serializable;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObjectBody");
        }
    }

    public void setObjectRaw(byte[] byArray) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObjectRaw", byArray);
        }
        this.body.setChoice(7, 2).setObject(0, byArray);
        this.cachedObjectBody = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObjectRaw");
        }
    }

    public Vector getFields() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFields");
        }
        Vector<Object> vector = null;
        if (this.body.getChoice(7) == 5) {
            vector = new Vector<Object>();
            TupleCursor tupleCursor = this.body.getContents(7).nextRow();
            while (tupleCursor != null) {
                vector.addElement(tupleCursor.getContents(0).getValue(0));
                tupleCursor = tupleCursor.nextRow();
            }
        } else {
            throw this.stateException(1069);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getFields", vector);
        }
        return vector;
    }

    public void setFields(Vector vector) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setFields", vector);
        }
        TupleCursor tupleCursor = this.body.setChoice(7, 5);
        this.cachedObjectBody = null;
        tupleCursor.truncateRows();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!(e instanceof String || e instanceof Integer || e instanceof Boolean || e instanceof Short || e instanceof Long || e instanceof byte[] || e instanceof Byte || e instanceof Character || e instanceof Double || e instanceof Float || e == null)) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1065, new Object[]{e}));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            TupleCursor tupleCursor2;
            Object e = vector.elementAt(n2);
            tupleCursor = tupleCursor.newRow();
            if (e instanceof String) {
                tupleCursor2 = tupleCursor.setChoice(0, 9);
            } else if (e instanceof Integer) {
                tupleCursor2 = tupleCursor.setChoice(0, 5);
            } else if (e instanceof Boolean) {
                tupleCursor2 = tupleCursor.setChoice(0, 1);
            } else if (e instanceof Short) {
                tupleCursor2 = tupleCursor.setChoice(0, 3);
            } else if (e instanceof Long) {
                tupleCursor2 = tupleCursor.setChoice(0, 6);
            } else if (e instanceof byte[] || e == null) {
                tupleCursor2 = tupleCursor.setChoice(0, 10);
            } else if (e instanceof Byte) {
                tupleCursor2 = tupleCursor.setChoice(0, 2);
            } else if (e instanceof Character) {
                tupleCursor2 = tupleCursor.setChoice(0, 4);
            } else if (e instanceof Double) {
                tupleCursor2 = tupleCursor.setChoice(0, 8);
            } else if (e instanceof Float) {
                tupleCursor2 = tupleCursor.setChoice(0, 7);
            } else {
                throw new InternalError(ExceptionBuilder.buildReasonString(1066, null));
            }
            if (e == null) {
                tupleCursor2.setByteArray(0, null);
            } else {
                tupleCursor2.setValue(0, e);
            }
            ++n2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setFields");
        }
    }

    public Dictionary getNamedFields() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getNamedFields");
        }
        Hashtable<String, Object> hashtable = null;
        if (this.body.getChoice(7) == 6) {
            hashtable = new Hashtable<String, Object>();
            TupleCursor tupleCursor = this.body.getContents(7).nextRow();
            while (tupleCursor != null) {
                Object object = tupleCursor.getContents(1).getValue(0);
                if (object != null) {
                    ((Dictionary)hashtable).put(tupleCursor.getString(0), object);
                }
                tupleCursor = tupleCursor.nextRow();
            }
        } else {
            throw this.stateException(1070);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getNamedFields", hashtable);
        }
        return hashtable;
    }

    public void setNamedFields(Dictionary dictionary) {
        Object object;
        Enumeration enumeration;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setNamedFields", dictionary);
        }
        TupleCursor tupleCursor = this.body.setChoice(7, 6);
        this.cachedObjectBody = null;
        tupleCursor.truncateRows();
        Enumeration enumeration2 = dictionary.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = enumeration2.nextElement();
            if (!(enumeration instanceof String)) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1065, new Object[]{enumeration}));
            }
            object = dictionary.get(enumeration);
            if (object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof byte[] || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Float) continue;
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1065, new Object[]{object}));
        }
        enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            TupleCursor tupleCursor2;
            object = (String)enumeration.nextElement();
            Object v = dictionary.get(object);
            tupleCursor = tupleCursor.newRow();
            tupleCursor.setString(0, (String)object);
            if (v instanceof String) {
                tupleCursor2 = tupleCursor.setChoice(1, 9);
            } else if (v instanceof Integer) {
                tupleCursor2 = tupleCursor.setChoice(1, 5);
            } else if (v instanceof Boolean) {
                tupleCursor2 = tupleCursor.setChoice(1, 1);
            } else if (v instanceof Short) {
                tupleCursor2 = tupleCursor.setChoice(1, 3);
            } else if (v instanceof Long) {
                tupleCursor2 = tupleCursor.setChoice(1, 6);
            } else if (v instanceof byte[]) {
                tupleCursor2 = tupleCursor.setChoice(1, 10);
            } else if (v instanceof Byte) {
                tupleCursor2 = tupleCursor.setChoice(1, 2);
            } else if (v instanceof Character) {
                tupleCursor2 = tupleCursor.setChoice(1, 4);
            } else if (v instanceof Double) {
                tupleCursor2 = tupleCursor.setChoice(1, 8);
            } else if (v instanceof Float) {
                tupleCursor2 = tupleCursor.setChoice(1, 7);
            } else {
                throw new InternalError(ExceptionBuilder.buildReasonString(1066, null));
            }
            tupleCursor2.setValue(0, v);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setNamedFields");
        }
    }

    public Dictionary getProperties() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getProperties");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.body.getChoice(6) == 1) {
            TupleCursor tupleCursor = this.body.getContents(6).nextRow();
            while (tupleCursor != null) {
                Object object = tupleCursor.getContents(1).getValue(0);
                if (object != null) {
                    ((Dictionary)hashtable).put(tupleCursor.getString(0), object);
                }
                tupleCursor = tupleCursor.nextRow();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getProperties", hashtable);
        }
        return hashtable;
    }

    public void setProperties(Dictionary dictionary) {
        Object object;
        Enumeration enumeration;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setProperties", dictionary);
        }
        TupleCursor tupleCursor = this.body.setChoice(6, 1);
        tupleCursor.truncateRows();
        Enumeration enumeration2 = dictionary.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = enumeration2.nextElement();
            if (!(enumeration instanceof String)) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1065, new Object[]{enumeration}));
            }
            object = dictionary.get(enumeration);
            if (object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof Byte || object instanceof Double || object instanceof Float) continue;
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1065, new Object[]{object}));
        }
        enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            TupleCursor tupleCursor2;
            object = (String)enumeration.nextElement();
            Object v = dictionary.get(object);
            tupleCursor = tupleCursor.newRow();
            tupleCursor.setString(0, (String)object);
            if (v instanceof String) {
                tupleCursor2 = tupleCursor.setChoice(1, 8);
            } else if (v instanceof Integer) {
                tupleCursor2 = tupleCursor.setChoice(1, 4);
            } else if (v instanceof Boolean) {
                tupleCursor2 = tupleCursor.setChoice(1, 1);
            } else if (v instanceof Short) {
                tupleCursor2 = tupleCursor.setChoice(1, 3);
            } else if (v instanceof Long) {
                tupleCursor2 = tupleCursor.setChoice(1, 5);
            } else if (v instanceof Byte) {
                tupleCursor2 = tupleCursor.setChoice(1, 2);
            } else if (v instanceof Double) {
                tupleCursor2 = tupleCursor.setChoice(1, 7);
            } else if (v instanceof Float) {
                tupleCursor2 = tupleCursor.setChoice(1, 6);
            } else {
                throw new InternalError(ExceptionBuilder.buildReasonString(1066, null));
            }
            tupleCursor2.setValue(0, v);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setProperties");
        }
    }

    public void clearProperties() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearProperties");
        }
        this.body.setChoice(6, 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearProperties");
        }
    }

    public String getCorrelationID() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getCorrelationID");
        }
        String string = null;
        if (this.body.getChoice(0) != 0) {
            string = this.body.getContents(0).getString(0);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getCorrelationID", string);
        }
        return string;
    }

    public void setCorrelationID(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setCorrelationID", string);
        }
        if (string == null) {
            this.body.setChoice(0, 0);
        } else {
            this.body.setChoice(0, 1).setString(0, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setCorrelationID");
        }
    }

    public long getMessageID() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMessageID");
        }
        long l = this.payload.getLong(0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMessageID", new Long(l));
        }
        return l;
    }

    public void setMessageID(long l) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setMessageID", new Long(l));
        }
        this.payload.setLong(0, l);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setMessageID");
        }
    }

    public int getPriority() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPriority");
        }
        byte by = this.msgTuple.getByte(3);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPriority", new Integer(by));
        }
        return by;
    }

    public void setPriority(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setPriority", new Integer(n));
        }
        this.msgTuple.setByte(3, (byte)n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setPriority");
        }
    }

    public long getTimestamp() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTimestamp");
        }
        long l = 0L;
        if (this.body.getChoice(1) != 0) {
            l = this.body.getContents(1).getLong(0);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTimestamp", new Long(l));
        }
        return l;
    }

    public void setTimestamp(long l) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTimestamp", new Long(l));
        }
        if (l == 0L) {
            this.body.setChoice(1, 0);
        } else {
            this.body.setChoice(1, 1).setLong(0, l);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTimestamp");
        }
    }

    public String getJMSTypeField() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSTypeField");
        }
        String string = null;
        if (this.body.getChoice(2) != 0) {
            string = this.body.getContents(2).getString(0);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSTypeField", string);
        }
        return string;
    }

    public void setJMSTypeField(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSTypeField", string);
        }
        if (string == null) {
            this.body.setChoice(2, 0);
        } else {
            this.body.setChoice(2, 1).setString(0, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSTypeField");
        }
    }

    public Topic getReplyTopic() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getReplyTopic");
        }
        String string = this.getReplyString();
        TopicImpl topicImpl = null;
        if (string != null) {
            topicImpl = new TopicImpl(string, true);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getReplyTopic", topicImpl);
        }
        return topicImpl;
    }

    public String getReplyString() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getReplyString");
        }
        String string = null;
        if (this.payload.getChoice(1) != 0) {
            string = this.toInternalTopic(this.payload.getContents(1).getString(0));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getReplyString", string);
        }
        return string;
    }

    public void setReplyTopic(Topic topic) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setReplyTopic", topic);
        }
        if (topic == null) {
            this.setReplyString(null);
        } else {
            this.setReplyString(((TopicImpl)topic).fullName);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setReplyTopic");
        }
    }

    public void setReplyString(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setReplyString", string);
        }
        if (string == null) {
            this.payload.setChoice(1, 0);
        } else {
            this.payload.setChoice(1, 1).setString(0, this.toExternalTopic(string));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setReplyString");
        }
    }

    public Topic getTopic() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTopic");
        }
        TopicImpl topicImpl = new TopicImpl(this.getTopicString(), true);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTopic", topicImpl);
        }
        return topicImpl;
    }

    public String getTopicString() {
        String string;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTopicString");
        }
        string = (string = this.msgTuple.getString(5)) != null && string.length() > 0 ? this.toInternalTopic(string) : null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTopicString", string);
        }
        return string;
    }

    public void setTopic(Topic topic) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTopic", topic);
        }
        this.setTopicString(((TopicImpl)topic).fullName);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTopic");
        }
    }

    public void setTopicString(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTopicString", string);
        }
        this.msgTuple.setString(5, this.toExternalTopic(string));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTopicString");
        }
    }

    public static String toDefaultExternalTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toDefaultExternalTopic", string);
        }
        String string2 = string.startsWith("\u0001TEMP/") ? "$TEMP/" + string.substring(BaseConfig.TEMP_TOPIC_PREFIX_LENGTH) : (string.startsWith("\u0001ISYS") ? "$ISYS" + string.substring(BaseConfig.CTLMSG_PREFIX_LENGTH) : "$TOPIC/" + string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "toDefaultExternalTopic", string2);
        }
        return string2;
    }

    private String toExternalTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toExternalTopic", string);
        }
        String string2 = string;
        if (this.topicsArePrefixed) {
            string2 = MessageImpl.toDefaultExternalTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "toExternalTopic", string2);
        }
        return string2;
    }

    public static String toDefaultInternalTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toDefaultInternalTopic", string);
        }
        String string2 = string.startsWith("$TEMP/") ? "\u0001TEMP/" + string.substring(BaseConfig.TEMP_TOPIC_PREFIX_LENGTH) : (string.startsWith("$ISYS") ? "\u0001ISYS" + string.substring(BaseConfig.CTLMSG_PREFIX_LENGTH) : string.substring(BaseConfig.TOPIC_PREFIX_LENGTH));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "toDefaultInternalTopic", string2);
        }
        return string2;
    }

    private String toInternalTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toInternalTopic", string);
        }
        String string2 = string;
        if (this.topicsArePrefixed) {
            string2 = MessageImpl.toDefaultInternalTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "toInternalTopic", string2);
        }
        return string2;
    }
}

