/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disthubmq.impl.client;

import com.ibm.disthubmq.client.Connector;
import com.ibm.disthubmq.client.Listener;
import com.ibm.disthubmq.client.Message;
import com.ibm.disthubmq.client.Topic;
import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.client.ClientServices;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.Logger;
import com.ibm.disthubmq.impl.client.MessageImpl;
import com.ibm.disthubmq.impl.client.Security;
import com.ibm.disthubmq.impl.client.TopicImpl;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.Envelop;
import com.ibm.disthubmq.impl.formats.Framing;
import com.ibm.disthubmq.impl.formats.MessageEncrypter;
import com.ibm.disthubmq.impl.formats.Schema;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.net.IMBSocketFactory;
import com.ibm.disthubmq.impl.net.ISocket;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.DebugState;
import com.ibm.disthubmq.impl.util.SegmentReader;
import com.ibm.disthubmq.impl.util.SimplestSegmentReader;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.disthubmq.spi.LogConstants;
import com.ibm.disthubmq.spi.LogRecorder;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ConnectorImpl
implements Connector,
Runnable,
LogConstants,
ExceptionConstants {
    private static final DebugObject debug = new DebugObject("ConnectorImpl");
    public static final int ERROR_CONNECTION_DROPPED = -5;
    public static final int ERROR_SUBSCRIBE_NOT_AUTHORIZED = -7;
    public static final int ERROR_INVALID_SUBJECT_SYNTAX = -15;
    public static final int ERROR_INVALID_QUERY_SYNTAX = -16;
    public static final int ERROR_SECURITY_GENERAL = -17;
    protected ISocket socket;
    private SegmentReader rdr;
    private OutputStream outStream;
    protected Listener listener;
    protected Exception lastException;
    protected Security security;
    private String ctlReplyTopic;
    protected String tempTopicPrefix;
    protected SchemaCursor pingReply;
    protected SchemaCursor notUnderstood;
    protected long messageId;
    private static byte[] empty = new byte[0];
    protected static final int DEFAULT_PRIORITY = 4;
    private static final int PING_PRIORITY = 11;
    private boolean oldBroker;
    protected int[] outReqs;
    protected static final int NUM_OUTREQS = 8;
    private static final Class[] consArgs = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConnectorImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConnectorImpl.class$("java.lang.String")) : class$java$lang$String};
    private int nSchemata;
    private long[] schemaIds;
    private static final int SCHEMA_ID_LEN = 2;
    protected Thread lThread;
    private static boolean initialized = false;
    private String happy = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$disthubmq$impl$client$ConnectorImpl;

    protected ConnectorImpl() {
    }

    public ConnectorImpl(String string, String string2, int n, String string3, String string4, Listener listener, boolean bl) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ConnectorImpl", string, string2, new Integer(n), string3, "********", listener, new Boolean(bl));
        }
        Class clazz = class$com$ibm$disthubmq$impl$client$ConnectorImpl == null ? (class$com$ibm$disthubmq$impl$client$ConnectorImpl = ConnectorImpl.class$("com.ibm.disthubmq.impl.client.ConnectorImpl")) : class$com$ibm$disthubmq$impl$client$ConnectorImpl;
        synchronized (clazz) {
            if (!initialized) {
                if (ClientServices.logRecorder == null) {
                    try {
                        ClientServices.logRecorder = (LogRecorder)Class.forName("com.ibm.gryphon.reference.ClientLogRecorder").newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (ClientServices.logRecorder != null) {
                    Logger.start();
                    try {
                        ClientServices.logRecorder.locked();
                        ClientServices.logRecorder.start();
                        Logger.connect();
                    }
                    catch (Exception exception) {
                        try {
                            ClientServices.logRecorder.stop();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        ClientServices.logRecorder = null;
                    }
                }
                DebugState.update();
                initialized = true;
            }
        }
        ConnectorImpl connectorImpl = this;
        synchronized (connectorImpl) {
            BaseConfig.noMoreChanges = true;
            this.security = this.getSecurity(string3, string4);
            this.listener = listener;
            this.socket = IMBSocketFactory.createSocket(string, string2, n);
            this.oldBroker = this.security.authorize(this.socket) < 65537;
            this.outStream = this.socket.getOutputStream();
            this.rdr = new SimplestSegmentReader(this.socket.getInputStream(), BaseConfig.EXPECTED_MESSAGE_SIZE);
            this.rdr.setParms((short)-13647, BaseConfig.MAX_MESSAGE_SIZE + BaseConfig.MESSAGE_SIZE_EXTRA_ALLOWANCE);
            this.rdr.prepGet(null);
            this.schemaIds = new long[2];
            SchemaRegistry.register(Envelop.thisSchema);
            this.outReqs = new int[8];
            this.pingReply = ConnectorImpl.newMessage(3, "", 11);
            this.notUnderstood = ConnectorImpl.newMessage(9, "", 4);
            this.notUnderstood.getContents().getContents(7).setInt(0, 65537);
            while (this.tempTopicPrefix == null) {
                this.handleMessage(this.receive());
            }
        }
        if (bl) {
            final ConnectorImpl connectorImpl2 = this;
            this.lThread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = new Thread(connectorImpl2);
                    thread.start();
                    return thread;
                }
            });
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ConnectorImpl");
        }
    }

    private Security getSecurity(String string, String string2) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSecurity", string, "********");
        }
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.ibm.disthubmq.impl.security.RealSecurity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("com.ibm.disthubmq.impl.client.NoSecurity");
            }
            Constructor<?> constructor = clazz.getConstructor(consArgs);
            Security security = (Security)constructor.newInstance(string, string2);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "getSecurity", security);
            }
            return security;
        }
        catch (Exception exception) {
            throw new IOException(ExceptionBuilder.buildReasonString(1059, null));
        }
    }

    protected synchronized int getTrackingNumber() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTrackingNumber");
        }
        int n = 0;
        while (n < this.outReqs.length) {
            if (this.outReqs[n] == 0) break;
            ++n;
        }
        if (n == this.outReqs.length) {
            int[] nArray = new int[this.outReqs.length * 2];
            System.arraycopy(this.outReqs, 0, nArray, 0, this.outReqs.length);
            this.outReqs = nArray;
        }
        this.outReqs[n] = -1;
        int n2 = n + 1;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTrackingNumber", new Integer(n2));
        }
        return n2;
    }

    protected synchronized int waitFor(int n) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "waitFor", new Integer(n));
        }
        --n;
        while (this.outReqs[n] == -1 && this.lastException == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.checkException();
        int n2 = this.outReqs[n];
        this.outReqs[n] = 0;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "waitFor", new Integer(n2));
        }
        return n2;
    }

    protected static SchemaCursor newMessage(int n, String string, int n2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newMessage", new Integer(n), string, new Integer(n2));
        }
        SchemaCursor schemaCursor = SchemaRegistry.getSchemaCursor((short)0, -8843998126721588213L);
        TupleCursor tupleCursor = schemaCursor.getContents();
        tupleCursor.setByteArray(0, empty);
        tupleCursor.setBoolean(1, false);
        tupleCursor.setChoice(2, 0);
        tupleCursor.setByte(3, (byte)n2);
        tupleCursor.setBoolean(4, false);
        tupleCursor.setString(5, string);
        tupleCursor.setChoice(6, 1).setChoice(0, 0);
        tupleCursor.setChoice(7, n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newMessage", schemaCursor);
        }
        return schemaCursor;
    }

    static SchemaCursor newNormalMessage(String string, int n, String string2, int n2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "normalMessage", string, new Integer(n), string2, new Integer(n2));
        }
        SchemaCursor schemaCursor = ConnectorImpl.newMessage(1, string, 4);
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        if (string2 == null) {
            tupleCursor.setChoice(1, 0);
        } else {
            tupleCursor.setChoice(1, 1).setString(0, string2);
        }
        if (n2 == 0) {
            tupleCursor.setChoice(2, 0);
        } else {
            tupleCursor.setChoice(2, 1).setInt(0, n2);
        }
        tupleCursor.setChoice(3, n);
        tupleCursor.setLong(0, 0L);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "normalMessage", schemaCursor);
        }
        return schemaCursor;
    }

    protected static SchemaCursor newControlMessage(int n, int n2) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newControlMessage", new Integer(n), new Integer(n2));
        }
        SchemaCursor schemaCursor = ConnectorImpl.newMessage(10, "", 4);
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        if (n2 == 0) {
            tupleCursor.setChoice(0, 0);
        } else {
            tupleCursor.setChoice(0, 1).setInt(0, n2);
        }
        tupleCursor.setChoice(1, n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newControlMessage", schemaCursor);
        }
        return schemaCursor;
    }

    public Exception getException() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getException");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getException", this.lastException);
        }
        return this.lastException;
    }

    protected void checkException() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "checkException");
        }
        if (this.lastException != null) {
            this.rdr = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.lastException instanceof IOException) {
                throw (IOException)this.lastException;
            }
            if (this.lastException instanceof RuntimeException) {
                throw (RuntimeException)this.lastException;
            }
            throw new IOException(ExceptionBuilder.buildReasonString(1060, new Object[]{this.lastException}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "checkException");
        }
    }

    public Topic createTemporaryTopic(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTemporaryTopic");
        }
        TopicImpl topicImpl = new TopicImpl(this.createTemporaryTopicString(string), true);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTemporaryTopic", topicImpl);
        }
        return topicImpl;
    }

    protected String createTemporaryTopicString(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTemporaryTopicString");
        }
        String string2 = this.tempTopicPrefix + "/" + string;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTemporaryTopicString", string2);
        }
        return string2;
    }

    private String ctlMsgTopic(String string) {
        return MessageImpl.toDefaultExternalTopic(BaseConfig.getClientToServerControlMessageTopic(string));
    }

    public void startDelivery() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "startDelivery");
        }
        int n = this.getTrackingNumber();
        if (this.oldBroker) {
            this.send(ConnectorImpl.newNormalMessage(this.ctlMsgTopic("startDelivery"), 1, this.ctlReplyTopic, n));
        } else {
            this.send(ConnectorImpl.newControlMessage(5, n));
        }
        this.waitFor(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "startDelivery");
        }
    }

    public void stopDelivery() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stopDelivery");
        }
        int n = this.getTrackingNumber();
        if (this.oldBroker) {
            this.send(ConnectorImpl.newNormalMessage(this.ctlMsgTopic("stopDelivery"), 1, this.ctlReplyTopic, n));
        } else {
            this.send(ConnectorImpl.newControlMessage(7, n));
        }
        this.waitFor(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stopDelivery");
        }
    }

    public int subscribe(Topic topic, String string) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "subscribe", topic, string);
        }
        int n = this.subscribe(((TopicImpl)topic).fullName, string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "subscribe", new Integer(n));
        }
        return n;
    }

    public synchronized int subscribe(String string, String string2) throws IOException {
        TupleCursor tupleCursor;
        SchemaCursor schemaCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "subscribe", string, string2);
        }
        if (string.startsWith("\u0001TEMP/") && !string.startsWith(this.tempTopicPrefix)) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1061, new Object[]{string}));
        }
        string2 = string2 == null ? "" : string2;
        int n = this.getTrackingNumber();
        if (this.oldBroker) {
            schemaCursor = ConnectorImpl.newNormalMessage(this.ctlMsgTopic("subscribe"), 2, this.ctlReplyTopic, n);
            tupleCursor = schemaCursor.getContents().getContents(7).getContents(3);
            tupleCursor.setString(0, MessageImpl.toDefaultExternalTopic(string));
            tupleCursor.setString(1, string2);
        } else {
            schemaCursor = ConnectorImpl.newControlMessage(1, n);
            tupleCursor = schemaCursor.getContents().getContents(7).getContents(1);
            tupleCursor.setString(0, MessageImpl.toDefaultExternalTopic(string));
            tupleCursor.setString(1, string2);
        }
        this.send(schemaCursor);
        int n2 = this.waitFor(n);
        switch (n2) {
            case -5: {
                throw new IOException(ExceptionBuilder.buildReasonString(1063, null));
            }
            case -7: {
                throw new IOException(ExceptionBuilder.buildReasonString(1312, new Object[]{string}));
            }
            case -15: {
                throw new IOException(ExceptionBuilder.buildReasonString(1122, new Object[]{string}));
            }
            case -16: {
                throw new IOException(ExceptionBuilder.buildReasonString(1122, new Object[]{string2}));
            }
            case -17: {
                throw new IOException(ExceptionBuilder.buildReasonString(1313, new Object[]{string}));
            }
        }
        Assert.condition(n2 > 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "unsubscribe", new Integer(n2));
        }
        return n2;
    }

    public void unsubscribe(int n) throws IOException {
        SchemaCursor schemaCursor;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "unsubscribe", new Integer(n));
        }
        int n2 = this.getTrackingNumber();
        if (this.oldBroker) {
            schemaCursor = ConnectorImpl.newNormalMessage(this.ctlMsgTopic("unsubscribe"), 3, this.ctlReplyTopic, n2);
            schemaCursor.getContents().getContents(7).getContents(3).setInt(0, n);
        } else {
            schemaCursor = ConnectorImpl.newControlMessage(3, n2);
            schemaCursor.getContents().getContents(7).getContents(1).setInt(0, n);
        }
        this.send(schemaCursor);
        this.waitFor(n2);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "unsubscribe");
        }
    }

    public synchronized void close(boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close", new Boolean(bl));
        }
        if (this.rdr == null) {
            return;
        }
        try {
            if (!bl) {
                int n = this.getTrackingNumber();
                if (this.oldBroker) {
                    this.send(ConnectorImpl.newNormalMessage(this.ctlMsgTopic("disconnect"), 1, this.ctlReplyTopic, n));
                } else {
                    this.send(ConnectorImpl.newControlMessage(9, n));
                }
                this.waitFor(n);
            }
            this.rdr = null;
            this.socket.close();
            if (this.lThread != null) {
                this.lThread.stop();
            }
        }
        catch (IOException iOException) {
            this.lastException = iOException;
        }
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "run");
        }
        try {
            while (this.rdr != null) {
                this.handleMessage(this.receive());
            }
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "run");
        }
    }

    protected void setException(Exception exception) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setException", exception);
        }
        ConnectorImpl connectorImpl = this;
        synchronized (connectorImpl) {
            this.lastException = exception;
            this.notifyAll();
        }
        this.connectionDropped();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setException");
        }
    }

    protected void connectionDropped() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "connectionDropped");
        }
        this.listener.onMessage(null);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "connectionDropped");
        }
    }

    protected byte[] receive() throws IOException {
        byte[] byArray;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "receive");
        }
        if ((byArray = this.rdr.get()) == null) {
            throw new EOFException(ExceptionBuilder.buildReasonString(1062, null));
        }
        this.rdr.prepGet(null);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "receive", byArray);
        }
        return byArray;
    }

    protected void handleMessage(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleMessage", byArray);
        }
        MessageEncrypter messageEncrypter = this.security.incoming(byArray);
        short s = Framing.interpId(byArray);
        if (s == -1) {
            SchemaRegistry.register(byArray, Framing.propagationBodyOffset(byArray));
        } else {
            long l = Framing.schemaId(byArray);
            byte by = Framing.qop(byArray);
            int n = by == 14 ? Framing.sksl(byArray) : -1;
            SchemaCursor schemaCursor = l == -8843998126721588213L ? SchemaRegistry.getSchemaCursor(s, l) : SchemaRegistry.getSchemaCursor(s, l, Envelop.thisSchema);
            int n2 = Framing.bodyOffset(byArray);
            int n3 = Framing.fullLength(byArray) - n2;
            ByteSequence byteSequence = new ByteSequence(byArray, n2, n3);
            schemaCursor.decode(byteSequence, 0, n, messageEncrypter);
            switch (schemaCursor.getContents().getChoice(7)) {
                case 1: {
                    this.handleNormal(schemaCursor);
                    break;
                }
                case 5: {
                    this.handleConnGrant(schemaCursor);
                    break;
                }
                case 8: {
                    this.security.qopUpdate(schemaCursor);
                    break;
                }
                case 2: {
                    this.send(this.pingReply);
                    break;
                }
                case 4: 
                case 6: {
                    throw new IOException(ExceptionBuilder.buildReasonString(1063, null));
                }
                case 10: {
                    this.handleControl(schemaCursor);
                    break;
                }
                case 3: {
                    break;
                }
                case 7: {
                    this.handleFeatureExchange(schemaCursor);
                    break;
                }
                default: {
                    this.send(this.notUnderstood);
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleMessage");
        }
    }

    protected void handleConnGrant(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleConnGrant", schemaCursor);
        }
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        int n = tupleCursor.getInt(0);
        int n2 = tupleCursor.getInt(1);
        this.messageId = (long)tupleCursor.getInt(2) << 32;
        if (this.oldBroker) {
            this.ctlReplyTopic = "\u0001ISYS/REPLY/" + n + "/" + n2;
        }
        this.tempTopicPrefix = "\u0001TEMP/" + n + "/" + n2;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleConnGrant");
        }
    }

    protected void handleNormal(SchemaCursor schemaCursor) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleNormal", schemaCursor);
        }
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        switch (tupleCursor.getChoice(3)) {
            case 3: {
                int n = tupleCursor.getContents(3).getInt(0);
                this.postTrack(tupleCursor, n);
                break;
            }
            case 4: {
                this.newJMSMessage(schemaCursor);
                break;
            }
            case 1: {
                this.postTrack(tupleCursor, 1);
                break;
            }
            default: {
                throw new IOException(ExceptionBuilder.buildReasonString(1063, null));
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleNormal");
        }
    }

    protected void newJMSMessage(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newJMSMessage", schemaCursor);
        }
        this.listener.onMessage(new MessageImpl(schemaCursor));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newJMSMessage");
        }
    }

    protected void handleControl(SchemaCursor schemaCursor) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleControl", schemaCursor);
        }
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        switch (tupleCursor.getChoice(1)) {
            case 2: {
                int n = tupleCursor.getContents(1).getInt(0);
                this.postTrack(tupleCursor, n);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                this.postTrack(tupleCursor, 1);
                break;
            }
            default: {
                throw new IOException(ExceptionBuilder.buildReasonString(1063, null));
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleControl");
        }
    }

    protected void handleFeatureExchange(SchemaCursor schemaCursor) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleFeatureExchange", schemaCursor);
        }
        if (!schemaCursor.getContents().getContents(7).getBoolean(0)) {
            return;
        }
        SchemaCursor schemaCursor2 = ConnectorImpl.newMessage(7, "", 4);
        TupleCursor tupleCursor = schemaCursor2.getContents().getContents(7);
        tupleCursor.setChoice(1, 0).truncateRows();
        tupleCursor.setBoolean(0, false);
        this.send(schemaCursor2);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleFeatureExchange");
        }
    }

    private synchronized void postTrack(TupleCursor tupleCursor, int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "postTrack", tupleCursor, new Integer(n));
        }
        int n2 = this.oldBroker ? tupleCursor.getContents(2).getInt(0) : tupleCursor.getContents(0).getInt(0);
        this.outReqs[n2 - 1] = n;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "postTrack");
        }
    }

    public void send(Message message) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "sendMessage", message);
        }
        this.send(((MessageImpl)message).cursor);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "send");
        }
    }

    public synchronized void send(SchemaCursor schemaCursor) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "send", schemaCursor);
        }
        if (schemaCursor == null) {
            throw new IllegalArgumentException(ExceptionBuilder.buildReasonString(1064, null));
        }
        this.checkException();
        TupleCursor tupleCursor = schemaCursor.getContents();
        if (tupleCursor.getChoice(7) == 1) {
            tupleCursor.getContents(7).setLong(0, ++this.messageId);
        }
        try {
            ByteSequence byteSequence;
            byte by = this.security.getQop(schemaCursor);
            byte[] byArray = null;
            if (!schemaCursor.needsEncoding() && (byteSequence = schemaCursor.getRawMessage()) != null && Framing.qop(byArray = byteSequence.linearize()) != by) {
                byArray = null;
            }
            byteSequence = this.getPropagationMessages(schemaCursor.getSchemata());
            while (byteSequence != null) {
                this.outStream.write(byteSequence.frame, byteSequence.offset, byteSequence.framelen);
                byteSequence = byteSequence.next;
            }
            if (byArray == null) {
                byArray = this.security.outgoing(schemaCursor, by);
            }
            this.outStream.write(byArray, 0, Framing.fullLength(byArray));
            this.outStream.flush();
        }
        catch (Exception exception) {
            this.lastException = exception;
        }
        this.checkException();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "send");
        }
    }

    public String hostandportString() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "hostandportString");
        }
        if (this.happy == null) {
            this.happy = this.socket.getSocket().getInetAddress().toString() + ':' + this.socket.getSocket().getPort() + ':' + this.socket.getSocket().getLocalPort();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "hostandportString", this.happy);
        }
        return this.happy;
    }

    private final ByteSequence getPropagationMessages(Schema[] schemaArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPropagationMessages", schemaArray);
        }
        ByteSequence byteSequence = null;
        int n = 0;
        while (n < schemaArray.length) {
            boolean bl = true;
            long l = schemaArray[n].getId();
            int n2 = 0;
            while (n2 < this.nSchemata) {
                if (l == this.schemaIds[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                this.recordSchemaId(l);
                ByteSequence byteSequence2 = SchemaRegistry.getPropagationMessage(schemaArray[n]);
                byte[] byArray = this.security.framePropagationMessage(byteSequence2);
                if (byteSequence == null) {
                    byteSequence = new ByteSequence(byArray, 0, byArray.length);
                } else {
                    byteSequence.append(new ByteSequence(byArray, 0, byArray.length));
                }
            }
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPropagationMessages", byteSequence);
        }
        return byteSequence;
    }

    private final void recordSchemaId(long l) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "recordSchemaId", new Long(l));
        }
        if (this.nSchemata == this.schemaIds.length) {
            long[] lArray = new long[this.nSchemata * 2];
            System.arraycopy(this.schemaIds, 0, lArray, 0, this.nSchemata);
            this.schemaIds = lArray;
        }
        this.schemaIds[this.nSchemata++] = l;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "recordSchemaId");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

