/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.utils;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class VariableFinder {
    private static Logger log = Logger.getLogger(VariableFinder.class);
    Hashtable<String, String> table = new Hashtable();
    String pathXsl;
    String pathConfig;

    public VariableFinder(String pathXsl, String pathConfig) {
        this.pathXsl = pathXsl;
        this.pathConfig = pathConfig;
        this.loadVariables();
    }

    private void loadVariables() {
        File fXsl = new File(this.pathXsl);
        File fConfig = new File(this.pathConfig);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            StringWriter out = new StringWriter();
            log.debug((Object)"create transformer for looking up variables");
            Transformer varTransformer = factory.newTransformer(new StreamSource(fXsl));
            varTransformer.transform(new StreamSource(fConfig), new StreamResult(out));
            String result = "";
            if (out.getBuffer() != null) {
                result = out.getBuffer().toString();
            }
            log.info((Object)("variables found : " + result));
            String[] vars = result.split("\\n");
            int i = 0;
            while (i < vars.length) {
                this.table.put(vars[i].trim(), "");
                ++i;
            }
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Error creating transformer", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Error in transformation", (Throwable)e);
        }
    }

    public String[] getVariableNames() {
        Enumeration<String> keys = this.getTable().keys();
        ArrayList<String> variableList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            if (name.trim().length() <= 0) continue;
            log.debug((Object)("gevonden variable in template " + name));
            variableList.add(name);
        }
        String[] stringList = new String[variableList.size()];
        return variableList.toArray(stringList);
    }

    public static void main(String[] args) {
        VariableFinder variableFinder = new VariableFinder("find_var.xsl", "user_template2.xslt");
        Enumeration<String> keys = variableFinder.getTable().keys();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            if (name.trim().length() <= 0) continue;
            System.out.println("gevonden variable " + name);
        }
    }

    public Hashtable<String, String> getTable() {
        return this.table;
    }

    public void setTable(Hashtable<String, String> table) {
        this.table = table;
    }

    public String getPathXsl() {
        return this.pathXsl;
    }

    public void setPathXsl(String pathXsl) {
        this.pathXsl = pathXsl;
    }

    public String getPathConfig() {
        return this.pathConfig;
    }

    public void setPathConfig(String pathConfig) {
        this.pathConfig = pathConfig;
    }
}

