/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.om.NodeInfo;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ParameterFinder {
    File fXsl = null;
    private static Logger log = Logger.getLogger(ParameterFinder.class);

    public ParameterFinder(File xsl) {
        this.fXsl = xsl;
    }

    public String[] getParameterNames() throws FileNotFoundException, XPathExpressionException {
        InputSource inputSource = new InputSource(new FileInputStream(this.fXsl));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                log.debug((Object)("getNamespaceURI(" + prefix + ")"));
                if (prefix.equals("xsl")) {
                    return "http://www.w3.org/1999/XSL/Transform";
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                log.debug((Object)("getPrefix(" + namespaceURI + ")"));
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                log.debug((Object)("getPrefixes(" + namespaceURI + ")"));
                return null;
            }
        });
        String expression = "/xsl:stylesheet/xsl:param/@name";
        Object o = xPath.evaluate(expression, inputSource, XPathConstants.NODESET);
        if (o instanceof NodeList) {
            NodeList nodes = (NodeList)o;
            String[] stringList = new String[nodes.getLength()];
            int i = 0;
            while (i < nodes.getLength()) {
                log.debug((Object)("gevonden parameters in template " + nodes.item(i).getNodeValue()));
                stringList[i] = nodes.item(i).getNodeValue();
                ++i;
            }
            return stringList;
        }
        if (o instanceof ArrayList) {
            ArrayList nodes = (ArrayList)o;
            String[] stringList = new String[nodes.size()];
            int i = 0;
            while (i < nodes.size()) {
                Object node = nodes.get(i);
                if (!(node instanceof NodeInfo)) {
                    log.debug((Object)"node is geen saxon NodeInfo");
                }
                NodeInfo nodeInfo = (NodeInfo)nodes.get(i);
                log.debug((Object)("gevonden parameters in template " + nodeInfo.getStringValue()));
                stringList[i] = nodeInfo.getStringValue();
                ++i;
            }
            return stringList;
        }
        return new String[0];
    }
}

