/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.utils;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.csv.io.Record;
import com.donkeydevelopment.csvexcel.gui.popup.FileNameMappingPopup;
import com.donkeydevelopment.csvexcel.gui.popup.FileNameMappingPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.ParameterMappingPopup;
import com.donkeydevelopment.csvexcel.gui.popup.ParameterMappingPopupVO;
import com.donkeydevelopment.csvexcel.mapping.ParameterMapping;
import com.donkeydevelopment.csvexcel.mapping.ParameterMappingList;
import com.donkeydevelopment.csvexcel.row.FileRow;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Helper {
    private static Logger log = Logger.getLogger(Helper.class);

    public static Document getDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.FALSE);
        DocumentBuilder parser = factory.newDocumentBuilder();
        try {
            return parser.parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXException e) {
            log.error((Object)"Could create xml document from parameter values");
            log.error((Object)"This is mostly caused by special characters used in the variable names in the template");
            log.error((Object)("Used xml " + xml));
            throw e;
        }
    }

    public static Object getNodeSet(Document doc) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPathExpression xPathExpression = factory.newXPath().compile("/");
        Object o = xPathExpression.evaluate(doc, XPathConstants.NODESET);
        return o;
    }

    public static FileNameMappingPopupVO getFileNameMapping(String[] columnList, String groupOn) {
        FileNameMappingPopupVO answer = new FileNameMappingPopupVO();
        answer.setColumnList(columnList);
        answer.setGroupOn(groupOn);
        FileNameMappingPopup popup = new FileNameMappingPopup((JFrame)Frame.getInstance(), "FileNameMapping", true, answer);
        popup.showDialog();
        return answer;
    }

    public static String getSeparator(Component parent, String defaultSeparator) {
        Object[] possibilities = new Object[]{"comma     (,)", "semicolon (;)", "tab"};
        String s = (String)JOptionPane.showInputDialog(parent, "Select the column separator in the file", "Separator selection", -1, null, possibilities, defaultSeparator);
        if (s != null && s.length() > 0) {
            log.info((Object)("Separator choosen = " + s));
        }
        if (s != null) {
            if (s.startsWith("comma")) {
                return "comma";
            }
            if (s.startsWith("semicolon")) {
                return "semicolon";
            }
            if (s.startsWith("tab")) {
                return "tab";
            }
        }
        return null;
    }

    public static char getSeparatorAsChar(String separator) throws Exception {
        if (separator != null) {
            if (separator.equalsIgnoreCase("tab")) {
                return '\t';
            }
            if (separator.equalsIgnoreCase("semicolon") || separator.equals(";")) {
                return ';';
            }
            if (separator.equalsIgnoreCase("comma") || separator.equals(",")) {
                return ',';
            }
            if (separator.length() == 1) {
                return separator.charAt(0);
            }
            throw new Exception("Use tab, semicolon, comma or a custom 1 character-string as separator ");
        }
        return ';';
    }

    public static ParameterMappingPopupVO mapColumns(String[] parameterList, String[] columnList) {
        ParameterMappingPopupVO answer = new ParameterMappingPopupVO();
        ArrayList<ParameterMapping> mappingList = new ArrayList<ParameterMapping>();
        boolean i = false;
        String[] stringArray = parameterList;
        int n = parameterList.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName = stringArray[n2];
            ParameterMapping mapping = new ParameterMapping();
            mapping.setParameterName(parameterName);
            int mostSimilarcolnr = Helper.getMostSimilarString(parameterName, columnList);
            mapping.setColumnNr(mostSimilarcolnr);
            mapping.setColumnName(columnList[mostSimilarcolnr]);
            mappingList.add(mapping);
            ++n2;
        }
        ParameterMappingList parameterMappingList = new ParameterMappingList();
        parameterMappingList.setMappings(mappingList);
        answer.setMappingList(parameterMappingList);
        answer.setColumnList(columnList);
        answer.setInfoText("Map columns in the input file to parameter names in the stylesheet.\nYou can change the mapping by clicking the in the second column.\nA listbox will appear, in which you can select another column");
        ParameterMappingPopup popup = new ParameterMappingPopup((JFrame)Frame.getInstance(), "Mappings", true, answer);
        popup.showDialog();
        return answer;
    }

    public static int getMostSimilarString(String s, String[] searchList) {
        int bestDistance = 99;
        int bestIndex = 0;
        int i = 0;
        String[] stringArray = searchList;
        int n = searchList.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            int difference = StringUtils.getLevenshteinDistance((CharSequence)s.toUpperCase(), (CharSequence)item.toUpperCase());
            if (difference < bestDistance) {
                bestDistance = difference;
                bestIndex = i;
            } else if (difference == bestDistance && StringUtils.indexOfDifference((CharSequence)s.toUpperCase(), (CharSequence)item.toUpperCase()) > StringUtils.indexOfDifference((CharSequence)s.toUpperCase(), (CharSequence)searchList[bestIndex].toUpperCase())) {
                bestDistance = difference;
                bestIndex = i;
            }
            ++i;
            ++n2;
        }
        return bestIndex;
    }

    public static String getMostLikelySeparator(Record record) {
        String[] separatorList = new String[]{"comma     (,)", "semicolon (;)", "tab"};
        int index = 0;
        if (record != null) {
            String[] fieldsSemicolon;
            int count = -1;
            index = 0;
            String[] fieldsComma = record.getLine().split(",");
            count = fieldsComma.length;
            String[] fieldsTab = record.getLine().split("\\t");
            if (fieldsTab.length > count) {
                count = fieldsTab.length;
                index = 2;
            }
            if ((fieldsSemicolon = record.getLine().split(";")).length > count) {
                count = fieldsSemicolon.length;
                index = 1;
            }
        }
        return separatorList[index];
    }

    public static File getFileOut(File fOutputDir, FileNameMappingPopupVO fileNameMappingAnswer, FileRow fileRow, int rownr) {
        DecimalFormat numberFormatter = new DecimalFormat("0000000");
        String filename = null;
        if (fileNameMappingAnswer.isUseColumn()) {
            int filenameColumnNr = fileNameMappingAnswer.getSelectedIndx();
            String columnName = fileNameMappingAnswer.getColumnList()[filenameColumnNr];
            filename = fileRow.getValueAsString(columnName);
        } else {
            filename = fileNameMappingAnswer.getFilePrefix();
        }
        if (fileNameMappingAnswer.isUseRowSuffix()) {
            filename = String.valueOf(filename) + "_" + numberFormatter.format(rownr);
        }
        if (!filename.endsWith(".xml")) {
            filename = String.valueOf(filename) + ".xml";
        }
        File fOut = new File(fOutputDir, filename);
        return fOut;
    }
}

