/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileChooser {
    public static File chooseFile(Component parent, String description, FileFilter[] filterList, FileFilter currentFilter, File fLastSelected) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileView(new FileView(){

            @Override
            public Icon getIcon(File f) {
                return FileSystemView.getFileSystemView().getSystemIcon(f);
            }
        });
        Action details = chooser.getActionMap().get("viewTypeDetails");
        if (details != null) {
            details.actionPerformed(null);
        }
        chooser.setPreferredSize(new Dimension(640, 480));
        chooser.setDialogTitle(description);
        chooser.setAcceptAllFileFilterUsed(true);
        if (filterList != null) {
            FileFilter[] fileFilterArray = filterList;
            int n = filterList.length;
            int n2 = 0;
            while (n2 < n) {
                FileFilter filter = fileFilterArray[n2];
                chooser.addChoosableFileFilter(filter);
                ++n2;
            }
            if (currentFilter != null) {
                chooser.setFileFilter(currentFilter);
            }
        }
        chooser.setCurrentDirectory(fLastSelected);
        if (fLastSelected != null && fLastSelected.isFile()) {
            chooser.setSelectedFile(fLastSelected);
        }
        if ((returnVal = chooser.showOpenDialog(parent)) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static File chooseFile(Component parent, String description, FileFilter filter, File fLastSelected) {
        return FileChooser.chooseFile(parent, description, new FileFilter[]{filter}, filter, fLastSelected);
    }

    public static File getOutputDirectory(Component parent, File startDir, String description) {
        JFileChooser fc = new JFileChooser();
        fc.setFileView(new FileView(){

            @Override
            public Icon getIcon(File f) {
                return FileSystemView.getFileSystemView().getSystemIcon(f);
            }
        });
        fc.setDialogTitle(description);
        Action details = fc.getActionMap().get("viewTypeDetails");
        if (details != null) {
            details.actionPerformed(null);
        }
        fc.setFileSelectionMode(1);
        if (startDir != null) {
            fc.setCurrentDirectory(startDir);
        }
        fc.setPreferredSize(new Dimension(640, 480));
        int ret = fc.showSaveDialog(parent);
        switch (ret) {
            case 0: {
                return fc.getSelectedFile();
            }
        }
        return null;
    }

    public static File getOutputFile(Component parent, String description, FileFilter[] filterList, FileFilter currentFilter, File fStart) {
        JFileChooser fc = new JFileChooser();
        fc.setFileView(new FileView(){

            @Override
            public Icon getIcon(File f) {
                return FileSystemView.getFileSystemView().getSystemIcon(f);
            }
        });
        Action details = fc.getActionMap().get("viewTypeDetails");
        if (details != null) {
            details.actionPerformed(null);
        }
        if (filterList != null) {
            FileFilter[] fileFilterArray = filterList;
            int n = filterList.length;
            int n2 = 0;
            while (n2 < n) {
                FileFilter filter = fileFilterArray[n2];
                fc.addChoosableFileFilter(filter);
                ++n2;
            }
            if (currentFilter != null) {
                fc.setFileFilter(currentFilter);
            }
        }
        fc.setDialogTitle(description);
        fc.setFileSelectionMode(0);
        fc.setCurrentDirectory(fStart);
        if (fStart != null && fStart.exists() && fStart.isFile()) {
            fc.setSelectedFile(fStart);
        }
        fc.setPreferredSize(new Dimension(640, 480));
        int ret = fc.showSaveDialog(parent);
        switch (ret) {
            case 0: {
                return fc.getSelectedFile();
            }
        }
        return null;
    }

    public static File getOutputFile(Component parent, String description, FileFilter filter, File fLastSelected) {
        return FileChooser.getOutputFile(parent, description, new FileFilter[]{filter}, filter, fLastSelected);
    }
}

