/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.row;

import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.row.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultRow
implements Row {
    HashMap<String, String> rowStringMap = new HashMap();
    ArrayList<String> columns = new ArrayList();
    private static Logger log = Logger.getLogger(DefaultRow.class);

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<row>");
        for (String colname : this.columns) {
            sb.append(XMLWriter.normalizeAndPrint(colname, this.rowStringMap.get(colname)));
        }
        sb.append("</row>");
        return sb.toString();
    }

    @Override
    public String getValueAsString(String colname) {
        return this.rowStringMap.get(colname);
    }

    public Object getValueAsObject(String colname) {
        return this.rowStringMap.get(colname);
    }

    @Override
    public boolean hasColumn(String colname) {
        return this.rowStringMap.containsKey(colname);
    }

    public static String substituteRowReferences(Row row, int rowCount, String definedValue, boolean required, boolean isSQL) throws Exception {
        StringBuffer sb = new StringBuffer();
        int fromIndex = 0;
        int pos = definedValue.indexOf("@{", fromIndex);
        while (pos > -1) {
            sb.append(definedValue.substring(fromIndex, pos));
            int end = definedValue.indexOf("}", pos);
            if (end > -1) {
                int closeBr;
                String colRef = definedValue.substring(pos + 2, end);
                log.debug((Object)("found row column reference " + colRef));
                int parentNr = 0;
                String colName = null;
                if (colRef.startsWith("MAXROWS[]")) {
                    closeBr = colRef.indexOf("]");
                    int maxrow = Integer.parseInt(colRef.substring(closeBr + 1));
                    int groupnr = 0;
                    groupnr = rowCount > 0 ? (rowCount - 1) / maxrow : rowCount / maxrow;
                    sb.append(groupnr);
                    log.debug((Object)("found rowCount: " + rowCount));
                    log.debug((Object)("found maxrows: " + maxrow));
                    log.debug((Object)("current groupnr: " + groupnr));
                } else {
                    if (colRef.startsWith("ROW[")) {
                        closeBr = colRef.indexOf("]");
                        parentNr = Integer.parseInt(colRef.substring(4, closeBr));
                        colName = colRef.substring(closeBr + 1);
                    } else {
                        colName = colRef;
                    }
                    Row targetRow = row;
                    int i = 0;
                    while (i < parentNr) {
                        if (targetRow == null) {
                            throw new Exception("Cannot get parent from row[" + i + "]");
                        }
                        targetRow = targetRow.getParent();
                        ++i;
                    }
                    if (targetRow == null) {
                        throw new Exception("target row for column value is null: " + colRef);
                    }
                    if (!targetRow.hasColumn(colName)) {
                        if (required) {
                            throw new Exception(String.valueOf(colName) + " does not exist");
                        }
                        log.warn((Object)("Null value for: " + colRef));
                    }
                    String value = targetRow.getValueAsString(colName);
                    if (isSQL) {
                        sb.append("'" + DefaultRow.escapeQuote(value) + "'");
                    } else {
                        sb.append(value);
                    }
                }
                fromIndex = end + 1;
                pos = definedValue.indexOf("@{", fromIndex);
                continue;
            }
            log.warn((Object)("no closing } found in " + definedValue.substring(fromIndex)));
            break;
        }
        sb.append(definedValue.substring(fromIndex));
        return sb.toString();
    }

    private static String escapeQuote(String value) {
        if (value != null) {
            return value.replaceAll("'", "''");
        }
        return value;
    }

    @Override
    public Row getParent() {
        return null;
    }
}

