/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.prefs;

import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;

public class CsvExcelXMLPreferences {
    ArrayList<String> recentMappingFiles = new ArrayList();
    private static int MAX_RECENT_MAPPING_FILES = 15;
    private String lastCsvInput = null;
    private String lastExcelInput = null;
    private String lastTemplate = null;
    private String lastOutputDir = null;
    private File fPrefs = null;
    private static CsvExcelXMLPreferences preferences = null;
    private static Logger log = Logger.getLogger(CsvExcelXMLPreferences.class);

    public void addRecentMappingFile(String filePath) {
        this.recentMappingFiles.add(filePath);
    }

    public void addNewestRecentMappingFile(String filePath) {
        this.recentMappingFiles.add(0, filePath);
        int i = 1;
        while (i < this.recentMappingFiles.size()) {
            String path = this.recentMappingFiles.get(i);
            if (filePath.equalsIgnoreCase(path)) {
                this.recentMappingFiles.remove(i);
            }
            ++i;
        }
        if (this.recentMappingFiles.size() > MAX_RECENT_MAPPING_FILES) {
            this.recentMappingFiles.remove(MAX_RECENT_MAPPING_FILES - 1);
        }
    }

    public String toXml(int level, boolean doLineBreak) {
        StringBuffer sb = new StringBuffer();
        if (doLineBreak) {
            XMLWriter.doLineAndIndent(sb, level);
        } else {
            XMLWriter.doIndent(sb, level);
        }
        sb.append("<preferences>");
        if (this.lastCsvInput != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastCsvInput", this.lastCsvInput));
        }
        if (this.lastExcelInput != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastExcelInput", this.lastExcelInput));
        }
        if (this.lastTemplate != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastTemplate", this.lastTemplate));
        }
        if (this.lastOutputDir != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastOutputDir", this.lastOutputDir));
        }
        XMLWriter.doLineAndIndent(sb, level + 1);
        sb.append("<recentMappingFiles>");
        for (String filePath : this.recentMappingFiles) {
            XMLWriter.doLineAndIndent(sb, level + 2);
            sb.append(XMLWriter.normalizeAndPrint("filePath", filePath));
        }
        XMLWriter.doLineAndIndent(sb, level + 1);
        sb.append("</recentMappingFiles>");
        XMLWriter.doLineAndIndent(sb, level);
        sb.append("</preferences>");
        return sb.toString();
    }

    public void store(File f) {
        if (f != null) {
            FileUtil.writeToFile(f, this.toXml(0, false));
        }
    }

    private CsvExcelXMLPreferences(final File file) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                CsvExcelXMLPreferences.this.store(file);
            }
        });
        this.fPrefs = file;
        if (file != null && file.exists()) {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addBeanPropertySetter("preferences/lastCsvInput");
            digester.addBeanPropertySetter("preferences/lastExcelInput");
            digester.addBeanPropertySetter("preferences/lastTemplate");
            digester.addBeanPropertySetter("preferences/lastOutputDir");
            digester.addCallMethod("preferences/recentMappingFiles/filePath", "addRecentMappingFile", 0);
            digester.parse(this.fPrefs);
        }
    }

    public static synchronized CsvExcelXMLPreferences loadPreferences(File f) throws Exception {
        if (preferences == null) {
            preferences = new CsvExcelXMLPreferences(f);
        }
        return preferences;
    }

    public static synchronized CsvExcelXMLPreferences getInstance() throws Exception {
        if (preferences == null) {
            String name = "csvexecel.prefs";
            File fPref = new File(FileUtil.getHomeDir(), name);
            preferences = new CsvExcelXMLPreferences(fPref);
        }
        return preferences;
    }

    private CsvExcelXMLPreferences() {
    }

    public static void main(String[] args) throws Exception {
        String name = "csvexecel.prefs";
        File f = new File(FileUtil.getHomeDir(), name);
        boolean init = false;
        if (init) {
            CsvExcelXMLPreferences prefs = CsvExcelXMLPreferences.getInstance();
            prefs.addNewestRecentMappingFile("c:\\temp\\file1");
            prefs.addNewestRecentMappingFile("c:\\temp\\file2");
            prefs.store(f);
        }
        if (f.exists()) {
            CsvExcelXMLPreferences prefs2 = CsvExcelXMLPreferences.loadPreferences(f);
            log.info((Object)prefs2.toXml(0, true));
        }
    }

    public ArrayList<String> getRecentMappingFiles() {
        return this.recentMappingFiles;
    }

    public void setRecentMappingFiles(ArrayList<String> recentMappingFiles) {
        this.recentMappingFiles = recentMappingFiles;
    }

    public File getFPrefs() {
        return this.fPrefs;
    }

    public void setFPrefs(File prefs) {
        this.fPrefs = prefs;
    }

    public String getLastCsvInput() {
        return this.lastCsvInput;
    }

    public void setLastCsvInput(String lastCsvInput) {
        this.lastCsvInput = lastCsvInput;
    }

    public String getLastExcelInput() {
        return this.lastExcelInput;
    }

    public void setLastExcelInput(String lastExcelInput) {
        this.lastExcelInput = lastExcelInput;
    }

    public String getLastTemplate() {
        return this.lastTemplate;
    }

    public void setLastTemplate(String lastTemplate) {
        this.lastTemplate = lastTemplate;
    }

    public String getLastOutputDir() {
        return this.lastOutputDir;
    }

    public void setLastOutputDir(String lastOutputDir) {
        this.lastOutputDir = lastOutputDir;
    }
}

