/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.mapping;

import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.mapping.ParameterMapping;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;

public class ParameterMappingList {
    ArrayList<ParameterMapping> mappings = new ArrayList();
    private File fMapping;
    private static Logger log = Logger.getLogger(ParameterMappingList.class);

    public ArrayList<ParameterMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(ArrayList<ParameterMapping> mappings) {
        this.mappings = mappings;
    }

    public File getFMapping() {
        return this.fMapping;
    }

    public void setFMapping(File mapping) {
        this.fMapping = mapping;
    }

    public ParameterMappingList(File file) throws Exception {
        this.fMapping = file;
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)this);
        digester.addObjectCreate("mappingList/mapping", "com.donkeydevelopment.csvexcel.mapping.ParameterMapping");
        digester.addBeanPropertySetter("mappingList/mapping/parameterName");
        digester.addBeanPropertySetter("mappingList/mapping/columnNr");
        digester.addBeanPropertySetter("mappingList/mapping/columnName");
        digester.addSetNext("mappingList/mapping", "addMapping", "com.donkeydevelopment.csvexcel.mapping.ParameterMapping");
        digester.parse(this.fMapping);
    }

    public ParameterMappingList() {
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<mappingList>");
        for (ParameterMapping parameterMapping : this.mappings) {
            sb.append(parameterMapping.toXml(1, true));
        }
        XMLWriter.doLineAndIndent(sb, 0);
        sb.append("</mappingList>");
        return sb.toString();
    }

    public void store(File f) {
        FileUtil.writeToFile(f, this.toXml());
        this.fMapping = f;
    }

    public void addMapping(ParameterMapping parameterMapping) {
        this.mappings.add(parameterMapping);
    }

    public void merge(ParameterMappingList savedParameterMappingList, String[] columnList) {
        block0: for (ParameterMapping currentMapping : this.mappings) {
            block1: for (ParameterMapping newMapping : savedParameterMappingList.getMappings()) {
                if (!currentMapping.getParameterName().equals(newMapping.getParameterName())) continue;
                if (newMapping.getColumnNr() >= 0 && newMapping.getColumnNr() < columnList.length && columnList[newMapping.getColumnNr()].equals(newMapping.getColumnName())) {
                    currentMapping.setColumnNr(newMapping.getColumnNr());
                    currentMapping.setColumnName(newMapping.getColumnName());
                    continue block0;
                }
                int i = 0;
                while (i < columnList.length) {
                    String colname = columnList[i];
                    if (colname.equals(newMapping.getColumnName())) {
                        log.info((Object)("saved mapping for parameter " + currentMapping.getParameterName() + " has changed columnr"));
                        currentMapping.setColumnNr(i);
                        currentMapping.setColumnName(colname);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
    }
}

