/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.gui.popup;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.gui.MyTable;
import com.donkeydevelopment.csvexcel.common.gui.WideComboBox2;
import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.common.model.ArrayListComboBoxModel;
import com.donkeydevelopment.csvexcel.csv.io.CsvFileReader;
import com.donkeydevelopment.csvexcel.filefilter.PmapFileFilter;
import com.donkeydevelopment.csvexcel.gui.popup.ParameterMappingPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.Popup;
import com.donkeydevelopment.csvexcel.gui.popup.PopupVO;
import com.donkeydevelopment.csvexcel.mapping.ParameterMapping;
import com.donkeydevelopment.csvexcel.mapping.ParameterMappingList;
import com.donkeydevelopment.csvexcel.prefs.CsvExcelXMLPreferences;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import com.donkeydevelopment.csvexcel.utils.Helper;
import com.donkeydevelopment.csvexcel.utils.ParameterFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public class ParameterMappingPopup
extends Popup {
    ParameterMappingPopupVO answer;
    JTable table = null;
    JComboBox cbRecent = null;
    private static Logger log = Logger.getLogger(ParameterMappingPopup.class);

    public ParameterMappingPopup(JFrame owner, String title, boolean modal, PopupVO answer) {
        super(owner, title, modal, true, true);
        this.answer = (ParameterMappingPopupVO)answer;
    }

    public PopupVO showDialog() {
        this.setCenter(this.createCenter());
        this.createListeners();
        this.center();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.btOk);
        this.setVisible(true);
        return this.answer;
    }

    public void createListeners() {
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterMappingPopup.this.answer.setAction(true);
                if (ParameterMappingPopup.this.table.isEditing()) {
                    ParameterMappingPopup.this.table.getCellEditor().stopCellEditing();
                }
                ParameterMappingPopup.this.dispose();
            }
        });
        this.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterMappingPopup.this.answer.setAction(false);
                if (ParameterMappingPopup.this.table.isEditing()) {
                    ParameterMappingPopup.this.table.getCellEditor().stopCellEditing();
                }
                ParameterMappingPopup.this.dispose();
            }
        });
    }

    private File getOutputFile() {
        File fLastSelected = null;
        fLastSelected = this.cbRecent.getModel().getSize() > 0 ? (this.cbRecent.getSelectedIndex() > -1 ? (File)this.cbRecent.getSelectedItem() : ((File)this.cbRecent.getModel().getElementAt(0)).getParentFile()) : FileUtil.getSystemDefaultDocDir();
        PmapFileFilter pmapFileFilternew = new PmapFileFilter();
        return FileChooser.getOutputFile((Component)Frame.getInstance(), "Save mapping file", pmapFileFilternew, fLastSelected);
    }

    private void resetMapping() {
        this.cbRecent.setSelectedIndex(-1);
        this.cbRecent.requestFocusInWindow();
    }

    private void saveMapping() {
        File fOut = this.getOutputFile();
        if (fOut != null) {
            if (fOut.getName().indexOf(".") == -1) {
                fOut = new File(fOut.getParentFile(), String.valueOf(fOut.getName()) + ".pmap");
            }
            this.answer.getMappingList().store(fOut);
            try {
                CsvExcelXMLPreferences.getInstance().addNewestRecentMappingFile(fOut.getAbsolutePath());
                boolean inList = false;
                int i = 0;
                while (i < this.cbRecent.getModel().getSize()) {
                    File f = (File)this.cbRecent.getModel().getElementAt(i);
                    if (f.getAbsolutePath().equalsIgnoreCase(fOut.getAbsolutePath())) {
                        this.cbRecent.setSelectedItem(f);
                        inList = true;
                        break;
                    }
                    ++i;
                }
                if (!inList) {
                    ((ArrayListComboBoxModel)this.cbRecent.getModel()).addItemAt(0, fOut);
                    this.cbRecent.setSelectedIndex(0);
                }
                this.cbRecent.requestFocusInWindow();
            }
            catch (Exception e) {
                log.error((Object)"Error opening CsvExcelXMLPreferences  file ", (Throwable)e);
            }
        }
    }

    private void openMapping() {
        File fLastSelected = null;
        fLastSelected = this.cbRecent.getModel().getSize() > 0 ? (File)this.cbRecent.getModel().getElementAt(0) : FileUtil.getSystemDefaultDocDir();
        File fInput = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose a saved mapping file", new PmapFileFilter(), fLastSelected);
        if (fInput == null) {
            return;
        }
        try {
            ParameterMappingList savedParameterMappingList = new ParameterMappingList(fInput);
            this.answer.getMappingList().merge(savedParameterMappingList, this.answer.getColumnList());
            ((MappingsTableModel)this.table.getModel()).setVarList(this.answer.getMappingList().getMappings());
            CsvExcelXMLPreferences.getInstance().addNewestRecentMappingFile(fInput.getAbsolutePath());
            boolean inList = false;
            int i = 0;
            while (i < this.cbRecent.getModel().getSize()) {
                File f = (File)this.cbRecent.getModel().getElementAt(i);
                if (f.getAbsolutePath().equalsIgnoreCase(fInput.getAbsolutePath())) {
                    this.cbRecent.setSelectedItem(f);
                    inList = true;
                    break;
                }
                ++i;
            }
            if (!inList) {
                ((ArrayListComboBoxModel)this.cbRecent.getModel()).addItemAt(0, fInput);
                this.cbRecent.setSelectedIndex(0);
            }
            this.cbRecent.requestFocusInWindow();
        }
        catch (Exception e) {
            log.error((Object)"Error opening maping file", (Throwable)e);
        }
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(600, 300));
        JPanel pNorth = new JPanel(new BorderLayout());
        JTextArea jtaInfo = new JTextArea(this.answer.getInfoText());
        jtaInfo.setPreferredSize(new Dimension(panel.getPreferredSize().width, 80));
        jtaInfo.setEditable(false);
        jtaInfo.setBackground(new JLabel().getBackground());
        jtaInfo.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        pNorth.add((Component)jtaInfo, "North");
        this.table = new MyTable(new MappingsTableModel(this.answer.getMappingList().getMappings()));
        this.table.setRowHeight(18);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new MappingCellRenderer(this.answer.getColumnList()));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new MappingCellRenderer(this.answer.getColumnList()));
        JComboBox<String> comboCols = new JComboBox<String>(this.answer.getColumnList());
        comboCols.setEditable(false);
        comboCols.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                log.debug((Object)"popupMenuCanceled");
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                log.debug((Object)"popupMenuWillBecomeInvisible");
                ParameterMappingPopup.this.table.getCellEditor().stopCellEditing();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                log.debug((Object)"popupMenuWillBecomeVisible");
            }
        });
        this.table.getColumnModel().getColumn(1).setCellEditor(new MappingTableEditor(comboCols));
        panel.add((Component)new JScrollPane(this.table), "Center");
        JPanel savePanel = new JPanel();
        savePanel.setLayout(new BoxLayout(savePanel, 2));
        savePanel.setBorder(BorderFactory.createEtchedBorder());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            CsvExcelXMLPreferences csvExcelXMLPreferences = CsvExcelXMLPreferences.getInstance();
            for (String filePath : csvExcelXMLPreferences.getRecentMappingFiles()) {
                File recentFile = new File(filePath);
                if (!recentFile.exists()) continue;
                arrayList.add(recentFile);
            }
        }
        catch (Exception e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
        ArrayListComboBoxModel model = new ArrayListComboBoxModel(arrayList);
        this.cbRecent = new WideComboBox2((ComboBoxModel)model);
        this.cbRecent.setPreferredSize(new Dimension(300, this.cbRecent.getPreferredSize().height));
        this.cbRecent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (ParameterMappingPopup.this.cbRecent.getSelectedIndex() > -1) {
                        ParameterMappingList savedParameterMappingList = new ParameterMappingList((File)ParameterMappingPopup.this.cbRecent.getSelectedItem());
                        ParameterMappingPopup.this.answer.getMappingList().merge(savedParameterMappingList, ParameterMappingPopup.this.answer.getColumnList());
                        ((MappingsTableModel)ParameterMappingPopup.this.table.getModel()).setVarList(ParameterMappingPopup.this.answer.getMappingList().getMappings());
                    } else {
                        for (ParameterMapping mapping : ParameterMappingPopup.this.answer.getMappingList().getMappings()) {
                            int mostSimilarcolnr = Helper.getMostSimilarString(mapping.getParameterName(), ParameterMappingPopup.this.answer.getColumnList());
                            mapping.setColumnNr(mostSimilarcolnr);
                            mapping.setColumnName(ParameterMappingPopup.this.answer.getColumnList()[mostSimilarcolnr]);
                        }
                        ((MappingsTableModel)ParameterMappingPopup.this.table.getModel()).setVarList(ParameterMappingPopup.this.answer.getMappingList().getMappings());
                    }
                }
                catch (Exception e1) {
                    log.error((Object)"Error opening mapiing file", (Throwable)e1);
                }
            }
        });
        JButton jb1 = new JButton(". . .");
        jb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterMappingPopup.this.openMapping();
            }
        });
        JButton jb2 = new JButton("Save Mapping");
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterMappingPopup.this.saveMapping();
            }
        });
        jb2.setIcon(new ImageIcon(ResourceLoader.class.getResource("save_as.png")));
        JButton jb3 = new JButton("Reset");
        jb3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterMappingPopup.this.resetMapping();
            }
        });
        jb3.setIcon(new ImageIcon(ResourceLoader.class.getResource("arrow_undo.png")));
        savePanel.add(this.cbRecent);
        savePanel.add(jb1);
        savePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        savePanel.add(jb3);
        savePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        savePanel.add(jb2);
        pNorth.add((Component)savePanel, "South");
        panel.add((Component)pNorth, "North");
        return panel;
    }

    public static void main(String[] args) throws Exception {
        String pCsv = args[0];
        String pXslt = args[1];
        ParameterMappingPopupVO answer = new ParameterMappingPopupVO();
        if (!new File(pCsv).exists()) {
            throw new Exception("Input csv file does not exist");
        }
        if (!new File(pXslt).exists()) {
            throw new Exception("Stylesheet does not exist");
        }
        CsvFileReader csvFileReader = new CsvFileReader(pCsv, null, '\t');
        String[] columnList = csvFileReader.readNextValues();
        if (columnList != null) {
            int i = 0;
            while (i < columnList.length) {
                log.debug((Object)("gevonden kolom namen in csv file " + columnList[i]));
                ++i;
            }
        }
        ParameterFinder parmFinder = new ParameterFinder(new File(pXslt));
        String[] paramList = parmFinder.getParameterNames();
        ArrayList<ParameterMapping> mappingList = new ArrayList<ParameterMapping>();
        boolean i = false;
        String[] stringArray = paramList;
        int n = paramList.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName = stringArray[n2];
            ParameterMapping mapping = new ParameterMapping();
            mapping.setParameterName(parameterName);
            int mostSimilarcolnr = Helper.getMostSimilarString(parameterName, columnList);
            mapping.setColumnNr(mostSimilarcolnr);
            mapping.setColumnName(columnList[mostSimilarcolnr]);
            mappingList.add(mapping);
            ++n2;
        }
        ParameterMappingList parameterMappingList = new ParameterMappingList();
        parameterMappingList.setMappings(mappingList);
        answer.setMappingList(parameterMappingList);
        answer.setColumnList(columnList);
        answer.setInfoText("Map columns in the CSV input file to parameter names in the stylesheet.\nYou can change the mapping by clicking the in the second column.\nA listbox will appear, in which you can select another column");
        ParameterMappingPopup popup = new ParameterMappingPopup(null, "Mappings", true, answer);
        popup.showDialog();
    }

    public class MappingCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        String[] columnList;

        public MappingCellRenderer(String[] columnList) {
            this.columnList = columnList;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StringBuffer sb = new StringBuffer();
            ParameterMapping variable = (ParameterMapping)value;
            if (column == 0) {
                sb.append(variable.getParameterName());
            } else {
                sb.append(String.valueOf(variable.getColumnNr()) + " - " + this.columnList[variable.getColumnNr()]);
            }
            this.setToolTipText(null);
            return super.getTableCellRendererComponent(table, sb.toString(), isSelected, hasFocus, row, column);
        }
    }

    public class MappingTableEditor
    extends DefaultCellEditor {
        public MappingTableEditor(JComboBox arg0) {
            super(arg0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ParameterMapping variable = (ParameterMapping)value;
            ((JComboBox)comp).setSelectedIndex(variable.getColumnNr());
            return comp;
        }

        @Override
        public Object getCellEditorValue() {
            log.info((Object)"getCellEditorValue");
            return new Integer(((JComboBox)this.editorComponent).getSelectedIndex());
        }
    }

    private class MappingsTableModel
    extends AbstractTableModel {
        private ArrayList<ParameterMapping> mappingList;
        private String[] COLUMNS = new String[]{"parameter name", "colum"};

        public MappingsTableModel() {
        }

        public MappingsTableModel(ArrayList<ParameterMapping> mappingList) {
            this.mappingList = mappingList;
        }

        public void setVarList(ArrayList<ParameterMapping> mappingList) {
            this.mappingList = mappingList;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public int getRowCount() {
            if (this.mappingList == null) {
                return 0;
            }
            return this.mappingList.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public Class getColumnClass(int col) {
            return ArrayList.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.mappingList == null) {
                return null;
            }
            return this.mappingList.get(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Integer) {
                Integer columnr = (Integer)value;
                this.mappingList.get(row).setColumnNr(columnr);
                this.mappingList.get(row).setColumnName(ParameterMappingPopup.this.answer.getColumnList()[columnr]);
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public String getColumnName(int col) {
            return this.COLUMNS[col];
        }
    }
}

