/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.gui.popup;

import com.donkeydevelopment.csvexcel.common.layout.ParagraphLayout;
import com.donkeydevelopment.csvexcel.csv.io.CsvFileReader;
import com.donkeydevelopment.csvexcel.gui.popup.FileNameMappingPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.Popup;
import com.donkeydevelopment.csvexcel.gui.popup.PopupVO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class FileNameMappingPopup
extends Popup {
    FileNameMappingPopupVO answer;
    JTable table = null;
    private static Logger log = Logger.getLogger(FileNameMappingPopup.class);
    JRadioButton rbUseColumn;
    JComboBox cbColumns;
    JCheckBox cbAutoNumber;
    JCheckBox cbAutoNumPrefix;
    JTextField tfPrefix;

    public FileNameMappingPopup(JFrame owner, String title, boolean modal, PopupVO answer) {
        super(owner, title, modal, true, true);
        this.answer = (FileNameMappingPopupVO)answer;
    }

    public PopupVO showDialog() {
        this.setCenter(this.createCenter());
        this.createListeners();
        this.center();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.btOk);
        this.setVisible(true);
        return this.answer;
    }

    public void createListeners() {
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileNameMappingPopup.this.answer.setAction(true);
                FileNameMappingPopup.this.answer.setSelectedIndx(FileNameMappingPopup.this.cbColumns.getSelectedIndex());
                FileNameMappingPopup.this.answer.setFilePrefix(FileNameMappingPopup.this.tfPrefix.getText());
                FileNameMappingPopup.this.answer.setUseColumn(FileNameMappingPopup.this.rbUseColumn.isSelected());
                if (FileNameMappingPopup.this.answer.isUseColumn()) {
                    FileNameMappingPopup.this.answer.setUseRowSuffix(FileNameMappingPopup.this.cbAutoNumber.isSelected());
                } else {
                    FileNameMappingPopup.this.answer.setUseRowSuffix(FileNameMappingPopup.this.cbAutoNumPrefix.isSelected());
                }
                FileNameMappingPopup.this.dispose();
            }
        });
        this.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileNameMappingPopup.this.answer.setAction(false);
                FileNameMappingPopup.this.dispose();
            }
        });
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(600, 400));
        JPanel infoPane = new JPanel(new BorderLayout());
        infoPane.setBorder(new TitledBorder("Info"));
        String info_1 = "";
        if (this.answer.getGroupOn().equals("All together")) {
            info_1 = "You have specified grouping on all rows : \n  ==> One output file is created for all rows in the csv file.\n";
        } else if (this.answer.getGroupOn().startsWith("All together")) {
            String sMax = this.answer.getGroupOn().substring(this.answer.getGroupOn().indexOf("max") + 4);
            info_1 = "You have specified grouping " + sMax + " rows together : " + "\n  ==> One output file is created for each " + sMax + " rows in the csv file.\n";
        } else if (this.answer.getGroupOn().startsWith("None")) {
            info_1 = "You have specified no grouping : \n  ==> Output files are created for every row in the csv file.\n";
        } else if (this.answer.getGroupOn().startsWith("On column: ")) {
            info_1 = "You have specified grouping on column " + this.answer.getGroupOn().substring("On column: ".length()) + " : " + "\n  ==> Output files are created for each group of successive rows with the same value.\n ";
        }
        String info_2 = "In this window you can specify how this files should be named.\nEither use a value found in the column of the csv file or use a fixed name\nthat is suffixed by a row number.";
        JTextArea jtaInfo = new JTextArea(String.valueOf(info_1) + "\n" + info_2);
        jtaInfo.setPreferredSize(new Dimension(panel.getPreferredSize().width, 100));
        jtaInfo.setEditable(false);
        jtaInfo.setBackground(new JLabel().getBackground());
        jtaInfo.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        infoPane.add(jtaInfo);
        panel.add((Component)infoPane, "North");
        JPanel subPane = new JPanel(new ParagraphLayout());
        this.rbUseColumn = new JRadioButton("");
        subPane.add((Component)this.rbUseColumn, ParagraphLayout.NEW_PARAGRAPH);
        subPane.add(new JLabel("Use the value in a column as file name"));
        JPanel filler1 = new JPanel();
        filler1.setPreferredSize(new Dimension(30, 10));
        subPane.add((Component)filler1, ParagraphLayout.NEW_PARAGRAPH);
        JPanel subPane2a = new JPanel(new GridLayout(2, 2));
        subPane2a.setPreferredSize(new Dimension(400, 50));
        subPane2a.add(new JLabel("column"));
        this.cbColumns = new JComboBox<String>(this.answer.getColumnList());
        subPane2a.add(this.cbColumns);
        subPane2a.add(new JLabel("add rownr suffix"));
        this.cbAutoNumber = new JCheckBox("");
        subPane2a.add(this.cbAutoNumber);
        subPane.add(subPane2a);
        JRadioButton rbFixedName = new JRadioButton("");
        subPane.add((Component)rbFixedName, ParagraphLayout.NEW_PARAGRAPH);
        subPane.add(new JLabel("Use a fixed value as file name"));
        JPanel filler2 = new JPanel();
        filler2.setPreferredSize(new Dimension(30, 10));
        subPane.add((Component)filler2, ParagraphLayout.NEW_PARAGRAPH);
        JPanel subPane2b = new JPanel(new GridLayout(2, 2));
        subPane2b.setPreferredSize(new Dimension(400, 50));
        subPane2b.add((Component)new JLabel("value"), ParagraphLayout.NEW_PARAGRAPH);
        this.tfPrefix = new JTextField(5);
        subPane2b.add(this.tfPrefix);
        subPane2b.add(new JLabel("add rownr suffix"));
        this.cbAutoNumPrefix = new JCheckBox("");
        this.cbAutoNumPrefix.setSelected(true);
        this.cbAutoNumPrefix.setEnabled(false);
        subPane2b.add(this.cbAutoNumPrefix);
        subPane.add(subPane2b);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(rbFixedName);
        bgroup.add(this.rbUseColumn);
        this.rbUseColumn.setSelected(true);
        if (this.answer.getGroupOn().equals("None")) {
            this.rbUseColumn.setSelected(true);
            this.cbAutoNumber.setSelected(false);
        }
        if (this.answer.getGroupOn().startsWith("On column: ")) {
            this.rbUseColumn.setSelected(true);
            this.cbColumns.setSelectedItem(this.answer.getGroupOn().substring("On column: ".length()));
            this.cbAutoNumber.setSelected(false);
        }
        if (this.answer.getGroupOn().equals("All together")) {
            rbFixedName.setSelected(true);
            this.cbAutoNumPrefix.setSelected(false);
            this.cbAutoNumPrefix.setEnabled(true);
        } else if (this.answer.getGroupOn().startsWith("All together")) {
            rbFixedName.setSelected(true);
            this.cbAutoNumPrefix.setSelected(true);
        }
        panel.add((Component)subPane, "Center");
        return panel;
    }

    public static void main(String[] args) throws Exception {
        String pCsv = args[0];
        FileNameMappingPopupVO answer = new FileNameMappingPopupVO();
        if (!new File(pCsv).exists()) {
            throw new Exception("Input csv file does not exist");
        }
        CsvFileReader csvFileReader = new CsvFileReader(pCsv, null, '\t');
        String[] columnList = csvFileReader.readNextValues();
        if (columnList != null) {
            int i = 0;
            while (i < columnList.length) {
                log.debug((Object)("gevonden kolom namen in csv file " + columnList[i]));
                ++i;
            }
        }
        answer.setColumnList(columnList);
        answer.setGroupOn("None");
        FileNameMappingPopup popup = new FileNameMappingPopup(null, "FileNameMapping", true, answer);
        popup.showDialog();
    }
}

