/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.grouping;

import com.donkeydevelopment.csvexcel.common.xml.XMLTransformer;
import com.donkeydevelopment.csvexcel.row.FileRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.swing.JOptionPane;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Grouper {
    public static final String GROUPING_NONE = "None";
    public static final String GROUPING_ALL = "All together";
    public static final String GROUPING_ALL_100 = "All together with max 100";
    public static final String GROUPING_ALL_1000 = "All together with max 1000";
    public static final String[] GROUPING_TYPES = new String[]{"None", "All together", "All together with max 100", "All together with max 1000"};
    public static final String ON_COLUMN_TYPE_PREF = "On column: ";

    public static boolean isBreakingRow(FileRow currentRow, FileRow oldRow, int rownr, String groupOn) {
        if (oldRow == null) {
            return true;
        }
        if (groupOn.equals(GROUPING_ALL)) {
            return false;
        }
        if (groupOn.startsWith(GROUPING_ALL)) {
            int sMax = Integer.parseInt(groupOn.substring(groupOn.indexOf("max") + 4));
            return rownr % sMax == 1;
        }
        if (groupOn.startsWith(GROUPING_NONE)) {
            return true;
        }
        if (groupOn.startsWith(ON_COLUMN_TYPE_PREF)) {
            String colGroup = groupOn.substring(ON_COLUMN_TYPE_PREF.length());
            String oldValue = oldRow.getValueAsString(colGroup);
            String newValue = currentRow.getValueAsString(colGroup);
            if (oldValue == null) {
                return newValue != null;
            }
            return !oldValue.equals(newValue);
        }
        return true;
    }

    public static String getGrouping(String[] fixedChoices, String[] columnList) {
        Object[] possibilities = new String[columnList.length + fixedChoices.length];
        int i = 0;
        String[] stringArray = fixedChoices;
        int n = fixedChoices.length;
        int n2 = 0;
        while (n2 < n) {
            String choice;
            possibilities[i] = choice = stringArray[n2];
            ++i;
            ++n2;
        }
        stringArray = columnList;
        n = columnList.length;
        n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            possibilities[i] = ON_COLUMN_TYPE_PREF + col;
            ++i;
            ++n2;
        }
        String s = (String)JOptionPane.showInputDialog(null, "Select the kind of grouping. Your xsl stylesheet must support this.\nWhen records are grouped on column value, then successive records \nwith the same value will be grouped\n\n", "Select grouping", -1, null, possibilities, GROUPING_NONE);
        return s;
    }

    public static void writeGroup(XMLTransformer aXMLTransformer, StringBuilder xmlGroup, File fileOut) throws Exception {
        xmlGroup.append("</table>");
        StringReader in = new StringReader(xmlGroup.toString());
        StreamSource source = new StreamSource(in);
        FileOutputStream output = new FileOutputStream(fileOut);
        StreamResult result = new StreamResult(output);
        aXMLTransformer.transform(source, result);
        output.close();
    }
}

