/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.processor;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.excel.data.ExcelColumn;
import com.donkeydevelopment.csvexcel.excel.data.ExcelXMLMapping;
import com.donkeydevelopment.csvexcel.excel.popup.SheetFinderPopup;
import com.donkeydevelopment.csvexcel.excel.popup.SheetFinderPopupVO;
import com.donkeydevelopment.csvexcel.excel.popup.TypeMappingPopup;
import com.donkeydevelopment.csvexcel.excel.popup.TypeMappingPopupVO;
import com.donkeydevelopment.csvexcel.excel.type.ExcelType;
import com.donkeydevelopment.csvexcel.excel.type.XMLType;
import com.donkeydevelopment.csvexcel.filefilter.ExcelFileFilter;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelToXml {
    private static Logger log = Logger.getLogger(ExcelToXml.class);
    DataFormatter formatter = new DataFormatter(Locale.getDefault(), true);
    GregorianCalendar gc = new GregorianCalendar(TimeZone.getDefault());
    FormulaEvaluator evaluator = null;
    Workbook workbook = null;
    InputStream in = null;

    public ExcelToXml(File file) throws InvalidFormatException, FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                log.info((Object)"workbook inputstream could not be closed");
            }
        }
    }

    public ExcelToXml(InputStream in) throws InvalidFormatException, IOException {
        this.in = in;
        this.workbook = WorkbookFactory.create((InputStream)in);
        this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        if (this.evaluator instanceof HSSFFormulaEvaluator) {
            log.info((Object)"ignore external references in the workbook");
            ((HSSFFormulaEvaluator)this.evaluator).setIgnoreMissingWorkbooks(true);
        }
    }

    public int getDataSheet() {
        int sheetNumber = 0;
        int numberOfSheets = this.workbook.getNumberOfSheets();
        Object[] possibilities = new Object[numberOfSheets];
        int i = 0;
        while (i < numberOfSheets) {
            possibilities[i] = String.valueOf(i) + ": " + this.workbook.getSheetName(i);
            ++i;
        }
        String s = (String)JOptionPane.showInputDialog(null, "Select the data sheet", "Datasheet selection", -1, null, possibilities, possibilities[0]);
        if (s != null && s.length() > 0) {
            sheetNumber = Integer.parseInt(s.substring(0, 1));
        }
        log.info((Object)("sheet choosen = " + sheetNumber));
        return sheetNumber;
    }

    public SheetFinderPopupVO getDataSheetInfo() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        String[] possibilities = new String[numberOfSheets];
        int i = 0;
        while (i < numberOfSheets) {
            possibilities[i] = String.valueOf(i + 1) + ": " + this.workbook.getSheetName(i);
            ++i;
        }
        SheetFinderPopupVO answer = new SheetFinderPopupVO();
        answer.setInfoText("Choose the data sheet that contains the data and supply the row \nwhich contain the column headings and the first data row.");
        answer.setSheetList(possibilities);
        answer.setHeaderRow(0);
        answer.setDataRow(1);
        answer.setExcelToXml(this);
        SheetFinderPopup popup = new SheetFinderPopup((JFrame)Frame.getInstance(), "Choose data source", true, answer);
        popup.showDialog();
        return answer;
    }

    public String[] getExcelRowValues(Integer sheetNr, Integer rownr) {
        ArrayList<String> list = new ArrayList<String>();
        Sheet sheet = this.workbook.getSheetAt(sheetNr.intValue());
        Row columnRow = sheet.getRow(rownr.intValue());
        if (columnRow != null) {
            int lastColumn = columnRow.getLastCellNum();
            int col = 0;
            while (col < lastColumn) {
                String value;
                Cell cell = columnRow.getCell(col);
                if (cell != null && (value = this.formatter.formatCellValue(cell, this.evaluator)).trim().length() > 0) {
                    list.add(value);
                }
                ++col;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getColumnNames(ArrayList<ExcelColumn> excelColumns) {
        String[] names = new String[excelColumns.size()];
        int indx = 0;
        for (ExcelColumn column : excelColumns) {
            names[indx] = column.getName();
            ++indx;
        }
        return names;
    }

    public ArrayList<ExcelColumn> getExcelColumns(Integer sheetNr, Integer headerRowNr, Integer dataRowNr) throws DatatypeConfigurationException {
        log.debug((Object)("default Timezone: " + TimeZone.getDefault().getID()));
        log.debug((Object)("default Locale: " + Locale.getDefault()));
        ArrayList<ExcelColumn> columnList = new ArrayList<ExcelColumn>();
        Sheet sheet = this.workbook.getSheetAt(sheetNr.intValue());
        Row columnRow = sheet.getRow(headerRowNr.intValue());
        Row dataRow = sheet.getRow(dataRowNr.intValue());
        if (columnRow != null) {
            int lastColumn = columnRow.getLastCellNum();
            int col = 0;
            while (col < lastColumn) {
                String value;
                Cell cell = columnRow.getCell(col);
                if (cell != null && (value = this.formatter.formatCellValue(cell, this.evaluator)).trim().length() > 0) {
                    ExcelColumn excelColumn = new ExcelColumn();
                    excelColumn.setSheetNr(sheetNr);
                    excelColumn.setName(value);
                    excelColumn.setIndex(cell.getColumnIndex());
                    excelColumn.setHeaderRow(headerRowNr);
                    excelColumn.setFirstDataRow(dataRowNr);
                    if (dataRow != null) {
                        excelColumn.setExcelType(this.getExcelType(dataRow.getCell(col), sheet));
                    }
                    columnList.add(excelColumn);
                }
                ++col;
            }
        }
        return columnList;
    }

    public String convertToXML() throws Exception {
        log.debug((Object)("default Timezone: " + TimeZone.getDefault().getID()));
        log.debug((Object)("default Locale: " + Locale.getDefault()));
        SheetFinderPopupVO answerSF = this.getDataSheetInfo();
        Integer sheetNr = answerSF.getSheetNumber();
        Integer headerRowNr = answerSF.getHeaderRow();
        Integer firstDataRowNr = answerSF.getDataRow();
        ArrayList<ExcelColumn> columnList = this.getExcelColumns(sheetNr, headerRowNr, firstDataRowNr);
        ArrayList<ExcelXMLMapping> mappingList = new ArrayList<ExcelXMLMapping>();
        for (ExcelColumn excelColumn : columnList) {
            ExcelXMLMapping mapping = new ExcelXMLMapping();
            mapping.setExcelColumn(excelColumn);
            mapping.setXmlType(excelColumn.getExcelType().getDefaultXMLType());
            mappingList.add(mapping);
        }
        TypeMappingPopupVO answer = new TypeMappingPopupVO();
        answer.setMappingList(mappingList);
        answer.setExcelToXml(this);
        answer.setInfoText("Excel text columns will exactly be copied as displayed in Excel. So if possible, format all cells within Excel as text to get the\nmost predictable results.\n\nBoolean columns will be copied as either \"true\"or \"false\".\n\nNumeric columns will be standard formatted with a decimal point and a a maximum scale of 11.\nThis means that maximal 11 digits will be displayed to the right of the decimal point.\nNegative numeric values be displayed with a minus sign to the left.\n\nFor date columns you have to choose the most appropriate format.\nYou can preview the value of the first data row in the exampe column.");
        TypeMappingPopup popup = new TypeMappingPopup((JFrame)Frame.getInstance(), "Choose Column Format", true, answer);
        answer = (TypeMappingPopupVO)popup.showDialog();
        if (answer.isActionOk()) {
            StringBuffer xml = new StringBuffer();
            XMLWriter.doDeclaration(xml, "UTF-8");
            XMLWriter.doLine(xml);
            xml.append("<table>");
            Row row = null;
            Sheet sheet = this.workbook.getSheetAt(sheetNr.intValue());
            int lastRowNr = sheet.getLastRowNum();
            int i = firstDataRowNr;
            while (i <= lastRowNr) {
                row = sheet.getRow(i);
                if (row != null && this.atLeastOneCellFilled(row)) {
                    xml.append(this.rowToXml(mappingList, row, 1, true));
                }
                ++i;
            }
            XMLWriter.doLine(xml);
            xml.append("</table>");
            return xml.toString();
        }
        return null;
    }

    public boolean atLeastOneCellFilled(Row row) {
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            if (cell.getCellType() == 3) continue;
            return true;
        }
        return false;
    }

    public String rowToXml(ArrayList<ExcelXMLMapping> mappingList, Row row, int level, boolean doLineBreak) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (doLineBreak) {
            XMLWriter.doLineAndIndent(sb, level);
        } else {
            XMLWriter.doIndent(sb, level);
        }
        sb.append("<row>");
        for (ExcelXMLMapping excelXMLMapping : mappingList) {
            ExcelColumn excelColumn = excelXMLMapping.getExcelColumn();
            Cell cell = row.getCell(excelColumn.getIndex());
            String value = this.getFormattedValue(cell, excelXMLMapping.getXmlType());
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint(excelColumn.getName().trim(), value));
        }
        XMLWriter.doLineAndIndent(sb, level);
        sb.append("</row>");
        return sb.toString();
    }

    public String getFormattedValue(Cell cell, XMLType xmlType) throws Exception {
        String value = "";
        if (cell != null) {
            block0 : switch (cell.getCellType()) {
                case 0: {
                    value = this.getNumericValue(cell, xmlType);
                    break;
                }
                case 2: {
                    switch (cell.getCachedFormulaResultType()) {
                        case 0: {
                            value = this.getNumericValue(cell, xmlType);
                            break block0;
                        }
                    }
                    value = this.formatter.formatCellValue(cell, this.evaluator);
                    break;
                }
                default: {
                    value = this.formatter.formatCellValue(cell);
                }
            }
        }
        return value;
    }

    private String getNumericValue(Cell cell, XMLType xmlType) throws DatatypeConfigurationException {
        String value = "";
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            CellValue cValue = this.evaluator.evaluate(cell);
            double dv = cValue.getNumberValue();
            Date date = DateUtil.getJavaDate((double)dv);
            this.gc.setTime(date);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xc = datatypeFactory.newXMLGregorianCalendar(this.gc);
            switch (xmlType) {
                case DATE_VAL: {
                    value = xc.toXMLFormat().substring(0, 10);
                    break;
                }
                case DATE_TZ_VAL: {
                    value = String.valueOf(xc.toXMLFormat().substring(0, 10)) + xc.toXMLFormat().substring(23);
                    break;
                }
                case DATETIME_VAL: {
                    value = xc.toXMLFormat().substring(0, 19);
                    break;
                }
                case DATETIME_MS_VAL: {
                    value = xc.toXMLFormat().substring(0, 23);
                    break;
                }
                case DATETIME_TZ_VAL: {
                    value = String.valueOf(xc.toXMLFormat().substring(0, 19)) + xc.toXMLFormat().substring(23);
                    break;
                }
                case DATETIME_MS_TZ_VAL: {
                    value = xc.toXMLFormat();
                    break;
                }
                default: {
                    value = xc.toXMLFormat();
                    break;
                }
            }
        } else {
            DecimalFormat df = new DecimalFormat("#.###########;-#.###########");
            DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(symbols);
            value = df.format(cell.getNumericCellValue());
        }
        return value;
    }

    private ExcelType getExcelType(Cell cell, Sheet sheet) throws DatatypeConfigurationException {
        if (cell != null) {
            if (cell.getCellType() == 0 || cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 0) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    CellValue cValue = this.evaluator.evaluate(cell);
                    double dv = cValue.getNumberValue();
                    Date date = DateUtil.getJavaDate((double)dv);
                    this.gc.setTime(date);
                    DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                    XMLGregorianCalendar xc = datatypeFactory.newXMLGregorianCalendar(this.gc);
                    log.info((Object)("== " + xc.toXMLFormat() + "==="));
                    if (xc.getHour() == 0 && xc.getMinute() == 0 && xc.getSecond() == 0 && xc.getMillisecond() == 0) {
                        return ExcelType.DATE_VALE;
                    }
                    return ExcelType.DATE_TIME_VAL;
                }
                return ExcelType.NUMERIC_VAL;
            }
            if (cell.getCellType() == 4 || cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 4) {
                return ExcelType.BOOLEAN_VAL;
            }
            return ExcelType.TEXT_VAL;
        }
        return ExcelType.TEXT_VAL;
    }

    public Cell getCell(int sheetNr, int firstDataRow, int index) {
        return this.workbook.getSheetAt(sheetNr).getRow(firstDataRow).getCell(index);
    }

    public Cell getCell(ExcelColumn excelColumn) {
        return this.getCell(excelColumn.getSheetNr(), excelColumn.getFirstDataRow(), excelColumn.getIndex());
    }

    public static void main(String[] args) throws Exception {
        TimeZone defaultTz = TimeZone.getDefault();
        System.out.println(TimeZone.getDefault().getID());
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd'T' HH-mm-ssz");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ssZ");
        Date time = Calendar.getInstance().getTime();
        System.out.println("yyyy-MM-ddTHH-mm-ssz " + format1.format(time));
        System.out.println("yyyy-MM-ddTHH-mm-ssZ " + format2.format(time));
        System.out.println("offset from GMT0 " + tz.getOffset(time.getTime()));
        Calendar c = Calendar.getInstance(defaultTz);
        c.setTime(time);
        String printDate = DatatypeConverter.printDateTime((Calendar)c);
        System.out.println("for java 6 ,met millisec: " + printDate);
        GregorianCalendar gc = new GregorianCalendar(defaultTz);
        gc.setTime(time);
        DatatypeFactory f = DatatypeFactory.newInstance();
        XMLGregorianCalendar xc = f.newXMLGregorianCalendar(gc);
        String str = xc.toXMLFormat();
        System.out.println("for java 6 ,met millisec: " + str);
        System.out.println("offest from default" + defaultTz.getOffset(time.getTime()));
        Locale defaultLocale = Locale.getDefault();
        System.out.println(defaultLocale);
        File fInput = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose the excel input file", new ExcelFileFilter(), null);
        if (fInput != null) {
            ExcelToXml excelToXml = new ExcelToXml(fInput);
            String xml = excelToXml.convertToXML();
            System.out.println(xml);
            excelToXml.close();
            System.out.println("workbook closed");
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }
}

