/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.popup;

import com.donkeydevelopment.csvexcel.excel.data.ExcelXMLMapping;
import com.donkeydevelopment.csvexcel.excel.popup.TypeMappingPopupVO;
import com.donkeydevelopment.csvexcel.excel.processor.ExcelToXml;
import com.donkeydevelopment.csvexcel.excel.type.XMLType;
import com.donkeydevelopment.csvexcel.filefilter.ExcelFileFilter;
import com.donkeydevelopment.csvexcel.gui.popup.Popup;
import com.donkeydevelopment.csvexcel.gui.popup.PopupVO;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class TypeMappingPopup
extends Popup {
    private static final long serialVersionUID = 1L;
    TypeMappingPopupVO answer;
    JTable table = null;
    private static Logger log = Logger.getLogger(TypeMappingPopup.class);

    public TypeMappingPopup(JFrame owner, String title, boolean modal, PopupVO answer) {
        super(owner, title, modal, true, true);
        this.answer = (TypeMappingPopupVO)answer;
    }

    public PopupVO showDialog() {
        this.setCenter(this.createCenter());
        this.createListeners();
        this.center();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.btOk);
        this.setVisible(true);
        return this.answer;
    }

    public void createListeners() {
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TypeMappingPopup.this.answer.setAction(true);
                if (TypeMappingPopup.this.table.isEditing()) {
                    TypeMappingPopup.this.table.getCellEditor().stopCellEditing();
                }
                TypeMappingPopup.this.dispose();
            }
        });
        this.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TypeMappingPopup.this.answer.setAction(false);
                if (TypeMappingPopup.this.table.isEditing()) {
                    TypeMappingPopup.this.table.getCellEditor().stopCellEditing();
                }
                TypeMappingPopup.this.dispose();
            }
        });
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(800, 600));
        JTextArea jtaInfo = new JTextArea(this.answer.getInfoText());
        jtaInfo.setPreferredSize(new Dimension(panel.getPreferredSize().width, 230));
        jtaInfo.setEditable(false);
        jtaInfo.setBackground(new JLabel().getBackground());
        jtaInfo.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add((Component)jtaInfo, "North");
        this.table = new JTable(new MappingsTableModel(this.answer.getMappingList()));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new ColumnNameCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CustommCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new CustommCellRenderer());
        this.table.setRowHeight(24);
        this.table.getColumnModel().getColumn(1).setCellEditor(new ComboxEditor());
        panel.add((Component)new JScrollPane(this.table), "Center");
        return panel;
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        log.debug((Object)"main started");
        Locale defaultLocale = Locale.getDefault();
        System.out.println(defaultLocale);
        File fInput = FileChooser.chooseFile(null, "Choose the excel input file", new ExcelFileFilter(), null);
        if (fInput != null) {
            ExcelToXml excelToXml = new ExcelToXml(fInput);
            String xml = excelToXml.convertToXML();
            System.out.println(xml);
        }
        log.debug((Object)"main ended");
    }

    public class ColumnNameCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ExcelXMLMapping mapping = (ExcelXMLMapping)value;
            StringBuffer sb = new StringBuffer();
            sb.append(mapping.getExcelColumn().getName());
            this.setToolTipText(null);
            return super.getTableCellRendererComponent(table, sb.toString(), isSelected, hasFocus, row, column);
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.GRAY));
            XMLType xmlType = (XMLType)((Object)value);
            this.setText(xmlType.toString());
            return this;
        }
    }

    class ComboxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        XMLType currentXMLType = null;

        ComboxEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentXMLType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ExcelXMLMapping mapping = (ExcelXMLMapping)value;
            final JComboBox jb = new JComboBox(new MyComboBoxModel(mapping));
            jb.setEditable(false);
            jb.setRenderer(new ComboBoxRenderer());
            this.currentXMLType = mapping.getXmlType();
            jb.setSelectedItem((Object)mapping.getXmlType());
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboxEditor.this.currentXMLType = (XMLType)((Object)jb.getSelectedItem());
                    ComboxEditor.this.fireEditingStopped();
                }
            });
            return jb;
        }
    }

    public class CustommCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JLabel label = new JLabel();
        private JComboBox jb = new JComboBox();

        public CustommCellRenderer() {
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(2);
            this.label.setVerticalAlignment(0);
            this.jb.setRenderer(new ComboBoxRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ExcelXMLMapping mapping = (ExcelXMLMapping)value;
            if (column == 0) {
                this.label.setText(mapping.getExcelColumn().getName());
                this.label.setToolTipText(null);
                return this.label;
            }
            if (column == 1) {
                if (mapping.getExcelColumn().getExcelType().getPossibleXMLTypes().length > 1) {
                    this.jb.setModel(new MyComboBoxModel(mapping));
                    this.jb.setEditable(false);
                    this.jb.setToolTipText(null);
                    this.jb.setRenderer(new ComboBoxRenderer());
                    this.jb.setSelectedItem((Object)mapping.getXmlType());
                    return this.jb;
                }
                this.label.setText(mapping.getXmlType().toString());
                this.label.setToolTipText(null);
                return this.label;
            }
            this.label.setText("?");
            this.label.setToolTipText("unkownn column");
            ExcelToXml excelToXml = TypeMappingPopup.this.answer.getExcelToXml();
            try {
                String formattedValue = excelToXml.getFormattedValue(excelToXml.getCell(mapping.getExcelColumn()), mapping.getXmlType());
                this.label.setText(formattedValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.label.setText("Error getting cell value");
                this.label.setToolTipText(e.getMessage());
            }
            return this.label;
        }
    }

    private class MappingsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<ExcelXMLMapping> mappingList;
        private String[] COLUMNS = new String[]{"column", "format", "example result"};

        public MappingsTableModel() {
        }

        public MappingsTableModel(ArrayList<ExcelXMLMapping> mappingList) {
            this.mappingList = mappingList;
        }

        public void setVarList(ArrayList<ExcelXMLMapping> mappingList) {
            this.mappingList = mappingList;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public int getRowCount() {
            if (this.mappingList == null) {
                return 0;
            }
            return this.mappingList.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public Class getColumnClass(int col) {
            return ArrayList.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.mappingList == null) {
                return null;
            }
            return this.mappingList.get(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value instanceof XMLType) {
                XMLType type = (XMLType)((Object)value);
                this.mappingList.get(row).setXmlType(type);
            }
            if (col == 1) {
                this.fireTableCellUpdated(row, col);
                this.fireTableCellUpdated(row, col + 1);
            } else {
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.COLUMNS[col];
        }
    }

    class MyComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        ExcelXMLMapping excelXMLMapping = null;
        XMLType selection = null;

        public MyComboBoxModel(ExcelXMLMapping excelXMLMapping) {
            this.excelXMLMapping = excelXMLMapping;
        }

        @Override
        public Object getElementAt(int index) {
            return this.excelXMLMapping.getExcelColumn().getExcelType().getPossibleXMLTypes()[index];
        }

        @Override
        public int getSize() {
            return this.excelXMLMapping.getExcelColumn().getExcelType().getPossibleXMLTypes().length;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selection = (XMLType)((Object)anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.selection;
        }
    }
}

