/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.popup;

import com.donkeydevelopment.csvexcel.common.layout.ParagraphLayout;
import com.donkeydevelopment.csvexcel.excel.popup.PopupDocument;
import com.donkeydevelopment.csvexcel.excel.popup.SheetFinderPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.Popup;
import com.donkeydevelopment.csvexcel.gui.popup.PopupVO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class SheetFinderPopup
extends Popup {
    SheetFinderPopupVO answer;
    JFrame owner;
    JComboBox jbSheet = new JComboBox();
    JComboBox jbFoundColumns = new JComboBox();
    JComboBox jbFoundData = new JComboBox();
    JTextField jtHeadingRow = new JTextField();
    JTextField jtDataRow = new JTextField();
    private static Logger log = Logger.getLogger(SheetFinderPopup.class);

    public SheetFinderPopup(JFrame owner, String title, boolean modal, PopupVO answer) {
        super(owner, title, modal, false, true);
        this.owner = owner;
        this.answer = (SheetFinderPopupVO)answer;
    }

    public PopupVO showDialog() {
        this.setCenter(this.createCenter());
        this.createListeners();
        this.center();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.btOk);
        this.setVisible(true);
        return this.answer;
    }

    public void createListeners() {
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Integer.parseInt(SheetFinderPopup.this.jtHeadingRow.getText()) < 1) {
                    JOptionPane.showMessageDialog(SheetFinderPopup.this, "row number of headings must be greater than 0", "Input Error", 0);
                    SheetFinderPopup.this.jtHeadingRow.requestFocusInWindow();
                    return;
                }
                if (Integer.parseInt(SheetFinderPopup.this.jtDataRow.getText()) < 1) {
                    JOptionPane.showMessageDialog(SheetFinderPopup.this, "row number of first data must be greater than 0", "Input Error", 0);
                    SheetFinderPopup.this.jtDataRow.requestFocusInWindow();
                    return;
                }
                SheetFinderPopup.this.answer.setSheetNumber(SheetFinderPopup.this.jbSheet.getSelectedIndex());
                SheetFinderPopup.this.answer.setHeaderRow(Integer.parseInt(SheetFinderPopup.this.jtHeadingRow.getText()) - 1);
                SheetFinderPopup.this.answer.setDataRow(Integer.parseInt(SheetFinderPopup.this.jtDataRow.getText()) - 1);
                SheetFinderPopup.this.answer.setAction(true);
                SheetFinderPopup.this.dispose();
                JFrame frame = SheetFinderPopup.this.owner;
                if (frame != null) {
                    frame.dispose();
                    if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                        frame.setUndecorated(true);
                        frame.getRootPane().setWindowDecorationStyle(1);
                    } else {
                        frame.setUndecorated(false);
                    }
                    frame.setVisible(true);
                }
            }
        });
        this.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SheetFinderPopup.this.answer.setAction(false);
                SheetFinderPopup.this.dispose();
            }
        });
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(550, 350));
        JPanel infoPane = new JPanel(new BorderLayout());
        JTextArea jtaInfo = new JTextArea(this.answer.getInfoText());
        jtaInfo.setEditable(false);
        jtaInfo.setBackground(new JLabel().getBackground());
        jtaInfo.setPreferredSize(new Dimension(panel.getPreferredSize().width, 100));
        jtaInfo.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        infoPane.add(jtaInfo);
        panel.add((Component)infoPane, "North");
        JPanel subPane = new JPanel(new ParagraphLayout());
        JLabel lbSheet = new JLabel("data sheet");
        subPane.add((Component)lbSheet, ParagraphLayout.NEW_PARAGRAPH);
        this.jbSheet = new JComboBox<String>(this.answer.getSheetList());
        subPane.add(this.jbSheet);
        this.jbSheet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SheetFinderPopup.this.updateColumns();
                SheetFinderPopup.this.updateData();
            }
        });
        JLabel lbHeadings = new JLabel("column heading row");
        subPane.add((Component)lbHeadings, ParagraphLayout.NEW_PARAGRAPH);
        this.jtHeadingRow.setDocument(new PopupDocument(4, true));
        this.jtHeadingRow.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateColumns();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateColumns();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateColumns();
            }
        });
        this.jtHeadingRow.setHorizontalAlignment(4);
        this.jtHeadingRow.setText(Integer.toString(this.answer.getHeaderRow() + 1));
        this.jtHeadingRow.setPreferredSize(new Dimension(40, 25));
        subPane.add(this.jtHeadingRow);
        subPane.add(this.jbFoundColumns);
        JLabel lbData = new JLabel("first data row");
        subPane.add((Component)lbData, ParagraphLayout.NEW_PARAGRAPH);
        this.jtDataRow.setDocument(new PopupDocument(4, true));
        this.jtDataRow.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateData();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SheetFinderPopup.this.updateData();
            }
        });
        this.jtDataRow.setHorizontalAlignment(4);
        this.jtDataRow.setText(Integer.toString(this.answer.getDataRow() + 1));
        this.jtDataRow.setPreferredSize(new Dimension(40, 25));
        subPane.add(this.jtDataRow);
        subPane.add(this.jbFoundData);
        panel.add((Component)subPane, "Center");
        return panel;
    }

    private void updateColumns() {
        if (this.jtHeadingRow.getText().trim().length() > 0) {
            try {
                int row = Integer.parseInt(this.jtHeadingRow.getText());
                if (row > 0 && this.answer.getExcelToXml() != null) {
                    this.jbFoundColumns.setModel(new DefaultComboBoxModel<String>(this.answer.getExcelToXml().getExcelRowValues(this.jbSheet.getSelectedIndex(), row - 1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateData() {
        if (this.jtDataRow.getText().trim().length() > 0) {
            try {
                int row = Integer.parseInt(this.jtDataRow.getText());
                if (row > 0 && this.answer.getExcelToXml() != null) {
                    this.jbFoundData.setModel(new DefaultComboBoxModel<String>(this.answer.getExcelToXml().getExcelRowValues(this.jbSheet.getSelectedIndex(), row - 1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        SheetFinderPopupVO answer = new SheetFinderPopupVO();
        answer.setInfoText("Choose the data sheet that contains the data and supply the row \nwhich contain the column headings and the first data row.");
        answer.setSheetList(new String[]{"01:DATA", "02 SQL"});
        answer.setHeaderRow(0);
        answer.setDataRow(1);
        SheetFinderPopup popup = new SheetFinderPopup(null, "Choose data source", true, answer);
        popup.showDialog();
        if (answer.isActionOk()) {
            log.info((Object)("data row: " + answer.getDataRow()));
            log.info((Object)("header row: " + answer.getHeaderRow()));
            log.info((Object)("sheet number: " + answer.getSheetNumber()));
        }
        log.info((Object)"main ended");
    }
}

