/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.popup;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PopupDocument
extends PlainDocument {
    private int maxLength = 9999;
    private boolean numericOnly;

    public PopupDocument(int maxLength, boolean numericOnly) {
        this.maxLength = maxLength;
        this.numericOnly = numericOnly;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (this.getLength() + str.length() > this.maxLength) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            if (this.numericOnly) {
                Integer.parseInt(str);
            }
            super.insertString(offset, str, attr);
        }
        catch (NumberFormatException exp) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
    }
}

