/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.excel.processor.ExcelToXml;
import com.donkeydevelopment.csvexcel.filefilter.ExcelFileFilter;
import com.donkeydevelopment.csvexcel.prefs.CsvExcelXMLPreferences;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExcelToXmlAction
extends AbstractAction {
    static Logger log = Logger.getLogger(ExcelToXmlAction.class);
    JFrame frame = null;

    public ExcelToXmlAction(JFrame frame) {
        super("Excel to XML");
        this.frame = frame;
        this.putValue("ShortDescription", "Convert an MS Excel file to XML");
        URL url = ResourceLoader.class.getResource("excel.png");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block10: {
            try {
                PlugInManager contentManager;
                ContentHandler contentHandler;
                File fLast;
                File fInput = null;
                File fLastSelected = null;
                String lastSelectedFileName = CsvExcelXMLPreferences.getInstance().getLastExcelInput();
                if (lastSelectedFileName != null && (fLast = new File(lastSelectedFileName)).exists()) {
                    fLastSelected = fLast;
                }
                if (fLastSelected == null) {
                    fLastSelected = FileUtil.getSystemDefaultDocDir();
                }
                if ((fInput = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose the excel input file", new ExcelFileFilter(), fLastSelected)) == null) {
                    return;
                }
                CsvExcelXMLPreferences.getInstance().setLastExcelInput(fInput.getAbsolutePath());
                if (fInput == null || (contentHandler = (contentManager = PlugInManager.getInstance()).getContentHandler("xml")) == null) break block10;
                Source source = contentHandler.getSource();
                source.setName(fInput.getName());
                ExcelToXml excelToXml = null;
                try {
                    excelToXml = new ExcelToXml(fInput);
                    String xml = excelToXml.convertToXML();
                    if (xml != null) {
                        source.setContents(xml);
                        contentHandler.open(source);
                    }
                }
                finally {
                    if (excelToXml != null) {
                        excelToXml.close();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"EXCEL to XML conversion failed", (Throwable)e);
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "EXCEL to XML conversion failed", 0);
            }
        }
    }
}

