/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.donkeydevelopment.csvexcel.excel.processor.ExcelToXml;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExcelToXMLTreeAction
extends AbstractAction {
    static Logger log = Logger.getLogger(ExcelToXMLTreeAction.class);
    JFrame frame = null;
    File file = null;

    public ExcelToXMLTreeAction(JFrame frame, File f) {
        super("Excel to XML");
        this.frame = frame;
        this.file = f;
        this.putValue("ShortDescription", "Convert an Excel file to XML");
        URL url = ResourceLoader.class.getResource("excel.png");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        PlugInManager contentManager = PlugInManager.getInstance();
        ContentHandler contentHandler = contentManager.getContentHandler("xml");
        if (contentHandler != null) {
            Source source = contentHandler.getSource();
            source.setName(String.valueOf(this.file.getName()) + ".to.xml");
            ExcelToXml excelToXml = null;
            try {
                try {
                    excelToXml = new ExcelToXml(this.file);
                    String xml = excelToXml.convertToXML();
                    if (xml != null) {
                        source.setContents(xml);
                        contentHandler.open(source);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"EXCEL to XML conversion failed", (Throwable)e);
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "Excel to XML conversion failed", 0);
                    if (excelToXml != null) {
                        excelToXml.close();
                    }
                }
            }
            finally {
                if (excelToXml != null) {
                    excelToXml.close();
                }
            }
        }
    }
}

