/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.excel.action;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.common.xml.XMLTransformer;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.excel.data.ExcelColumn;
import com.donkeydevelopment.csvexcel.excel.data.ExcelXMLMapping;
import com.donkeydevelopment.csvexcel.excel.popup.SheetFinderPopupVO;
import com.donkeydevelopment.csvexcel.excel.popup.TypeMappingPopup;
import com.donkeydevelopment.csvexcel.excel.popup.TypeMappingPopupVO;
import com.donkeydevelopment.csvexcel.excel.processor.ExcelToXml;
import com.donkeydevelopment.csvexcel.filefilter.ExcelFileFilter;
import com.donkeydevelopment.csvexcel.filefilter.TemplateFileFilter;
import com.donkeydevelopment.csvexcel.grouping.Grouper;
import com.donkeydevelopment.csvexcel.gui.popup.FileNameMappingPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.ParameterMappingPopupVO;
import com.donkeydevelopment.csvexcel.mapping.ParameterMapping;
import com.donkeydevelopment.csvexcel.mapping.ParameterMappingList;
import com.donkeydevelopment.csvexcel.prefs.CsvExcelXMLPreferences;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import com.donkeydevelopment.csvexcel.row.FileRow;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import com.donkeydevelopment.csvexcel.utils.Helper;
import com.donkeydevelopment.csvexcel.utils.ParameterFinder;
import com.donkeydevelopment.csvexcel.utils.VariableFinder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class Excel2XmlTemplateAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Excel2XmlTemplateAction.class);
    String dummyXML = "<root></root>";
    File fTemplate = null;

    public Excel2XmlTemplateAction() {
        super("Excel to XML using a template", new ImageIcon(ResourceLoader.class.getResource("empty16.png")));
        this.putValue("ShortDescription", "Convert each record or group of records in an Excel file to a XML file");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = System.getProperty("javax.xml.transform.TransformerFactory");
        try {
            try {
                this.process();
            }
            catch (Exception e) {
                log.error((Object)"stacktrace", (Throwable)e);
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "Excel to XML Failed", 0);
                if (s != null) {
                    System.setProperty("javax.xml.transform.TransformerFactory", s);
                }
            }
        }
        finally {
            if (s != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", s);
            }
        }
    }

    public void process() throws Exception {
        ExcelToXml excelToXml = null;
        try {
            File fTemp;
            String sReturn;
            File fSelected;
            File fLast;
            System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
            File fInput = null;
            File fLastSelected = null;
            String lastSelectedFileName = CsvExcelXMLPreferences.getInstance().getLastExcelInput();
            if (lastSelectedFileName != null && (fLast = new File(lastSelectedFileName)).exists()) {
                fLastSelected = fLast;
            }
            if (fLastSelected == null) {
                fLastSelected = FileUtil.getSystemDefaultDocDir();
            }
            if ((fInput = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose the excel input file", new ExcelFileFilter(), fLastSelected)) == null) {
                return;
            }
            CsvExcelXMLPreferences.getInstance().setLastExcelInput(fInput.getAbsolutePath());
            excelToXml = new ExcelToXml(fInput);
            SheetFinderPopupVO answerSF = excelToXml.getDataSheetInfo();
            Integer sheetNr = answerSF.getSheetNumber();
            Integer headerRowNr = answerSF.getHeaderRow();
            Integer firstDataRowNr = answerSF.getDataRow();
            ArrayList<ExcelColumn> columnList = excelToXml.getExcelColumns(sheetNr, headerRowNr, firstDataRowNr);
            ArrayList<ExcelXMLMapping> mappingList = new ArrayList<ExcelXMLMapping>();
            for (ExcelColumn excelColumn : columnList) {
                ExcelXMLMapping excelXMLMapping = new ExcelXMLMapping();
                excelXMLMapping.setExcelColumn(excelColumn);
                excelXMLMapping.setXmlType(excelColumn.getExcelType().getDefaultXMLType());
                mappingList.add(excelXMLMapping);
            }
            TypeMappingPopupVO answer = new TypeMappingPopupVO();
            answer.setMappingList(mappingList);
            answer.setExcelToXml(excelToXml);
            answer.setInfoText("Excel text columns will exactly be copied as displayed in Excel. So if possible, format all cells within Excel as text to get the\nmost predictable results.\n\nBoolean columns will be copied as either \"true\"or \"false\".\n\nNumeric columns will be standard formatted with a decimal point and a a maximum scale of 11.\nThis means that maximal 11 digits will be displayed to the right of the decimal point.\nNegative numeric values be displayed with a minus sign to the left.\n\nFor date columns you have to choose the most appropriate format.\nYou can preview the value of the first data row in the exampe column.");
            TypeMappingPopup popup = new TypeMappingPopup(null, "Choose Column Format", true, answer);
            answer = (TypeMappingPopupVO)popup.showDialog();
            if (!answer.isActionOk()) {
                return;
            }
            if (this.fTemplate == null) {
                String lastTemplate = CsvExcelXMLPreferences.getInstance().getLastTemplate();
                this.fTemplate = lastTemplate != null ? new File(lastTemplate) : fInput;
            }
            if ((fSelected = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose the template file", new TemplateFileFilter(), this.fTemplate)) == null) {
                return;
            }
            this.fTemplate = fSelected;
            CsvExcelXMLPreferences.getInstance().setLastTemplate(this.fTemplate.getAbsolutePath());
            XMLTransformer aXMLTransformer = null;
            String[] parameterList = null;
            if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
                ParameterFinder parmFinder = new ParameterFinder(this.fTemplate);
                parameterList = parmFinder.getParameterNames();
                aXMLTransformer = new XMLTransformer(this.fTemplate);
            } else {
                VariableFinder variableFinder = new VariableFinder("xsl/find_var.xsl", this.fTemplate.getAbsolutePath());
                parameterList = variableFinder.getVariableNames();
                aXMLTransformer = new XMLTransformer(new File("xsl/substitute_var.xsl"));
            }
            ParameterMappingList parameterMappingList = new ParameterMappingList();
            if (parameterList.length > 0) {
                ParameterMappingPopupVO answerMappingPopup = Helper.mapColumns(parameterList, ExcelToXml.getColumnNames(columnList));
                if (answerMappingPopup.isActionCancel()) {
                    return;
                }
                parameterMappingList = answerMappingPopup.getMappingList();
            }
            String groupOn = "None";
            if ((this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) && (sReturn = Grouper.getGrouping(Grouper.GROUPING_TYPES, ExcelToXml.getColumnNames(columnList))) != null) {
                groupOn = sReturn;
            }
            log.debug((Object)("grouping: " + groupOn));
            String sOutputDir = CsvExcelXMLPreferences.getInstance().getLastOutputDir();
            File fOutputDir = fInput.getParentFile();
            if (sOutputDir != null && (fTemp = new File(sOutputDir)).exists() && fTemp.isDirectory()) {
                fOutputDir = fTemp;
            }
            if ((fOutputDir = FileChooser.getOutputDirectory((Component)Frame.getInstance(), fOutputDir, "Choose output directory")) == null) {
                return;
            }
            CsvExcelXMLPreferences.getInstance().setLastOutputDir(fOutputDir.getAbsolutePath());
            FileNameMappingPopupVO fileNameMappingAnswer = Helper.getFileNameMapping(ExcelToXml.getColumnNames(columnList), groupOn);
            if (fileNameMappingAnswer.isActionCancel()) {
                return;
            }
            FileRow oldFileRow = null;
            FileRow fileRow = null;
            File fileOut = null;
            StringBuilder xmlGroup = new StringBuilder();
            Row row = null;
            Sheet sheet = excelToXml.getWorkbook().getSheetAt(sheetNr.intValue());
            int lastRowNr = sheet.getLastRowNum();
            int i = 0;
            int rowindx = firstDataRowNr;
            while (rowindx <= lastRowNr) {
                ++i;
                row = sheet.getRow(rowindx);
                if (row != null && excelToXml.atLeastOneCellFilled(row)) {
                    String[] values = new String[mappingList.size()];
                    String[] colnames = new String[mappingList.size()];
                    int j = 0;
                    while (j < mappingList.size()) {
                        ExcelXMLMapping excelXMLMapping = mappingList.get(j);
                        ExcelColumn excelColumn = excelXMLMapping.getExcelColumn();
                        Cell cell = row.getCell(excelColumn.getIndex());
                        values[j] = excelToXml.getFormattedValue(cell, excelXMLMapping.getXmlType());
                        colnames[j] = excelColumn.getName();
                        ++j;
                    }
                    fileRow = new FileRow(colnames, values);
                    if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
                        if (Grouper.isBreakingRow(fileRow, oldFileRow, i, groupOn) && i > 1) {
                            Grouper.writeGroup(aXMLTransformer, xmlGroup, fileOut);
                        }
                        if (Grouper.isBreakingRow(fileRow, oldFileRow, i, groupOn)) {
                            fileOut = Helper.getFileOut(fOutputDir, fileNameMappingAnswer, fileRow, i);
                            int h = 0;
                            while (h < parameterMappingList.getMappings().size()) {
                                ParameterMapping parameterMapping = parameterMappingList.getMappings().get(h);
                                aXMLTransformer.getTransformer().setParameter(parameterMapping.getParameterName(), values[parameterMapping.getColumnNr()]);
                                ++h;
                            }
                            xmlGroup = new StringBuilder();
                            xmlGroup.append("<table>");
                        }
                        xmlGroup.append(fileRow.toXml());
                    } else {
                        StringBuffer xml = new StringBuffer();
                        xml.append("<replacements>");
                        int h = 0;
                        while (h < parameterMappingList.getMappings().size()) {
                            ParameterMapping parameterMapping = parameterMappingList.getMappings().get(h);
                            xml.append("<entry key=\"");
                            xml.append(parameterMapping.getParameterName());
                            xml.append("\">");
                            xml.append(XMLWriter.getNormalizedValue(values[parameterMapping.getColumnNr()], true));
                            xml.append("</entry>");
                            ++h;
                        }
                        xml.append("</replacements>");
                        aXMLTransformer.getTransformer().setParameter("replacements", Helper.getNodeSet(Helper.getDocument(xml.toString())));
                        StreamSource source = new StreamSource(this.fTemplate);
                        fileOut = Helper.getFileOut(fOutputDir, fileNameMappingAnswer, fileRow, i);
                        StreamResult result = new StreamResult(fileOut);
                        aXMLTransformer.transform(source, result);
                    }
                }
                oldFileRow = fileRow;
                ++rowindx;
            }
            if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
                Grouper.writeGroup(aXMLTransformer, xmlGroup, fileOut);
            }
            JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Excel to XML completed", "Excel to XML", 1);
        }
        finally {
            if (excelToXml != null) {
                excelToXml.close();
            }
        }
    }
}

