/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.processor;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.io.CustomFileReader;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.csv.io.CsvFileReader;
import com.donkeydevelopment.csvexcel.csv.io.CsvUtil;
import com.donkeydevelopment.csvexcel.utils.Helper;
import java.awt.Component;
import java.io.File;
import org.apache.log4j.Logger;

public class CsvToXML {
    private static Logger log = Logger.getLogger(CsvToXML.class);
    private File fCsv;

    public CsvToXML(File fCsv) {
        this.fCsv = fCsv;
    }

    public String getXML() throws Exception {
        String pathInputFile = this.fCsv.getAbsolutePath();
        CustomFileReader customFileReader = new CustomFileReader(pathInputFile, null);
        String line = customFileReader.readNext();
        customFileReader.close();
        String separatorStr = Helper.getSeparator((Component)Frame.getInstance(), CsvUtil.getMostLikelySeparator(line));
        if (separatorStr == null) {
            return "";
        }
        CsvFileReader csvFileReader = new CsvFileReader(pathInputFile, null, Helper.getSeparatorAsChar(separatorStr));
        String[] columnList = csvFileReader.readNextValues();
        if (columnList != null) {
            int i = 0;
            while (i < columnList.length) {
                log.debug((Object)("gevonden kolom namen in csv file " + columnList[i]));
                ++i;
            }
        }
        StringBuffer xml = new StringBuffer();
        XMLWriter.doDeclaration(xml, "UTF-8");
        XMLWriter.doLine(xml);
        xml.append("<table>");
        String[] values = null;
        while ((values = csvFileReader.readNextValues()) != null) {
            XMLWriter.doLineAndIndent(xml, 1);
            xml.append("<row>");
            int colnr = 0;
            String[] stringArray = columnList;
            int n = columnList.length;
            int n2 = 0;
            while (n2 < n) {
                String colname = stringArray[n2];
                XMLWriter.doLineAndIndent(xml, 2);
                xml.append(XMLWriter.normalizeAndPrint(colname, values[colnr]));
                ++colnr;
                ++n2;
            }
            xml.append("</row>");
        }
        XMLWriter.doLine(xml);
        xml.append("</table>");
        return xml.toString();
    }
}

