/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.io;

import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;

public class Record {
    String[] fields = null;
    String line = null;

    public Record() {
    }

    public Record(String line, char separator) {
        this.line = line;
        this.split(line, separator);
    }

    private void split(String line, char c) {
        if (c == '\t') {
            this.fields = line.split("\\t");
        } else if (c == ',') {
            this.fields = line.split(",");
        } else if (c == ';') {
            this.fields = line.split(";");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-----start record-----\n");
        int i = 0;
        while (i < this.fields.length) {
            sb.append("field[" + i + "]" + "=" + this.fields[i] + "\n");
            ++i;
        }
        sb.append("-----end   record-----\n");
        return sb.toString();
    }

    public String toXML(int level, boolean doLineBreak, String[] columnList) {
        StringBuffer sb = new StringBuffer();
        if (doLineBreak) {
            XMLWriter.doLineAndIndent(sb, level);
        } else {
            XMLWriter.doIndent(sb, level);
        }
        sb.append("<row>");
        int h = 0;
        while (h < columnList.length) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint(columnList[h], this.fields[h]));
            ++h;
        }
        XMLWriter.doLineAndIndent(sb, level);
        sb.append("</row>");
        return sb.toString();
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getFieldsQuotesRemoved() {
        if (this.fields != null) {
            String[] fields2 = new String[this.fields.length];
            int i = 0;
            String[] stringArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                fields2[i] = this.removeQuotes(s);
                ++i;
                ++n2;
            }
            return fields2;
        }
        return this.fields;
    }

    public String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }
}

