/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.io;

import com.donkeydevelopment.csvexcel.csv.io.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class CustomCsvFileReader {
    String fileName = null;
    BufferedReader in = null;
    char separator = (char)44;
    private static Logger log = Logger.getLogger(CustomCsvFileReader.class);

    public CustomCsvFileReader(String fileName, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.fileName = fileName;
        FileInputStream fi = new FileInputStream(new File(fileName));
        this.in = encoding == null ? new BufferedReader(new InputStreamReader(fi)) : (encoding.trim().length() > 0 ? new BufferedReader(new InputStreamReader((InputStream)fi, encoding)) : new BufferedReader(new InputStreamReader(fi)));
    }

    public void printAllRecords() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.fileName));
        Record record = null;
        while ((record = this.readNext()) != null) {
            log.debug((Object)record);
        }
        in.close();
    }

    public Record readNext() throws IOException {
        String line;
        if (this.in == null) {
            this.in = new BufferedReader(new FileReader(this.fileName));
        }
        if ((line = this.in.readLine()) != null) {
            return new Record(line, this.separator);
        }
        this.close();
        return null;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        System.out.println("Program Started ");
        try {
            try {
                CustomCsvFileReader customCsvFileReader = new CustomCsvFileReader(args[0], null);
                customCsvFileReader.printAllRecords();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime));
            }
        }
        finally {
            System.out.println("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime));
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

