/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.io;

public class CsvUtil {
    private static final String QUOTE = "\"";
    private static final String ESCAPED_QUOTE = "\"\"";
    private static final char[] CHARACTERS_THAT_MUST_BE_QUOTED = new char[]{',', '\"', '\n'};
    private static String rexCsvSplitter = ",(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))";

    public static String unescape(String s) {
        if (s.startsWith(QUOTE) && s.endsWith(QUOTE) && (s = s.substring(1, s.length() - 1)).contains(ESCAPED_QUOTE)) {
            s = s.replace(ESCAPED_QUOTE, QUOTE);
        }
        return s;
    }

    public static String escape(String s) {
        if (s.contains(QUOTE)) {
            s = s.replace(QUOTE, ESCAPED_QUOTE);
        }
        boolean found = false;
        char[] cArray = CHARACTERS_THAT_MUST_BE_QUOTED;
        int n = CHARACTERS_THAT_MUST_BE_QUOTED.length;
        int n2 = 0;
        while (n2 < n) {
            char searchChar = cArray[n2];
            if (s.indexOf(searchChar) > -1) {
                found = true;
                break;
            }
            ++n2;
        }
        if (found) {
            s = QUOTE + s + QUOTE;
        }
        return s;
    }

    public static String[] getParts(String line, char separator) {
        String rexCharSplitter = null;
        rexCharSplitter = separator == '\t' ? "\t" + rexCsvSplitter.substring(1) : String.valueOf(separator) + rexCsvSplitter.substring(1);
        return line.split(rexCharSplitter, -1);
    }

    public static String getMostLikelySeparator(String line) {
        String[] separatorList = new String[]{"comma     (,)", "semicolon (;)", "tab"};
        int index = 0;
        if (line != null) {
            String[] fieldsSemicolon;
            int count = -1;
            index = 0;
            String[] fieldsComma = line.split(",");
            count = fieldsComma.length;
            String[] fieldsTab = line.split("\\t");
            if (fieldsTab.length > count) {
                count = fieldsTab.length;
                index = 2;
            }
            if ((fieldsSemicolon = line.split(";")).length > count) {
                count = fieldsSemicolon.length;
                index = 1;
            }
        }
        return separatorList[index];
    }
}

