/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.io;

import com.donkeydevelopment.csvexcel.common.io.CustomFileReader;
import com.donkeydevelopment.csvexcel.csv.io.CsvUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class CsvFileReader
extends CustomFileReader {
    private static Logger log = Logger.getLogger(CsvFileReader.class);
    String sLine = null;
    private static String rexCsvSplitter = ",(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))";
    private static String rexRunOnLine = "^[^\"]*(?:\"[^\"]*\"[^\"]*)*\"[^\"]*$";
    private static String rexCharSplitter = null;
    char separator = (char)44;

    public CsvFileReader(String fileName, String encoding, char separator) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, encoding);
        this.separator = separator;
        rexCharSplitter = separator == '\t' ? "\t" + rexCsvSplitter.substring(1) : String.valueOf(separator) + rexCsvSplitter.substring(1);
    }

    public String[] readNextValues() throws IOException {
        this.sLine = super.readNext();
        if (this.sLine != null) {
            String sNextLine = null;
            while (this.sLine.matches(rexRunOnLine) && (sNextLine = super.readNext()) != null) {
                this.sLine = String.valueOf(this.sLine) + "\n" + sNextLine;
            }
            String[] values = this.sLine.split(rexCharSplitter, -1);
            int i = 0;
            while (i < values.length) {
                values[i] = CsvUtil.unescape(values[i]);
                ++i;
            }
            return values;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            CsvFileReader reader = new CsvFileReader(args[0], null, ',');
            String[] values = null;
            while ((values = reader.readNextValues()) != null) {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    log.debug((Object)("values " + value));
                    ++n2;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLine() {
        return this.sLine;
    }
}

