/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.csv.processor.CsvToXML;
import com.donkeydevelopment.csvexcel.filefilter.CsvFileFilter;
import com.donkeydevelopment.csvexcel.prefs.CsvExcelXMLPreferences;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CsvToXmlAction
extends AbstractAction {
    static Logger log = Logger.getLogger(CsvToXmlAction.class);
    JFrame frame = null;

    public CsvToXmlAction(JFrame frame) {
        super("CSV to XML");
        this.frame = frame;
        this.putValue("ShortDescription", "Convert a csv file to XML");
        URL url = ResourceLoader.class.getResource("csv.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            File fCsv;
            File fLast;
            File fLastSelected = null;
            String lastSelectedFileName = CsvExcelXMLPreferences.getInstance().getLastCsvInput();
            if (lastSelectedFileName != null && (fLast = new File(lastSelectedFileName)).exists()) {
                fLastSelected = fLast;
            }
            if (fLastSelected == null) {
                fLastSelected = FileUtil.getSystemDefaultDocDir();
            }
            if ((fCsv = FileChooser.chooseFile((Component)Frame.getInstance(), "Open a file with delimiter (tab,comma,semicolon) separated values", new CsvFileFilter(), fLastSelected)) == null) {
                return;
            }
            CsvExcelXMLPreferences.getInstance().setLastCsvInput(fCsv.getAbsolutePath());
            CsvToXML csvToXmlProcessor = new CsvToXML(fCsv);
            PlugInManager contentManager = PlugInManager.getInstance();
            ContentHandler contentHandler = contentManager.getContentHandler("xml");
            if (contentHandler != null) {
                Source source = contentHandler.getSource();
                source.setName(fCsv.getName());
                source.setContents(csvToXmlProcessor.getXML());
                contentHandler.open(source);
            }
        }
        catch (Exception e) {
            log.error((Object)"CSV to XML conversion failed", (Throwable)e);
            JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "CSV to XML conversion failed", 0);
        }
    }
}

