/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.donkeydevelopment.csvexcel.csv.processor.CsvToXML;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CsvToXMLTreeAction
extends AbstractAction {
    static Logger log = Logger.getLogger(CsvToXMLTreeAction.class);
    JFrame frame = null;
    File file = null;

    public CsvToXMLTreeAction(JFrame frame, File f) {
        super("CSV to XML");
        this.frame = frame;
        this.file = f;
        this.putValue("ShortDescription", "Convert a csv file to XML");
        URL url = ResourceLoader.class.getResource("csv.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        CsvToXML csvToXmlProcessor = new CsvToXML(this.file);
        PlugInManager contentManager = PlugInManager.getInstance();
        ContentHandler contentHandler = contentManager.getContentHandler("xml");
        if (contentHandler != null) {
            Source source = contentHandler.getSource();
            source.setName(String.valueOf(this.file.getName()) + ".to.xml");
            try {
                source.setContents(csvToXmlProcessor.getXML());
                contentHandler.open(source);
            }
            catch (Exception e) {
                log.error((Object)"CSV to XML conversion failed", (Throwable)e);
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "CSV to XML conversion failed", 0);
            }
        }
    }
}

