/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.csv.action;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.io.CustomFileReader;
import com.donkeydevelopment.csvexcel.common.io.FileUtil;
import com.donkeydevelopment.csvexcel.common.xml.XMLTransformer;
import com.donkeydevelopment.csvexcel.common.xml.XMLWriter;
import com.donkeydevelopment.csvexcel.csv.io.CsvFileReader;
import com.donkeydevelopment.csvexcel.csv.io.CsvUtil;
import com.donkeydevelopment.csvexcel.filefilter.CsvFileFilter;
import com.donkeydevelopment.csvexcel.filefilter.TemplateFileFilter;
import com.donkeydevelopment.csvexcel.grouping.Grouper;
import com.donkeydevelopment.csvexcel.gui.popup.FileNameMappingPopupVO;
import com.donkeydevelopment.csvexcel.gui.popup.ParameterMappingPopupVO;
import com.donkeydevelopment.csvexcel.mapping.ParameterMapping;
import com.donkeydevelopment.csvexcel.mapping.ParameterMappingList;
import com.donkeydevelopment.csvexcel.prefs.CsvExcelXMLPreferences;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import com.donkeydevelopment.csvexcel.row.FileRow;
import com.donkeydevelopment.csvexcel.utils.FileChooser;
import com.donkeydevelopment.csvexcel.utils.Helper;
import com.donkeydevelopment.csvexcel.utils.ParameterFinder;
import com.donkeydevelopment.csvexcel.utils.VariableFinder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class Csv2XmlTemplateAction
extends AbstractAction {
    private static Logger log = Logger.getLogger(Csv2XmlTemplateAction.class);
    String dummyXML = "<root></root>";
    File fTemplate = null;

    public Csv2XmlTemplateAction() {
        super("CSV to XML using a template ", new ImageIcon(ResourceLoader.class.getResource("empty16.png")));
        this.putValue("ShortDescription", "Convert each record or group of records in a CSV file to a XML file");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = System.getProperty("javax.xml.transform.TransformerFactory");
        try {
            try {
                this.process();
            }
            catch (Exception e) {
                log.error((Object)"stacktrace", (Throwable)e);
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), e.toString(), "CSV to XML Failed", 0);
                if (s != null) {
                    System.setProperty("javax.xml.transform.TransformerFactory", s);
                }
            }
        }
        finally {
            if (s != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", s);
            }
        }
    }

    public void process() throws Exception {
        File fTemp;
        String sReturn;
        File fSelected;
        File fLast;
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        File fLastSelected = null;
        String lastSelectedFileName = CsvExcelXMLPreferences.getInstance().getLastCsvInput();
        if (lastSelectedFileName != null && (fLast = new File(lastSelectedFileName)).exists()) {
            fLastSelected = fLast;
        }
        if (fLastSelected == null) {
            fLastSelected = FileUtil.getSystemDefaultDocDir();
        }
        String pathInputFile = null;
        File fCsv = FileChooser.chooseFile((Component)Frame.getInstance(), "Open a file with delimiter (tab,comma,semicolon) separated values", new CsvFileFilter(), fLastSelected);
        if (fCsv == null) {
            return;
        }
        CsvExcelXMLPreferences.getInstance().setLastCsvInput(fCsv.getAbsolutePath());
        pathInputFile = fCsv.getAbsolutePath();
        CustomFileReader customFileReader = new CustomFileReader(pathInputFile, null);
        String line = customFileReader.readNext();
        customFileReader.close();
        String separatorStr = Helper.getSeparator((Component)Frame.getInstance(), CsvUtil.getMostLikelySeparator(line));
        if (separatorStr == null) {
            return;
        }
        if (this.fTemplate == null) {
            String lastTemplate = CsvExcelXMLPreferences.getInstance().getLastTemplate();
            this.fTemplate = lastTemplate != null ? new File(lastTemplate) : fCsv;
        }
        if ((fSelected = FileChooser.chooseFile((Component)Frame.getInstance(), "Choose the template file", new TemplateFileFilter(), this.fTemplate)) == null) {
            return;
        }
        this.fTemplate = fSelected;
        CsvExcelXMLPreferences.getInstance().setLastTemplate(this.fTemplate.getAbsolutePath());
        CsvFileReader csvFileReader = new CsvFileReader(pathInputFile, null, Helper.getSeparatorAsChar(separatorStr));
        String[] columnList = csvFileReader.readNextValues();
        if (columnList != null) {
            int i = 0;
            while (i < columnList.length) {
                log.debug((Object)("gevonden kolom namen in csv file " + columnList[i]));
                ++i;
            }
        }
        XMLTransformer aXMLTransformer = null;
        String[] parameterList = null;
        if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
            ParameterFinder parmFinder = new ParameterFinder(this.fTemplate);
            parameterList = parmFinder.getParameterNames();
            aXMLTransformer = new XMLTransformer(this.fTemplate);
        } else {
            VariableFinder variableFinder = new VariableFinder("xsl/find_var.xsl", this.fTemplate.getAbsolutePath());
            parameterList = variableFinder.getVariableNames();
            aXMLTransformer = new XMLTransformer(new File("xsl/substitute_var.xsl"));
        }
        ParameterMappingList parameterMappingList = new ParameterMappingList();
        if (parameterList.length > 0) {
            ParameterMappingPopupVO answerMappingPopup = Helper.mapColumns(parameterList, columnList);
            if (answerMappingPopup.isActionCancel()) {
                return;
            }
            parameterMappingList = answerMappingPopup.getMappingList();
        }
        String groupOn = "None";
        if ((this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) && (sReturn = Grouper.getGrouping(Grouper.GROUPING_TYPES, columnList)) != null) {
            groupOn = sReturn;
        }
        log.debug((Object)("grouping: " + groupOn));
        String sOutputDir = CsvExcelXMLPreferences.getInstance().getLastOutputDir();
        File fOutputDir = fCsv.getParentFile();
        if (sOutputDir != null && (fTemp = new File(sOutputDir)).exists() && fTemp.isDirectory()) {
            fOutputDir = fTemp;
        }
        if ((fOutputDir = FileChooser.getOutputDirectory((Component)Frame.getInstance(), fOutputDir, "Choose output directory")) == null) {
            return;
        }
        CsvExcelXMLPreferences.getInstance().setLastOutputDir(fOutputDir.getAbsolutePath());
        FileNameMappingPopupVO fileNameMappingAnswer = Helper.getFileNameMapping(columnList, groupOn);
        if (fileNameMappingAnswer.isActionCancel()) {
            return;
        }
        int i = 0;
        FileRow oldFileRow = null;
        FileRow fileRow = null;
        File fileOut = null;
        StringBuilder xmlGroup = new StringBuilder();
        String[] values = null;
        while ((values = csvFileReader.readNextValues()) != null) {
            ++i;
            if (values.length != columnList.length) {
                log.error((Object)("record " + i + " has been skipper because of invalid number of columns"));
                log.error((Object)"Check content the record to see if the content does contain use the separator");
                log.error((Object)csvFileReader.getLine());
            } else {
                fileRow = new FileRow(columnList, values);
                if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
                    if (Grouper.isBreakingRow(fileRow, oldFileRow, i, groupOn) && i > 1) {
                        Grouper.writeGroup(aXMLTransformer, xmlGroup, fileOut);
                    }
                    if (Grouper.isBreakingRow(fileRow, oldFileRow, i, groupOn)) {
                        fileOut = Helper.getFileOut(fOutputDir, fileNameMappingAnswer, fileRow, i);
                        int h = 0;
                        while (h < parameterMappingList.getMappings().size()) {
                            ParameterMapping mapping = parameterMappingList.getMappings().get(h);
                            aXMLTransformer.getTransformer().setParameter(mapping.getParameterName(), values[mapping.getColumnNr()]);
                            ++h;
                        }
                        xmlGroup = new StringBuilder();
                        xmlGroup.append("<table>");
                    }
                    xmlGroup.append(fileRow.toXml());
                } else {
                    StringBuffer xml = new StringBuffer();
                    xml.append("<replacements>");
                    int h = 0;
                    while (h < parameterMappingList.getMappings().size()) {
                        ParameterMapping mapping = parameterMappingList.getMappings().get(h);
                        xml.append("<entry key=\"");
                        xml.append(mapping.getParameterName());
                        xml.append("\">");
                        xml.append(XMLWriter.getNormalizedValue(values[mapping.getColumnNr()], true));
                        xml.append("</entry>");
                        ++h;
                    }
                    xml.append("</replacements>");
                    aXMLTransformer.getTransformer().setParameter("replacements", Helper.getNodeSet(Helper.getDocument(xml.toString())));
                    StreamSource source = new StreamSource(this.fTemplate);
                    fileOut = Helper.getFileOut(fOutputDir, fileNameMappingAnswer, fileRow, i);
                    StreamResult result = new StreamResult(fileOut);
                    aXMLTransformer.transform(source, result);
                }
            }
            oldFileRow = fileRow;
        }
        if (this.fTemplate.getName().endsWith("xsl") || this.fTemplate.getName().endsWith("xslt")) {
            Grouper.writeGroup(aXMLTransformer, xmlGroup, fileOut);
        }
        JOptionPane.showMessageDialog((Component)Frame.getInstance(), "CSV to XML completed", "CSV to XML", 1);
    }
}

