/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.xml;

public class XMLWriter {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static int indentAmount = 3;
    private static boolean fXML11 = false;
    protected static boolean fCanonical = false;

    public static String getLineIndent(int level) {
        StringBuffer sb = new StringBuffer(level + indentAmount);
        int i = 0;
        while (i < level) {
            int j = 0;
            while (j < indentAmount) {
                sb.append(" ");
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public static void doLineAndIndent(StringBuffer sb, int level) {
        sb.append(NEWLINE);
        sb.append(XMLWriter.getLineIndent(level));
    }

    public static void doLine(StringBuffer sb) {
        sb.append(NEWLINE);
    }

    public static void doIndent(StringBuffer sb, int level) {
        sb.append(XMLWriter.getLineIndent(level));
    }

    public static void doDeclaration(StringBuffer sb, String encoding) {
        if (encoding != null) {
            sb.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        } else {
            sb.append("<?xml version=\"1.0\" ?>");
        }
    }

    public static void doStylesheetDeclaration(StringBuffer sb, String url) {
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + url + "\"?>");
    }

    public static String normalizeAndPrint(String tagname, String s) {
        return XMLWriter.normalizeAndPrint(tagname, s, false);
    }

    public static String normalizeAndPrint(String tagname, String s, boolean isAttValue) {
        int len;
        StringBuffer sb = new StringBuffer();
        int n = len = s != null ? s.length() : 0;
        if (len == 0) {
            if (!isAttValue) {
                return "<" + tagname + "/>";
            }
            return " " + tagname + "=\"\"";
        }
        if (!isAttValue) {
            sb.append("<" + tagname + ">");
        } else {
            sb.append(" " + tagname + "=\"");
        }
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            XMLWriter.normalizeAndPrint(sb, c, isAttValue);
            ++i;
        }
        if (!isAttValue) {
            sb.append("</" + tagname + ">");
        } else {
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String getNormalizedValue(String value, boolean isAttValue) {
        int len = value != null ? value.length() : 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            XMLWriter.normalizeAndPrint(sb, c, isAttValue);
            ++i;
        }
        return sb.toString();
    }

    protected static void normalizeAndPrint(StringBuffer sb, char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                sb.append("&lt;");
                break;
            }
            case '>': {
                sb.append("&gt;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    sb.append("&quot;");
                    break;
                }
                sb.append("\"");
                break;
            }
            case '\r': {
                sb.append("&#xD;");
                break;
            }
            case '\n': {
                if (fCanonical) {
                    sb.append("&#xA;");
                    break;
                }
            }
            default: {
                if (fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    sb.append("&#x");
                    sb.append(Integer.toHexString(c).toUpperCase());
                    sb.append(";");
                    break;
                }
                sb.append(c);
            }
        }
    }
}

