/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.xml;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class XMLTransformer {
    static Logger logger = Logger.getLogger(XMLTransformer.class);
    Transformer transformer = null;

    public XMLTransformer(File xsltFile) throws Exception {
        if (!xsltFile.exists()) {
            logger.error((Object)(String.valueOf(xsltFile.getAbsolutePath()) + " not exists"));
            throw new Exception(String.valueOf(xsltFile.getAbsolutePath()) + " not exists");
        }
        StreamSource stylesource = new StreamSource(xsltFile);
        TransformerFactory factory = TransformerFactory.newInstance();
        this.transformer = factory.newTransformer(stylesource);
        Properties props = this.transformer.getOutputProperties();
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = props.getProperty(key);
            logger.debug((Object)("transformer output property " + key + "=" + value));
        }
    }

    public void transform(File inputFile, File outputFile) throws TransformerException {
        StreamSource inputSource = new StreamSource(inputFile);
        StreamResult result = new StreamResult(outputFile);
        this.transformer.transform(inputSource, result);
    }

    public void transform(Source source, Result result) throws TransformerException {
        this.transformer.transform(source, result);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

