/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.model;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArrayListComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selectedItem;
    private ArrayList<Object> anArrayList;
    private static Logger log = Logger.getLogger(ArrayListComboBoxModel.class);

    public ArrayListComboBoxModel(ArrayList<Object> arrayList) {
        this.anArrayList = arrayList;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object newValue) {
        this.selectedItem = newValue;
        if (this.anArrayList.size() > 0) {
            this.fireContentsChanged(this, 0, this.anArrayList.size() - 1);
        }
    }

    @Override
    public int getSize() {
        return this.anArrayList.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.anArrayList.get(i);
    }

    public void addItemAt(int indx, Object item) {
        this.anArrayList.add(indx, item);
        this.fireIntervalAdded(this, indx, indx);
    }

    public void removeItemAt(int indx) {
        this.anArrayList.remove(indx);
        this.fireIntervalRemoved(this, indx, indx);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("ArrayListComboBoxModel");
                frame.setDefaultCloseOperation(3);
                File[] files = new File("h:\\temp").listFiles();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    arrayList.add(f);
                    ++n2;
                }
                final ArrayListComboBoxModel model = new ArrayListComboBoxModel(arrayList);
                final JComboBox comboBox = new JComboBox(model);
                comboBox.setEditable(false);
                Container contentPane = frame.getContentPane();
                contentPane.add(comboBox, "Center");
                JButton jb1 = new JButton("add");
                jb1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File f = new File("c:\\temp\\testjeadd.txt");
                        model.addItemAt(0, f);
                        System.out.println(model.getSize());
                    }
                });
                contentPane.add((Component)jb1, "South");
                JButton jb2 = new JButton("set 2");
                jb2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("set to 2");
                        comboBox.setSelectedIndex(2);
                        comboBox.requestFocusInWindow();
                    }
                });
                contentPane.add((Component)jb2, "North");
                frame.setSize(300, 225);
                frame.setVisible(true);
            }
        });
    }
}

