/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.io;

import com.dd.gui.components.Frame;
import com.donkeydevelopment.csvexcel.common.io.BufferedFileWriter;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class FileUtil {
    public static void writeToFile(File outFile, String xogresultstr) {
        try {
            BufferedWriter bw = BufferedFileWriter.getWriter(outFile, "UTF-8", false);
            bw.write(xogresultstr);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)Frame.getInstance(), "File could not be saved \n" + e.toString(), "IO Exception", 0);
        }
    }

    public static String getFileName(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            return name.substring(0, i);
        }
        return name;
    }

    public static String getExtension(File f, String extension) {
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            return name.substring(i + 1);
        }
        return extension;
    }

    public static File getWorkDir() {
        String workdir = System.getProperty("user.dir");
        if (workdir.endsWith(System.getProperty("file.separator"))) {
            workdir = workdir.substring(0, workdir.length() - 1);
        }
        return new File(workdir);
    }

    public static String getHomeDir() {
        String homedir = System.getProperty("user.home");
        if (homedir.endsWith(System.getProperty("file.separator"))) {
            homedir = homedir.substring(0, homedir.length() - 1);
        }
        return homedir;
    }

    public static File getDefaultDocDir() {
        JFileChooser fc = new JFileChooser();
        FileSystemView fw = fc.getFileSystemView();
        File fDocuments = fw.getDefaultDirectory();
        return fDocuments;
    }

    public static File getSystemDefaultDocDir() {
        JFileChooser fc = new JFileChooser();
        FileSystemView fw = fc.getFileSystemView();
        File fDocuments = fw.getDefaultDirectory();
        if (System.getProperty("mrj.version") != null && new File(fDocuments, "Documents").exists()) {
            fDocuments = new File(fDocuments, "Documents");
        }
        return fDocuments;
    }

    public static File getApplicationDataDir() {
        File fDoc = FileUtil.getDefaultDocDir();
        if (System.getProperty("mrj.version") != null && new File(fDoc, "Documents").exists()) {
            fDoc = new File(fDoc, "Documents");
        }
        return new File(fDoc, "Rappido");
    }
}

