/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class CustomFileWriter {
    private static Logger log = Logger.getLogger(CustomFileWriter.class);
    String fileName = null;
    BufferedWriter out = null;
    protected long countLines = 0L;
    protected boolean append;

    public CustomFileWriter(String fileName, boolean append, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.fileName = fileName;
        this.append = append;
        FileOutputStream fo = new FileOutputStream(new File(fileName), append);
        this.out = encoding == null ? new BufferedWriter(new OutputStreamWriter(fo)) : (encoding.trim().length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)fo, encoding)) : new BufferedWriter(new OutputStreamWriter(fo)));
    }

    public void writeLine2(String line) throws IOException {
        if (line != null) {
            if (this.countLines > 0L) {
                this.out.newLine();
            }
            this.out.write(line);
            ++this.countLines;
        }
    }

    public void writeLine(String line) throws IOException {
        if (line != null) {
            this.out.write(line);
            this.out.newLine();
            ++this.countLines;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Program Started ");
        try {
            try {
                CustomFileWriter customFileWriter = new CustomFileWriter("test1", false, null);
                customFileWriter.writeLine("regel1");
                customFileWriter.writeLine("regel2");
                customFileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.debug((Object)("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            log.debug((Object)("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime)));
        }
    }

    public long getCountLines() {
        return this.countLines;
    }

    public void setCountLines(long countLines) {
        this.countLines = countLines;
    }
}

