/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel.common.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class CustomFileReader {
    private static Logger log = Logger.getLogger(CustomFileReader.class);
    String fileName = null;
    BufferedReader in = null;
    protected long countLines = 0L;

    public CustomFileReader(String fileName, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.fileName = fileName;
        FileInputStream fi = new FileInputStream(new File(fileName));
        this.in = encoding == null ? new BufferedReader(new InputStreamReader(fi)) : (encoding.trim().length() > 0 ? new BufferedReader(new InputStreamReader((InputStream)fi, encoding)) : new BufferedReader(new InputStreamReader(fi)));
    }

    public String readNext() throws IOException {
        String line;
        if (this.in == null) {
            this.in = new BufferedReader(new FileReader(this.fileName));
        }
        if ((line = this.in.readLine()) != null) {
            ++this.countLines;
            return line;
        }
        this.close();
        return null;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void printAllRecords() throws IOException {
        String record = null;
        while ((record = this.readNext()) != null) {
            log.debug((Object)record);
        }
        this.close();
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Program Started ");
        try {
            try {
                CustomFileReader customFileReader = new CustomFileReader(args[0], null);
                customFileReader.printAllRecords();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.debug((Object)("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            log.debug((Object)("Program ended time in milliSeconds = " + (System.currentTimeMillis() - startTime)));
        }
    }

    public long getCountLines() {
        return this.countLines;
    }

    public void setCountLines(long countLines) {
        this.countLines = countLines;
    }
}

