/*
 * Decompiled with CFR 0.152.
 */
package com.donkeydevelopment.csvexcel;

import com.dd.gui.components.Frame;
import com.dd.handler.Adapter;
import com.donkeydevelopment.csvexcel.csv.action.Csv2XmlTemplateAction;
import com.donkeydevelopment.csvexcel.csv.action.CsvToXMLTreeAction;
import com.donkeydevelopment.csvexcel.csv.action.CsvToXmlAction;
import com.donkeydevelopment.csvexcel.excel.action.Excel2XmlTemplateAction;
import com.donkeydevelopment.csvexcel.excel.action.ExcelToXMLTreeAction;
import com.donkeydevelopment.csvexcel.excel.action.ExcelToXmlAction;
import com.donkeydevelopment.csvexcel.resources.ResourceLoader;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.apache.log4j.Logger;

public class CsvExcelPlugIn
extends Adapter {
    public static String provider = "DonkeyDevelopment";
    public static final String name = "CsvExcel PlugIn";
    public static final String version = "4.00";
    public static final String versionDate = "2014/07/02";
    private static Logger log = Logger.getLogger(CsvExcelPlugIn.class);

    public CsvExcelPlugIn(Frame frame) {
        super(frame);
    }

    public void appReady() {
        log.debug((Object)"appReady");
        int menuCount = Frame.getInstance().getMenu().getMenuCount();
        int i = 0;
        while (i < menuCount) {
            JMenu menuItem = Frame.getInstance().getMenu().getMenu(i);
            if (menuItem.getText().equals("Translations") || menuItem.getText().equals("Conversion")) {
                menuItem.setText("Conversion");
                menuItem.addSeparator();
                menuItem.add(new Csv2XmlTemplateAction());
                menuItem.add(new Excel2XmlTemplateAction());
                break;
            }
            ++i;
        }
        Frame.getInstance().getMenu().revalidate();
    }

    public AbstractAction[] getImportActions() {
        return new AbstractAction[]{new CsvToXmlAction((JFrame)Frame.getInstance()), new ExcelToXmlAction((JFrame)Frame.getInstance())};
    }

    public AbstractAction[] getExportActions() {
        return new AbstractAction[0];
    }

    public AbstractAction[] getProjectTreeActions(Object object) {
        File file;
        if (object instanceof File && ((file = (File)object).getName().endsWith(".xls") || file.getName().endsWith(".xlsx"))) {
            return new AbstractAction[]{new ExcelToXMLTreeAction((JFrame)Frame.getInstance(), file)};
        }
        if (object instanceof File && ((file = (File)object).getName().endsWith(".csv") || file.getName().endsWith(".txt"))) {
            return new AbstractAction[]{new CsvToXMLTreeAction((JFrame)Frame.getInstance(), file)};
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public String getProvider() {
        return provider;
    }

    public String getVersion() {
        return version;
    }

    public String getVersionDate() {
        return versionDate;
    }

    public URL getMoreInfo() {
        return ResourceLoader.class.getResource("about.html");
    }
}

