/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqservices;

import com.ibm.mqservices.CallStackTrace;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Trace {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mqservices/Trace.java, java, j521, j521-L020126  02/01/25 15:58:03";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5765-B73, 04L17735639-B42, 04L18025765-B74, 04L17885765-B75, 04L18165648-C60, 04L18305694-137 (c) Copyright IBM Corp. 1998, 2002.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String mqTraceExt = ".TRC";
    private static Hashtable indentsTable;
    private static boolean trace;
    private static boolean methodTrace;
    private static boolean inCICS;
    private static boolean wasEnv;
    private static Object traceLock;
    private static PrintWriter trc;
    private static int traceLevel;

    private static final String threadName() {
        if (inCICS) {
            return "unknown";
        }
        return Thread.currentThread().getName();
    }

    private static final Object currentThreadKey() {
        if (inCICS) {
            return new Integer(0);
        }
        return Thread.currentThread();
    }

    private static final void incrementIndents() {
        int n = Trace.getIndentationLevel();
        indentsTable.put(new Integer(Trace.currentThreadKey().hashCode()), new Integer(++n));
    }

    private static final void decrementIndents() {
        int n = Trace.getIndentationLevel();
        if (n > 1) {
            indentsTable.put(new Integer(Trace.currentThreadKey().hashCode()), new Integer(--n));
        } else if (n == 1) {
            indentsTable.remove(new Integer(Trace.currentThreadKey().hashCode()));
        }
    }

    private static final int getIndentationLevel() {
        int n = 0;
        if (indentsTable.containsKey(new Integer(Trace.currentThreadKey().hashCode()))) {
            Integer n2 = (Integer)indentsTable.get(new Integer(Trace.currentThreadKey().hashCode()));
            n = n2;
        }
        return n;
    }

    private static final void traceTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = Trace.getIndentationLevel();
        int n2 = 0;
        while (n2 < n) {
            trc.print("  ");
            ++n2;
        }
        int n3 = gregorianCalendar.get(10);
        int n4 = gregorianCalendar.get(12);
        int n5 = gregorianCalendar.get(13);
        if (n3 < 10) {
            trc.print("0" + n3 + ":");
        } else {
            trc.print(n3 + ":");
        }
        if (n4 < 10) {
            trc.print("0" + n4 + ":");
        } else {
            trc.print(n4 + ":");
        }
        if (n5 < 10) {
            trc.print("0" + n5 + ":");
        } else {
            trc.print(n5 + " ");
        }
        trc.print("[" + date.getTime() + "] ");
    }

    public static void printHexBytes(PrintWriter printWriter, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            int n4;
            int n5 = Math.min(n + 16, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n6 = n;
            while (n6 < n5) {
                n4 = byArray[n6];
                n4 = (n4 + 256) % 256;
                n3 = n4 / 16;
                n2 = n4 % 16;
                stringBuffer.append(n3 < 10 ? (char)(48 + n3) : (char)(97 + n3 - 10));
                stringBuffer.append(n2 < 10 ? (char)(48 + n2) : (char)(97 + n2 - 10));
                if (n6 % 2 == 1) {
                    stringBuffer.append(' ');
                }
                if (n4 >= 32 && n4 <= 126) {
                    stringBuffer2.append((char)n4);
                } else {
                    stringBuffer2.append('.');
                }
                ++n6;
            }
            n4 = 16 - (n5 - n);
            n3 = (n4 * 5 + n4 % 2) / 2;
            n3 += 3;
            n2 = 0;
            while (n2 < n3) {
                stringBuffer.append(' ');
                ++n2;
            }
            String string = "0000" + Integer.toHexString(n);
            string = string.substring(string.length() - 4);
            printWriter.print(string);
            printWriter.print(":  ");
            printWriter.print(stringBuffer.toString());
            printWriter.println(stringBuffer2.toString());
            n += 16;
        }
    }

    public static final void notInCICS() {
        inCICS = false;
    }

    public static final void dumpCallStack() {
        if (!trace) {
            return;
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                CallStackTrace callStackTrace = new CallStackTrace();
                try {
                    throw callStackTrace;
                }
                catch (CallStackTrace callStackTrace2) {
                    Trace.traceTime();
                    trc.println("Thread: " + Trace.threadName() + " Stack Trace Follows: (stack trace requires java_g or appletviewer_g)");
                    callStackTrace.printStackTrace(trc);
                }
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void entry(Object object, String string) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.entry((Object)object, (String)string);
            return;
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " ==> " + string + "() entry");
                Trace.incrementIndents();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void entry(String string, String string2) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.entry((String)string, (String)string2);
            return;
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " ==> " + string + "::" + string2 + "() entry");
                Trace.incrementIndents();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void exit(Object object, String string) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.exit((Object)object, (String)string);
            return;
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                Trace.decrementIndents();
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " <== " + string + "() exit");
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void exit(String string, String string2) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.exit((String)string, (String)string2);
            return;
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                Trace.decrementIndents();
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " <== " + string + "::" + string2 + "() exit");
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void trace(Object object, String string) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.trace((Object)object, (String)string);
            return;
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " " + string);
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void trace(String string, String string2) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.trace((Object)string, (String)string2);
            return;
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace) {
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " Class: " + string + " " + string2);
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void trace(int n, Object object, String string) {
        if (traceLevel >= n) {
            Trace.trace(object, string);
        }
    }

    public static final void trace(int n, String string, String string2) {
        if (traceLevel >= n) {
            Trace.trace(string, string2);
        }
    }

    public static final void dataTrace(int n, Object object, byte[] byArray) {
        if (!trace) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.dataTrace((int)n, (Object)object, (byte[])byArray);
            return;
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (trace && traceLevel >= n) {
                Trace.traceTime();
                trc.print("Thread: " + Trace.threadName() + ", ");
                if (object != null) {
                    trc.print("Object: " + object);
                }
                trc.println(" Data trace, " + byArray.length + " bytes of data follow: \n");
                Trace.printHexBytes(trc, byArray);
                trc.println();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void turnTracingOn() {
        Object object = traceLock;
        synchronized (object) {
            trace = true;
            indentsTable = new Hashtable();
        }
    }

    public static final void turnTracingOff() {
        Object object = traceLock;
        synchronized (object) {
            trace = false;
            if (indentsTable != null) {
                indentsTable.clear();
            }
            if (trc != null) {
                try {
                    trc.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static final void turnMethodTracingOn() {
        Object object = traceLock;
        synchronized (object) {
            Trace.traceMethodCalls(true);
            methodTrace = true;
        }
    }

    public static final void turnMethodTracingOff() {
        Object object = traceLock;
        synchronized (object) {
            Trace.traceMethodCalls(false);
            methodTrace = false;
        }
    }

    private static final void traceMethodCalls(boolean bl) {
        if (!inCICS) {
            Runtime.getRuntime().traceMethodCalls(bl);
        }
    }

    public static final void setTraceStream(FileWriter fileWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (fileWriter != null) {
                trc = new PrintWriter(fileWriter);
            }
        }
    }

    public static final void setTraceStream(PrintWriter printWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (printWriter != null) {
                trc = printWriter;
            }
        }
    }

    public static final void setTraceLevel(int n) {
        Object object = traceLock;
        synchronized (object) {
            traceLevel = n;
        }
    }

    public static boolean isOn() {
        return trace;
    }

    public static void setWasEnv(boolean bl) {
        wasEnv = bl;
    }

    static {
        trace = false;
        methodTrace = false;
        inCICS = true;
        wasEnv = false;
        traceLock = new Object();
        trc = new PrintWriter(System.err, true);
        traceLevel = 1;
    }
}

