/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.server;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.Pint;
import com.ibm.mq.XAtoJTA;
import com.ibm.mq.server.MQThread;
import com.ibm.mq.server.MQXAi;
import com.ibm.mqservices.Trace;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class MQSESSION
extends com.ibm.mq.MQSESSION
implements MQXAVerbs {
    private static final String sccsid = "common/javabase/com/ibm/mq/server/MQSESSION.java, java, j521, j521-L020628 02/06/27 13:52:59 @(#) 1.44.1.4";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5639-B43, 5695-137 (c) Copyright IBM Corp. 1999, 2001       All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSION";
    private boolean threading = true;
    private MQThread connThread = null;
    private boolean inUseByQM = false;
    private boolean inUseByXA = false;
    private Exception xaInvalidStateException = null;
    private Object mqiLock = new Object();
    boolean spiSuppDeferred = false;
    static boolean deferredLibLoaded = false;
    private static final String DEFR_LIBNAME = "mqjbdf";
    private static final String DEFR_VERSION = "01";

    static void loadDefMsgLibrary() {
        if (Trace.isOn()) {
            Trace.entry(clsName, "loadDefMsgLibrary");
        }
        if (!deferredLibLoaded) {
            final String string = com.ibm.mq.MQSESSION.getLibraryPath() + DEFR_LIBNAME + DEFR_VERSION;
            if (Trace.isOn()) {
                Trace.trace(clsName, "Attempting to load auxiliary library " + string);
            }
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    com.ibm.mq.MQSESSION.loadLib(string);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
            deferredLibLoaded = true;
        }
        if (Trace.isOn()) {
            Trace.exit(clsName, "loadDefMsgLibrary");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void XAREGISTER(XAConnection xAConnection) throws MQException, SQLException, XAException {
        Exception exception = null;
        Trace.entry(this, "XAREGISTER");
        try {
            this.xaInvalidStateException = MQXAi.getInvalidStateException();
            if (this.threading) {
                if (this.connThread == null) throw (XAException)this.xaInvalidStateException;
                exception = this.connThread.XAREGISTER(xAConnection);
            } else {
                Object object = this.mqiLock;
                synchronized (object) {
                    exception = MQSESSION._XAREGISTER(xAConnection);
                }
            }
            if (exception != null) {
                Trace.trace(this, "attempting to cast returned exception: " + exception);
                if (exception instanceof MQException) {
                    throw (MQException)exception;
                }
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (exception instanceof XAException) {
                    throw (XAException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                Trace.trace(this, "internal error: XAREGISTER method wasn't coded to cope with exception: " + exception);
                throw new MQException(2, 2195, this);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XAREGISTER");
            throw throwable;
        }
        Trace.exit(this, "XAREGISTER");
    }

    protected static Exception _XAREGISTER(XAConnection xAConnection) {
        try {
            XAtoJTA.registerResource(xAConnection);
        }
        catch (Exception exception) {
            return exception;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deregisterResource(XAConnection xAConnection) throws Exception {
        Exception exception = null;
        Trace.entry(this, "deregisterResource");
        try {
            try {
                this.xaInvalidStateException = MQXAi.getInvalidStateException();
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    exception = this.connThread.deregisterResource(xAConnection);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        exception = MQSESSION._deregisterResource(xAConnection);
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                Object var6_6 = null;
            }
            catch (MQException mQException) {
                Trace.trace(this, "throwing " + mQException);
                throw mQException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.exit(this, "deregisterResource");
            throw throwable;
        }
        Trace.exit(this, "deregisterResource");
    }

    protected static Exception _deregisterResource(XAConnection xAConnection) {
        Exception exception = null;
        try {
            XAtoJTA.deregisterResource(xAConnection);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        return exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XAOPEN(String string, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XAOPEN");
        try {
            try {
                this.xaInvalidStateException = MQXAi.getInvalidStateException();
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XAOPEN(string, n, n2);
                    this.inUseByXA = true;
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XAOPEN(string, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XAOPEN");
            throw throwable;
        }
        Trace.exit(this, "XAOPEN");
        return n3;
    }

    protected static int _XAOPEN(String string, int n, int n2) {
        return MQXAi.xa_open(string, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XACLOSE(String string, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XACLOSE");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XACLOSE(string, n, n2);
                    if (n3 == 0) {
                        this.inUseByXA = false;
                        if (!this.inUseByQM) {
                            Trace.trace(this, "XACLOSE stopping worker thread");
                            this.connThread.STOPTHREAD();
                            this.connThread = null;
                        }
                    }
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XACLOSE(string, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XACLOSE");
            throw throwable;
        }
        Trace.exit(this, "XACLOSE");
        return n3;
    }

    protected static int _XACLOSE(String string, int n, int n2) {
        return MQXAi.xa_close(string, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XASTART(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XASTART");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XASTART(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XASTART(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XASTART");
            throw throwable;
        }
        Trace.exit(this, "XASTART");
        return n3;
    }

    protected static int _XASTART(Xid xid, int n, int n2) {
        return MQXAi.xa_start(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XAEND(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XAEND");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XAEND(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XAEND(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XAEND");
            throw throwable;
        }
        Trace.exit(this, "XAEND");
        return n3;
    }

    protected static int _XAEND(Xid xid, int n, int n2) {
        return MQXAi.xa_end(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XAPREPARE(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XAPREPARE");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XAPREPARE(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XAPREPARE(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XAPREPARE");
            throw throwable;
        }
        Trace.exit(this, "XAPREPARE");
        return n3;
    }

    protected static int _XAPREPARE(Xid xid, int n, int n2) {
        return MQXAi.xa_prepare(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XACOMMIT(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XACOMMIT");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XACOMMIT(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XACOMMIT(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XACOMMIT");
            throw throwable;
        }
        Trace.exit(this, "XACOMMIT");
        return n3;
    }

    protected static int _XACOMMIT(Xid xid, int n, int n2) {
        return MQXAi.xa_commit(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XAROLLBACK(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XAROLLBACK");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XAROLLBACK(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XAROLLBACK(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XAROLLBACK");
            throw throwable;
        }
        Trace.exit(this, "XAROLLBACK");
        return n3;
    }

    protected static int _XAROLLBACK(Xid xid, int n, int n2) {
        return MQXAi.xa_rollback(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XAFORGET(Xid xid, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XAFORGET");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XAFORGET(xid, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XAFORGET(xid, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XAFORGET");
            throw throwable;
        }
        Trace.exit(this, "XAFORGET");
        return n3;
    }

    protected static int _XAFORGET(Xid xid, int n, int n2) {
        return MQXAi.xa_forget(xid, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int XARECOVER(Xid[] xidArray, int n, int n2) throws Exception {
        int n3 = -1;
        Trace.entry(this, "XARECOVER");
        try {
            try {
                if (this.threading) {
                    if (this.connThread == null) throw this.xaInvalidStateException;
                    n3 = this.connThread.XARECOVER(xidArray, n, n2);
                } else {
                    Object object = this.mqiLock;
                    synchronized (object) {
                        n3 = MQSESSION._XARECOVER(xidArray, n, n2);
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "XARECOVER");
            throw throwable;
        }
        Trace.exit(this, "XARECOVER");
        return n3;
    }

    protected static int _XARECOVER(Xid[] xidArray, int n, int n2) {
        return MQXAi.xa_recover(xidArray, n, n2);
    }

    public void MQBACK(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQBACK");
            Trace.trace(2, this, "Connection handle = " + n);
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQBACK(n, pint, pint2);
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQBACK(n, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQBACK");
        }
    }

    public void MQBEGIN(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQBEGIN");
            Trace.trace(2, this, "Conn Handle = " + n);
        }
        int n2 = 0;
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQBEGIN(n, n2, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQBEGINWrapper(n, n2, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQBEGIN");
        }
    }

    static void _MQBEGINWrapper(int n, int n2, Pint pint, Pint pint2) {
        XAtoJTA.resetRC();
        MQSESSION._MQBEGIN(n, n2, pint, pint2);
        int n3 = XAtoJTA.getRC();
        if (n3 != 0) {
            Trace.trace(clsName, "overriding reason code from " + pint2.x + " to " + n3);
            pint2.x = n3;
        }
    }

    public void MQCONNX(String string, int n, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCONNX");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
        }
        if (this.threading) {
            this.connThread = new MQThread();
            if (this.connThread != null) {
                this.connThread.MQCONNX(string, n, pint, pint2, pint3);
                if (pint2.x != 0 && pint2.x != 1) {
                    this.connThread.STOPTHREAD();
                }
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2195;
            }
            this.inUseByQM = true;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQCONNX(string, n, pint, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "MQCONNX returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCONNX");
        }
    }

    public void MQCLOSE(int n, Pint pint, int n2, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCLOSE");
            Trace.trace(2, this, "Conn Handle = " + n + " Object Handle = " + pint.x);
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQCLOSE(n, pint, n2, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQCLOSE(n, pint, n2, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCLOSE");
        }
    }

    public void MQCMIT(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCMIT");
            Trace.trace(2, this, "Handle = " + n);
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQCMIT(n, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQCMIT(n, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQCMIT");
        }
    }

    public void MQCONN(String string, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCONN");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
        }
        if (this.threading) {
            this.connThread = new MQThread();
            if (this.connThread != null) {
                this.connThread.MQCONN(string, pint, pint2, pint3);
                if (pint2.x != 0 && pint2.x != 1) {
                    this.connThread.STOPTHREAD();
                }
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2195;
            }
            this.inUseByQM = true;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQCONN(string, pint, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "MQCONN returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCONN");
        }
    }

    public void MQDISC(Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQDISC");
            Trace.trace(1, this, "Handle = " + pint.x);
        }
        if (this.threading) {
            if (this.connThread != null) {
                int n = pint.x;
                this.connThread.MQDISC(pint, pint2, pint3);
                if (pint2.x == 0) {
                    this.inUseByQM = false;
                    if (!this.inUseByXA) {
                        Trace.trace(this, "MQDISC stopping worker thread");
                        this.connThread.STOPTHREAD();
                        this.connThread = null;
                    }
                }
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQDISC(pint, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQDISC");
        }
    }

    public void MQGET(int n, int n2, MQMD mQMD, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQGET");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMD == null) {
            pint2.x = 2;
            pint3.x = 2026;
            Trace.exit(this, "MQGET (null message descriptor)");
            return;
        }
        if (mQGetMessageOptions == null) {
            pint2.x = 2;
            pint3.x = 2186;
            Trace.exit(this, "MQGET (null get message options)");
            return;
        }
        if (byArray == null || byArray.length == 0) {
            pint2.x = 2;
            pint3.x = 2004;
            Trace.exit(this, "MQGET (null or zero length message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint2.x = 2;
            pint3.x = 2005;
            Trace.exit(this, "MQGET (buffer too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQGET(n, n2, mQMD, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQGET(n, n2, mQMD, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET");
        }
    }

    public void MQGET(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQGET (MQMsg2)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMsg2 == null) {
            pint2.x = 2;
            pint3.x = 2026;
            Trace.exit(this, "MQGET (MQMsg2) (null message descriptor)");
            return;
        }
        if (mQGetMessageOptions == null) {
            pint2.x = 2;
            pint3.x = 2186;
            Trace.exit(this, "MQGET (MQMsg2) (null get message options)");
            return;
        }
        if (byArray == null || byArray.length == 0) {
            pint2.x = 2;
            pint3.x = 2004;
            Trace.exit(this, "MQGET (MQMsg2) (null or zero length message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint2.x = 2;
            pint3.x = 2005;
            Trace.exit(this, "MQGET (MQMsg2) (buffer too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQGETMSG2(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET (MQMsg2)");
        }
    }

    public void MQINQ(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQINQ");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (nArray == null) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(this, "MQINQ (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(this, "MQINQ (selector array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQINQ (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQINQ (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQINQ (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQINQ (characters array too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQINQ(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQINQ(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQINQ");
        }
    }

    public String MQINQ(int n, int n2, int n3, int n4, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQINQ(String)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        String string = null;
        if (this.threading) {
            if (this.connThread != null) {
                string = this.connThread.MQINQ(n, n2, n3, n4, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                string = MQSESSION._MQINQ(n, n2, n3, n4, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQINQ(String)");
        }
        return string;
    }

    public void MQOPEN(int n, MQOD mQOD, int n2, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQOPEN");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (mQOD == null) {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2044;
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQOPEN(n, mQOD, n2, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQOPEN(n, mQOD, n2, pint, pint2, pint3);
            }
        }
        mQOD.updateDistributionListItems();
        if (Trace.isOn()) {
            Trace.trace(2, this, "MQOPEN returning hObj " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
        }
        Trace.exit(this, "MQOPEN");
    }

    public void MQPUT(int n, int n2, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQPUT");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT (buffer too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQPUT(n, n2, mQMD, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQPUT(n, n2, mQMD, mQPutMessageOptions, n3, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        }
        mQPutMessageOptions.updateDistributionListItems();
        Trace.exit(this, "MQPUT");
    }

    public void MQPUT(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQPUT (MQMsg2)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT (MQMsg2) (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT (MQMsg2) (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT (MQMsg2) (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT (MQMsg2) (buffer too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQPUT(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQPUTMSG2(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        }
        mQPutMessageOptions.updateDistributionListItems();
        Trace.exit(this, "MQPUT (MQMsg2)");
    }

    public void MQPUT1(int n, MQOD mQOD, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQPUT1");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT1 (buffer was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT1 (buffer too small)");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(this, "MQPUT1 (obj descriptor was null)");
            return;
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT1 (msg descriptor was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT1 (put msg options was null)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQPUT1(n, mQOD, mQMD, mQPutMessageOptions, n2, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQPUT1(n, mQOD, mQMD, mQPutMessageOptions, n2, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        }
        mQPutMessageOptions.updateDistributionListItems();
        Trace.exit(this, "MQPUT1");
    }

    public void MQPUT1(int n, MQOD mQOD, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQPUT1 - MQMsg2 version");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT1 - MQMsg2 (buffer was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT1 - MQMsg2 (buffer too small)");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(this, "MQPUT1 - MQMsg2 (obj descriptor was null)");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT1 - MQMsg2 (msg descriptor was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT1 - MQMsg2 (put msg options was null)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQPUT1(n, mQOD, mQMsg2, mQPutMessageOptions, n2, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQPUT1MSG2(n, mQOD, mQMsg2, mQPutMessageOptions, n2, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        }
        mQPutMessageOptions.updateDistributionListItems();
        Trace.exit(this, "MQPUT1 - MQMsg2");
    }

    public void MQSET(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQSET");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (nArray == null || nArray.length == 0) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(this, "MQSET (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(this, "MQSET (selectors array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQSET (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQSET (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQSET (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQSET (character attributes array too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQSET(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQSET(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQSET");
        }
    }

    public void MQSET(int n, int n2, int n3, String string, int n4, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQSET (String)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.MQSET(n, n2, n3, string, n4, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQSET(n, n2, n3, string, n4, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQSET(String)");
        }
    }

    public void honourRRSInternal(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "honourRRSInternal");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.honourRRSInternal(n, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._honourRRSInternal(n, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "honourRRSInternal");
        }
    }

    public void spiConnect(String string, int n, Pint pint, Pint pint2, Pint pint3) {
        int n2 = 0;
        if (Trace.isOn()) {
            Trace.entry(this, "spiConnect");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
        }
        if (this.threading) {
            this.connThread = new MQThread();
            if (this.connThread != null) {
                n2 = this.connThread.spiConnect(string, n, pint, pint2, pint3);
                if (pint2.x != 0 && pint2.x != 1) {
                    this.connThread.STOPTHREAD();
                }
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2195;
            }
            this.inUseByQM = true;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n2 = MQSESSION._spiConnect(string, n, pint, pint2, pint3);
            }
        }
        boolean bl = this.spiSuppDeferred = (n2 & 1) == 1;
        if (pint2.x == 0 && this.spiSuppDeferred) {
            MQSESSION.loadDefMsgLibrary();
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "spiConnect returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "spiConnect");
        }
    }

    public boolean spiSupportsDeferred() {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiSupportsDeferred");
            Trace.exit(clsName, "spiSupportsDeferred");
        }
        return this.spiSuppDeferred;
    }

    public void spiDefPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "spiDefPut");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefPut (Deferred messages not supported)");
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "spiDefPut (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "spiDefPut (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "spiDefPut (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "spiDefPut (buffer too small)");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.spiDefPut(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._spiDefPut(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        }
        mQPutMessageOptions.updateDistributionListItems();
        Trace.exit(this, "spiDefPut");
    }

    public void spiDefActivate(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "spiDefActivate");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate (Deferred messages not supported)");
        }
        if (byArray == null || byArray.length != 24) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate - Unexpected error: bad msg id");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.spiDefActivate(n, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._spiDefActivate(n, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiDefActivate");
        }
    }

    public void spiDefCancel(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "spiDefCancel");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate (Deferred messages not supported)");
        }
        if (byArray == null || byArray.length != 24) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefCancel - Unexpected error: bad msg id");
            return;
        }
        if (this.threading) {
            if (this.connThread != null) {
                this.connThread.spiDefCancel(n, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._spiDefCancel(n, byArray, pint, pint2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiDefCancel");
        }
    }

    static native void _MQBACK(int var0, Pint var1, Pint var2);

    static native void _MQCLOSE(int var0, Pint var1, int var2, Pint var3, Pint var4);

    static native void _MQCMIT(int var0, Pint var1, Pint var2);

    static native void _MQDISC(Pint var0, Pint var1, Pint var2);

    static native void _MQGET(int var0, int var1, MQMD var2, MQGetMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7, Pint var8);

    static native void _MQGETMSG2(int var0, int var1, MQMsg2 var2, MQGetMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7, Pint var8);

    static native void _MQINQ(int var0, int var1, int var2, int[] var3, int var4, int[] var5, int var6, byte[] var7, Pint var8, Pint var9);

    static native String _MQINQ(int var0, int var1, int var2, int var3, Pint var4, Pint var5);

    static native void _MQOPEN(int var0, MQOD var1, int var2, Pint var3, Pint var4, Pint var5);

    static native void _MQPUT(int var0, int var1, MQMD var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7);

    static native void _MQPUTMSG2(int var0, int var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7);

    static native void _MQPUT1(int var0, MQOD var1, MQMD var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7);

    static native void _MQPUT1MSG2(int var0, MQOD var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7);

    static native void _MQSET(int var0, int var1, int var2, int[] var3, int var4, int[] var5, int var6, byte[] var7, Pint var8, Pint var9);

    static native void _MQSET(int var0, int var1, int var2, String var3, int var4, Pint var5, Pint var6);

    static native void _MQCONNX(String var0, int var1, Pint var2, Pint var3, Pint var4);

    static native void _MQBEGIN(int var0, int var1, Pint var2, Pint var3);

    static synchronized native void _MQCONN(String var0, Pint var1, Pint var2, Pint var3);

    private static native boolean init_conversion();

    static native void _honourRRSInternal(int var0, Pint var1, Pint var2);

    static native int _spiConnect(String var0, int var1, Pint var2, Pint var3, Pint var4);

    static native void _spiDefPut(int var0, int var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7);

    static native void _spiDefActivate(int var0, byte[] var1, Pint var2, Pint var3);

    static native void _spiDefCancel(int var0, byte[] var1, Pint var2, Pint var3);

    public final boolean supportsV2Structures(int n) {
        if (Trace.isOn()) {
            Trace.entry(this, "supportsV2Structures");
            Trace.exit(this, "supportsV2Structures");
        }
        return true;
    }

    protected void setThreadAccess(String string) throws MQException {
        Trace.entry(this, "setThreadAccess");
        if (string == null) {
            if (com.ibm.mq.MQSESSION.getLibraryName().equals("wmqjcics")) {
                this.threading = false;
                Trace.trace(2, this, "Thread switch disabled (in CICS)");
            } else if (com.ibm.mq.MQSESSION.getLibraryName().equals("wmqjrrs")) {
                this.threading = false;
                Trace.trace(2, this, "Thread switch disabled (using RRS adapter)");
            } else {
                this.threading = true;
                Trace.trace(2, this, "Thread switch enabled");
            }
        } else if (string.equals("MULTI_THREAD")) {
            if (com.ibm.mq.MQSESSION.getLibraryName().equals("wmqjcics")) {
                Trace.trace(2, this, "Multi-threaded requested under CICS");
                Trace.exit(this, "setThreadAccess (via exception)");
                throw new MQException(2, 2012, this);
            }
            if (com.ibm.mq.MQSESSION.getLibraryName().equals("wmqjrrs")) {
                this.threading = false;
                Trace.trace(2, this, "MULTI_THREAD ignored - using RRS adapter");
            } else {
                this.threading = true;
                Trace.trace(2, this, "Thread switch enabled");
            }
        } else if (string.equals("SINGLE_THREAD")) {
            this.threading = false;
            Trace.trace(2, this, "Thread switch disabled");
        } else {
            Trace.trace(2, this, "Unknown thread access mode specified");
            Trace.exit(this, "setThreadAccess (via exception)");
            throw new MQException(2, 2012, this);
        }
        Trace.exit(this, "setThreadAccess");
    }

    static /* synthetic */ String access$001() {
        return com.ibm.mq.MQSESSION.getLibraryName();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                com.ibm.mq.MQSESSION.loadLib(com.ibm.mq.MQSESSION.getLibraryPath() + MQSESSION.access$001());
                return null;
            }
        });
        if (!MQSESSION.init_conversion()) {
            Trace.trace(1, clsName, "Failed to setup conversion");
        }
    }
}

