/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQXid;
import com.ibm.mqservices.Trace;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAtoJTA
implements ConnectionEventListener {
    private static final String sccsid = "common/javabase/com/ibm/mq/XAtoJTA.java, java, j521, j521-L020327 02/03/26 14:07:48 @(#) 1.8.3.2";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String clsName = "XAtoJTA";
    public static final int TMNOFLAGS = 0;
    public static final int XA_NOMIGRATE = 9;
    public static final int XA_HEURHAZ = 8;
    public static final int XA_HEURCOM = 7;
    public static final int XA_HEURRB = 6;
    public static final int XA_HEURMIX = 5;
    public static final int XA_RETRY = 4;
    public static final int XA_RDONLY = 3;
    public static final int XA_OK = 0;
    public static final int XAER_ASYNC = -2;
    public static final int XAER_RMERR = -3;
    private static Hashtable instancesByThread = new Hashtable(10);
    private static boolean useOra816;
    private Hashtable resourcesByRmid = new Hashtable(10);
    private Hashtable resourcesByConn = new Hashtable(10);
    private Hashtable spareRmids = new Hashtable();
    private Vector spareXAConns = new Stack();
    private Vector dirtyResources = new Vector();
    private int openCount = 0;
    private int openedResources = 0;
    private boolean inTransaction = false;
    private int beginRC;
    static /* synthetic */ Class array$B;

    private XAtoJTA() {
        try {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
            instancesByThread.put(Thread.currentThread(), this);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Trace.exit(this, "constructor");
            throw throwable;
        }
        Trace.exit(this, "constructor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            try {
                Trace.entry(this, "connectionClosed");
                Trace.trace(this, "event is: " + connectionEvent);
                if (useOra816) {
                    Trace.trace(this, "ignoring event because useOra816 flag is set");
                }
                XAConnection xAConnection = (XAConnection)connectionEvent.getSource();
                this._deregisterResource(xAConnection);
                xAConnection.close();
            }
            catch (Exception exception) {
                Trace.trace(this, "ignoring " + exception);
                Object var4_5 = null;
                Trace.exit(this, "connectionClosed");
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Trace.exit(this, "connectionClosed");
            throw throwable;
        }
        Trace.exit(this, "connectionClosed");
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        Trace.trace(this, "connectionErrorOccurred: " + connectionEvent);
    }

    private static XAtoJTA getInstance() {
        XAtoJTA xAtoJTA;
        try {
            Trace.entry(clsName, "getInstance");
            XAtoJTA xAtoJTA2 = (XAtoJTA)instancesByThread.get(Thread.currentThread());
            if (xAtoJTA2 == null) {
                xAtoJTA2 = new XAtoJTA();
            }
            xAtoJTA = xAtoJTA2;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(clsName, "getInstance");
            throw throwable;
        }
        Trace.exit(clsName, "getInstance");
        return xAtoJTA;
    }

    private void close() {
        try {
            XAConnection xAConnection;
            Trace.entry(this, "close");
            Enumeration<Object> enumeration = this.spareXAConns.elements();
            while (enumeration.hasMoreElements()) {
                xAConnection = (XAConnection)enumeration.nextElement();
                try {
                    xAConnection.removeConnectionEventListener(this);
                }
                catch (Exception exception) {
                    Trace.trace(this, "error whilst deregistering as connection event listener: " + exception);
                }
                try {
                    xAConnection.close();
                }
                catch (SQLException sQLException) {
                    Trace.trace(this, "trying to close JDBC connection, ignoring " + sQLException);
                }
            }
            enumeration = this.resourcesByConn.keys();
            while (enumeration.hasMoreElements()) {
                xAConnection = (XAConnection)enumeration.nextElement();
                try {
                    xAConnection.close();
                }
                catch (SQLException sQLException) {
                    Trace.trace(this, "trying to close JDBC connection, ignoring " + sQLException);
                }
            }
            this.spareRmids.clear();
            this.spareXAConns.removeAllElements();
            this.dirtyResources.removeAllElements();
            this.resourcesByRmid.clear();
            this.resourcesByConn.clear();
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    static Connection helpGetConnection(XADataSource xADataSource, String string, String string2, MQSESSION mQSESSION) throws SQLException, MQException, Exception {
        Connection connection;
        try {
            Trace.entry(clsName, "helpGetConnection");
            XAConnection xAConnection = string != null ? xADataSource.getXAConnection(string, string2) : xADataSource.getXAConnection();
            mQSESSION.XAREGISTER(xAConnection);
            connection = xAConnection.getConnection();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Trace.exit(clsName, "helpGetConnection");
            throw throwable;
        }
        Trace.exit(clsName, "helpGetConnection");
        return connection;
    }

    public static void registerResource(XAConnection xAConnection) throws MQException, SQLException, XAException {
        try {
            try {
                Trace.entry(clsName, "registerResource");
                XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                xAtoJTA._registerResource(xAConnection);
            }
            catch (MQException mQException) {
                Trace.trace(clsName, "throwing " + mQException);
                throw mQException;
            }
            catch (SQLException sQLException) {
                Trace.trace(clsName, "throwing " + sQLException);
                throw sQLException;
            }
            catch (XAException xAException) {
                Trace.trace(clsName, "throwing " + xAException);
                throw xAException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Trace.exit(clsName, "registerResource");
            throw throwable;
        }
        Trace.exit(clsName, "registerResource");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deregisterResource(XAConnection xAConnection) throws XAException {
        try {
            try {
                Trace.entry(clsName, "deregisterResource");
                XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                xAtoJTA._deregisterResource(xAConnection);
                Object var3_3 = null;
            }
            catch (XAException xAException) {
                Trace.trace(clsName, "throwing " + xAException);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Trace.exit(clsName, "deregisterResource");
            throw throwable;
        }
        Trace.exit(clsName, "deregisterResource");
    }

    public static void resetRC() {
        try {
            Trace.entry(clsName, "resetRC");
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            xAtoJTA._resetRC();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Trace.exit(clsName, "resetRC");
            throw throwable;
        }
        Trace.exit(clsName, "resetRC");
    }

    public static int getRC() {
        int n;
        try {
            Trace.entry(clsName, "getRC");
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            n = xAtoJTA._getRC();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(clsName, "getRC");
            throw throwable;
        }
        Trace.exit(clsName, "getRC");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized int XAOpen(String string, int n, int n2, int n3) {
        int n4;
        block4: {
            int n5;
            block3: {
                try {
                    Trace.entry(clsName, "XAOpen");
                    Trace.trace(clsName, "open string '" + string + "', rmid " + n);
                    XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                    if (xAtoJTA == null) {
                        n5 = -3;
                        Object var8_6 = null;
                        break block3;
                    }
                    n4 = xAtoJTA.xa_open(n, n2);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    Trace.exit(clsName, "XAOpen");
                    throw throwable;
                }
            }
            Trace.exit(clsName, "XAOpen");
            return n5;
        }
        Object var8_7 = null;
        Trace.exit(clsName, "XAOpen");
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized int XAClose(String string, int n, int n2) {
        int n3;
        block4: {
            int n4;
            block3: {
                try {
                    Trace.entry(clsName, "XAClose");
                    Trace.trace(clsName, "close string '" + string + "', rmid " + n);
                    XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                    if (xAtoJTA == null) {
                        n4 = -3;
                        Object var7_5 = null;
                        break block3;
                    }
                    n3 = xAtoJTA.xa_close(n, n2);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    Trace.exit(clsName, "XAClose");
                    throw throwable;
                }
            }
            Trace.exit(clsName, "XAClose");
            return n4;
        }
        Object var7_6 = null;
        Trace.exit(clsName, "XAClose");
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized int XAStart(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        block4: {
            int n5;
            block3: {
                try {
                    Trace.entry(clsName, "XAStart");
                    XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                    if (xAtoJTA == null) {
                        n5 = -3;
                        Object var9_7 = null;
                        break block3;
                    }
                    n4 = xAtoJTA.xa_start(byArray, byArray2, n, n2, n3);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    Trace.exit(clsName, "XAStart");
                    throw throwable;
                }
            }
            Trace.exit(clsName, "XAStart");
            return n5;
        }
        Object var9_8 = null;
        Trace.exit(clsName, "XAStart");
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int XAEnd(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        block4: {
            int n5;
            block3: {
                try {
                    Trace.entry(clsName, "XAEnd");
                    XAtoJTA xAtoJTA = XAtoJTA.getInstance();
                    if (xAtoJTA == null) {
                        n5 = -3;
                        Object var9_7 = null;
                        break block3;
                    }
                    n4 = xAtoJTA.xa_end(byArray, byArray2, n, n2, n3);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    Trace.exit(clsName, "XAEnd");
                    throw throwable;
                }
            }
            Trace.exit(clsName, "XAEnd");
            return n5;
        }
        Object var9_8 = null;
        Trace.exit(clsName, "XAEnd");
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_open(int n, int n2) {
        Trace.entry(this, "xa_open");
        int n3 = -3;
        try {
            try {
                ++this.openCount;
                Trace.trace(this, "open count is now " + this.openCount);
                Integer n4 = new Integer(n);
                RR rR = new RR();
                rR.rmId = n4;
                this.spareRmids.put(n4, rR);
                n3 = 0;
            }
            catch (Exception exception) {
                Trace.trace(this, "failed with " + exception);
                Object var7_8 = null;
                Trace.exit(this, "xa_open");
                return n3;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Trace.exit(this, "xa_open");
            throw throwable;
        }
        Trace.exit(this, "xa_open");
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_close(int n, int n2) {
        int n3 = -3;
        try {
            try {
                Trace.entry(this, "xa_close");
                Integer n4 = new Integer(n);
                this.close();
                --this.openCount;
                n3 = 0;
            }
            catch (Exception exception) {
                Trace.trace(this, "caught " + exception);
                Object var6_7 = null;
                Trace.exit(this, "xa_close");
                return n3;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Trace.exit(this, "xa_close");
            throw throwable;
        }
        Trace.exit(this, "xa_close");
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_start(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        block22: {
            int n5;
            block21: {
                int n6;
                block20: {
                    int n7;
                    block19: {
                        int n8;
                        block18: {
                            int n9;
                            block17: {
                                n4 = -3;
                                try {
                                    try {
                                        Xid xid;
                                        Object object;
                                        Trace.entry(this, "xa_start");
                                        Trace.trace(this, "XAStart: rmid is " + n2);
                                        if (this.beginRC == 2372) {
                                            Trace.trace(this, "resetting beginRc to MQRC_NONE");
                                            this.beginRC = 0;
                                        }
                                        if (!this.inTransaction && this.spareXAConns.size() > this.spareRmids.size()) {
                                            Trace.trace(this, "not enough rmids for registered connections");
                                            this.beginRC = 2372;
                                            n9 = -3;
                                            Object var15_11 = null;
                                            break block17;
                                        }
                                        if (n3 != 0) {
                                            Trace.trace(this, "unexpected value of flags: " + n3 + ", returning RMERR");
                                            n8 = -3;
                                            break block18;
                                        }
                                        this.inTransaction = true;
                                        Integer n10 = new Integer(n2);
                                        if (useOra816) {
                                            try {
                                                Trace.trace(this, "creating oracle xid");
                                                object = Class.forName("oracle.jdbc.xa.OracleXid");
                                                Class[] classArray = new Class[]{Integer.TYPE, array$B == null ? (array$B = XAtoJTA.class$("[B")) : array$B, array$B == null ? (array$B = XAtoJTA.class$("[B")) : array$B};
                                                Constructor constructor = ((Class)object).getConstructor(classArray);
                                                Object[] objectArray = new Object[]{new Integer(n), byArray, byArray2};
                                                xid = (Xid)constructor.newInstance(objectArray);
                                            }
                                            catch (Exception exception) {
                                                Trace.trace(this, "Failed to create oracle specific xid: " + exception);
                                                int n11 = -3;
                                                Object var15_13 = null;
                                                Trace.exit(this, "xa_start");
                                                return n11;
                                            }
                                        } else {
                                            Trace.trace(this, "creating a standard xid");
                                            xid = new MQXid(n, byArray, byArray2);
                                        }
                                        RR rR = (RR)this.resourcesByRmid.get(n10);
                                        if (rR == null) {
                                            if (this.spareXAConns.isEmpty()) {
                                                Trace.trace(this, "no connection available for rmid " + n2 + ", must be spare");
                                                object = (RR)this.spareRmids.get(n10);
                                                if (object == null) {
                                                    Trace.trace(this, "problem: rmId " + n10 + " missing from the spareRmids list - returning error");
                                                    n7 = -3;
                                                    break block19;
                                                }
                                                ((RR)object).xid = xid;
                                                n6 = 0;
                                                break block20;
                                            }
                                            object = (XAConnection)this.spareXAConns.lastElement();
                                            this.spareXAConns.removeElement(object);
                                            rR = (RR)this.spareRmids.remove(n10);
                                            if (rR == null) {
                                                Trace.trace(this, "can't find rmid on spareRmids list (2nd position)" + n2);
                                                n5 = -3;
                                                break block21;
                                            }
                                            rR.res = object.getXAResource();
                                            rR.rmId = n10;
                                            this.resourcesByRmid.put(n10, rR);
                                            this.resourcesByConn.put(object, rR);
                                        }
                                        object = rR.res;
                                        rR.xid = xid;
                                        Trace.trace(this, "XAStart, xid '" + xid + "', flags " + n3);
                                        object.start(xid, n3);
                                        n4 = 0;
                                        break block22;
                                    }
                                    catch (XAException xAException) {
                                        Trace.trace(this, "caught " + xAException);
                                        n4 = xAException.errorCode;
                                        Object var15_18 = null;
                                        Trace.exit(this, "xa_start");
                                        return n4;
                                    }
                                    catch (Exception exception) {
                                        Trace.trace(this, "caught " + exception);
                                        Trace.trace(this, "converting to XAER_RMERR return code");
                                        n4 = -3;
                                        Object var15_19 = null;
                                        Trace.exit(this, "xa_start");
                                        return n4;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var15_20 = null;
                                    Trace.exit(this, "xa_start");
                                    throw throwable;
                                }
                            }
                            Trace.exit(this, "xa_start");
                            return n9;
                        }
                        Object var15_12 = null;
                        Trace.exit(this, "xa_start");
                        return n8;
                    }
                    Object var15_14 = null;
                    Trace.exit(this, "xa_start");
                    return n7;
                }
                Object var15_15 = null;
                Trace.exit(this, "xa_start");
                return n6;
            }
            Object var15_16 = null;
            Trace.exit(this, "xa_start");
            return n5;
        }
        Object var15_17 = null;
        Trace.exit(this, "xa_start");
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_end(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        block12: {
            int n5;
            block11: {
                int n6;
                block10: {
                    int n7;
                    block9: {
                        n4 = -3;
                        try {
                            try {
                                Trace.entry(this, "xa_end");
                                Trace.trace(this, "XAEnd: rmid is " + n2);
                                this.inTransaction = false;
                                this.dirtyResources.removeAllElements();
                                Integer n8 = new Integer(n2);
                                RR rR = (RR)this.resourcesByRmid.get(n8);
                                if (rR == null) {
                                    Trace.trace(this, "rmid not assigned");
                                    n7 = 0;
                                    Object var13_13 = null;
                                    break block9;
                                }
                                XAResource xAResource = rR.res;
                                if (xAResource == null) {
                                    Trace.trace(this, "odd: assigned rmid with null XAResouce");
                                    n6 = 0;
                                    break block10;
                                }
                                Xid xid = rR.xid;
                                if (xid == null) {
                                    Trace.trace(this, "odd: assigned rmid with null xid");
                                    n5 = 0;
                                    break block11;
                                }
                                Trace.trace(this, "xid is '" + xid + "', flags are " + n3);
                                xAResource.end(xid, n3);
                                n4 = 0;
                                break block12;
                            }
                            catch (XAException xAException) {
                                Trace.trace(this, "caught " + xAException);
                                n4 = xAException.errorCode;
                                Object var13_17 = null;
                                Trace.exit(this, "xa_end");
                                return n4;
                            }
                            catch (Exception exception) {
                                Trace.trace(this, "caught " + exception);
                                n4 = -3;
                                Object var13_18 = null;
                                Trace.exit(this, "xa_end");
                                return n4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_19 = null;
                            Trace.exit(this, "xa_end");
                            throw throwable;
                        }
                    }
                    Trace.exit(this, "xa_end");
                    return n7;
                }
                Object var13_14 = null;
                Trace.exit(this, "xa_end");
                return n6;
            }
            Object var13_15 = null;
            Trace.exit(this, "xa_end");
            return n5;
        }
        Object var13_16 = null;
        Trace.exit(this, "xa_end");
        return n4;
    }

    private void _deregisterResource(XAConnection xAConnection) throws XAException {
        try {
            Trace.entry(this, "_deregisterResource");
            RR rR = (RR)this.resourcesByConn.get(xAConnection);
            if (rR == null) {
                Trace.trace(this, "conn not assigned, checking spares");
                if (!this.spareXAConns.removeElement(xAConnection)) {
                    Trace.trace(this, "conn not found in spare list either");
                } else {
                    Trace.trace(this, "found conn in spares list");
                }
            } else {
                Trace.trace(this, "found RR for xaconn");
                XAResource xAResource = rR.res;
                Integer n = rR.rmId;
                if (this.inTransaction) {
                    Xid xid = rR.xid;
                    if (xid == null) {
                        Trace.trace(this, "odd - no xid for rmid " + n);
                    } else {
                        Trace.trace(this, "doing xa_end");
                        xAResource.end(xid, 0x4000000);
                        this.dirtyResources.addElement(xAResource);
                    }
                } else {
                    Trace.trace(this, "not in transaction, skipping xa_end");
                }
                this.resourcesByConn.remove(xAConnection);
                this.resourcesByRmid.remove(n);
                Trace.trace(this, "putting rmId " + n + " back onto spares list");
                this.spareRmids.put(n, rR);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Trace.exit(this, "_deregisterResource");
            throw throwable;
        }
        Trace.exit(this, "_deregisterResource");
    }

    private void _registerResource(XAConnection xAConnection) throws MQException, SQLException, XAException {
        RR rR = null;
        try {
            block11: {
                try {
                    XAResource xAResource;
                    Object object;
                    Trace.entry(this, "_registerResource");
                    XAResource xAResource2 = xAConnection.getXAResource();
                    Enumeration<Object> enumeration = this.spareXAConns.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (XAConnection)enumeration.nextElement();
                        xAResource = object.getXAResource();
                        if (!xAResource2.isSameRM(xAResource)) continue;
                        Trace.trace(this, "xaResource matches previously registered connection, returning an error");
                        throw new MQException(2, 2195, this);
                    }
                    enumeration = this.resourcesByConn.keys();
                    while (enumeration.hasMoreElements()) {
                        object = (XAConnection)enumeration.nextElement();
                        xAResource = object.getXAResource();
                        if (!xAResource2.isSameRM(xAResource)) continue;
                        Trace.trace(this, "xaResource matches previously registered connection, returning an error");
                        throw new MQException(2, 2195, this);
                    }
                    if (!this.inTransaction) {
                        Trace.trace(this, "not in transaction, adding to spare conns");
                        this.spareXAConns.addElement(xAConnection);
                        xAConnection.addConnectionEventListener(this);
                        break block11;
                    }
                    enumeration = this.dirtyResources.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (XAResource)enumeration.nextElement();
                        if (!xAResource2.isSameRM((XAResource)object)) continue;
                        Trace.trace(this, "XAResource found on dirty list, throwing exception");
                        throw new XAException(-5);
                    }
                    if (this.spareRmids.isEmpty()) {
                        Trace.trace(this, "no spare rmids available, throwing an exception");
                        throw new MQException(2, 2372, this);
                    }
                    enumeration = this.spareRmids.keys();
                    Integer n = (Integer)enumeration.nextElement();
                    rR = (RR)this.spareRmids.remove(n);
                    Trace.trace(this, "in transaction, driving xa_start");
                    rR.res = xAResource2;
                    xAResource2.start(rR.xid, 0);
                    this.resourcesByRmid.put(n, rR);
                    this.resourcesByConn.put(xAConnection, rR);
                    xAConnection.addConnectionEventListener(this);
                }
                catch (XAException xAException) {
                    Trace.trace(this, "throwing " + xAException);
                    throw xAException;
                }
                catch (SQLException sQLException) {
                    Trace.trace(this, "throwing " + sQLException);
                    throw sQLException;
                }
                catch (MQException mQException) {
                    Trace.trace(this, "throwing " + mQException);
                    throw mQException;
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Trace.exit(this, "_registerResource");
            throw throwable;
        }
        Trace.exit(this, "_registerResource");
    }

    private void _resetRC() {
        Trace.trace(this, "resetting beginRC");
        this.beginRC = 2372;
    }

    private int _getRC() {
        Trace.trace(this, "returning beginRC=" + this.beginRC);
        return this.beginRC;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = null;
        string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("MQ_JDBC_ORA816");
                }
                catch (AccessControlException accessControlException) {
                    Trace.trace(clsName, "failed to lookup system property for MQ_JDBC_ORA816: " + accessControlException);
                    return null;
                }
            }
        });
        if (string != null) {
            Trace.trace(clsName, "setting flag for Oracle 8.1.6 JDBC driver");
            useOra816 = true;
        } else {
            useOra816 = false;
        }
    }

    private class RR {
        public XAResource res;
        public Integer rmId;
        public Xid xid;

        private RR() {
        }
    }
}

