/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Vector;

class PoolScavenger
implements Runnable {
    private static final String sccsid = "common/javabase/com/ibm/mq/PoolScavenger.java, java, j521, j521-L020126 02/01/25 14:58:12 @(#) 1.4.2.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CLASSNAME = "PoolScavenger";
    private static int tid = 0;
    private long timeout = 300000L;
    private int highThreshold = 10;
    private Vector smcs = new Vector();
    private Vector times = new Vector();
    private boolean quit = false;
    private boolean nonempty = false;
    private Object updateLock = new Object();
    private Thread thread = null;

    PoolScavenger() {
    }

    public synchronized void run() {
        Trace.entry(this, "run");
        long l = 0L;
        StoredManagedConnection storedManagedConnection = null;
        long l2 = 0L;
        while (!this.quit) {
            long l3 = System.currentTimeMillis();
            boolean bl = false;
            Object object = this.updateLock;
            synchronized (object) {
                if (!this.smcs.isEmpty()) {
                    l = (Long)this.times.firstElement() + this.timeout;
                    storedManagedConnection = (StoredManagedConnection)this.smcs.firstElement();
                    l2 = this.smcs.size();
                    this.nonempty = true;
                } else {
                    this.nonempty = false;
                }
                if (!this.quit) {
                    if (this.nonempty) {
                        if (l <= l3 || l2 > (long)this.highThreshold) {
                            Trace.trace(2, this, "SMC expired; about to call trigger()");
                            bl = true;
                        } else {
                            try {
                                Trace.trace(2, this, "Waiting for SMC to expire");
                                this.updateLock.wait(l - l3);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else {
                        try {
                            Trace.trace(2, this, "No SMC in list; waiting");
                            this.updateLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!bl) continue;
            storedManagedConnection.trigger();
        }
        Trace.exit(this, "run");
    }

    void register(StoredManagedConnection storedManagedConnection) {
        Trace.entry(this, "register");
        Object object = this.updateLock;
        synchronized (object) {
            this.smcs.addElement(storedManagedConnection);
            this.times.addElement(new Long(System.currentTimeMillis()));
            Trace.trace(2, this, "Notifying scavenger thread");
            this.updateLock.notify();
        }
        Trace.exit(this, "register");
    }

    void deregister(StoredManagedConnection storedManagedConnection) {
        Trace.entry(this, "deregister");
        Object object = this.updateLock;
        synchronized (object) {
            int n = this.smcs.indexOf(storedManagedConnection);
            if (n != -1) {
                this.smcs.removeElementAt(n);
                this.times.removeElementAt(n);
                Trace.trace(2, this, "Notifying scavenger thread");
                this.updateLock.notify();
            }
        }
        Trace.exit(this, "deregister");
    }

    void setTimeout(long l) {
        Trace.entry(this, "setTimeout");
        this.timeout = l;
        Trace.trace(2, this, "Notifying scavenger thread");
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        Trace.exit(this, "setTimeout");
    }

    long getTimeout() {
        return this.timeout;
    }

    void setHighThreshold(int n) {
        Trace.entry(this, "setHighThreshold");
        this.highThreshold = n;
        Trace.trace(2, this, "Notifying scavenger thread");
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        Trace.exit(this, "setHighThreshold");
    }

    int getHighThreshold() {
        return this.highThreshold;
    }

    void start() {
        Trace.entry(this, "start");
        this.quit = false;
        String string = CLASSNAME + tid;
        ++tid;
        this.thread = MQEnvironment.createThread(this, string, true);
        this.thread.start();
        Trace.exit(this, "start");
    }

    void quit() {
        Trace.entry(this, "quit");
        this.quit = true;
        Trace.trace(2, this, "Notifying scavenger thread");
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        Trace.trace(2, this, "Waiting for scavenger thread to end");
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.trace(2, this, "WARNING: Thread was interrupted");
        }
        Trace.exit(this, "quit");
    }

    static {
        Trace.trace(CLASSNAME, sccsid);
    }
}

