/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolServicesEvent;
import com.ibm.mq.MQPoolServicesEventListener;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.PoolScavenger;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public final class MQSimpleConnectionManager
implements MQConnectionManager {
    private static final String sccsid = "common/javabase/com/ibm/mq/MQSimpleConnectionManager.java, java, j521, j521-L020126  02/01/25 14:57:59 @(#) 1.3.2.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManagedConnectionStore mcs = new ManagedConnectionStore();
    private PoolScavenger scavenger = new PoolScavenger();
    private Vector ownedSMCs = new Vector();
    private boolean active = false;
    private int mode = 0;
    private MQPoolServices poolServices = new MQPoolServices();
    private PSAdapter adapter = new PSAdapter();
    public static final int MODE_AUTO = 0;
    public static final int MODE_ACTIVE = 1;
    public static final int MODE_INACTIVE = 2;

    public MQSimpleConnectionManager() {
        this.poolServices.addMQPoolServicesEventListener(this.adapter);
    }

    public Object allocateConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Trace.entry(this, "allocateConnection");
        StoredManagedConnection storedManagedConnection = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && !bl2) {
            storedManagedConnection = this.mcs.chooseOne(mQManagedConnectionFactory, connectionRequestInfo);
            if (storedManagedConnection != null) {
                try {
                    object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                    bl = true;
                }
                catch (ResourceException resourceException) {
                    storedManagedConnection.destroy();
                }
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            storedManagedConnection = null;
            try {
                storedManagedConnection = new StoredManagedConnection(mQManagedConnectionFactory, connectionRequestInfo, this.mcs, this.scavenger, this);
                MQSimpleConnectionManager mQSimpleConnectionManager = this;
                synchronized (mQSimpleConnectionManager) {
                    storedManagedConnection.initializePoolActive(this.active);
                }
                object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
            }
            catch (ResourceException resourceException) {
                if (storedManagedConnection != null) {
                    storedManagedConnection.destroy();
                }
                throw resourceException;
            }
        }
        Trace.exit(this, "allocateConnection");
        return object;
    }

    public synchronized void setActive(int n) {
        Trace.entry(this, "setActive");
        if (n != 0 && n != 1 && n != 2) {
            Trace.exit(this, "setActive (via exception)");
            throw new IllegalArgumentException();
        }
        this.mode = n;
        switch (n) {
            case 0: {
                if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                    this._setActive(true);
                } else {
                    this._setActive(false);
                }
                this.poolServices.addMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 1: {
                this._setActive(true);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 2: {
                this._setActive(false);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
            }
        }
        Trace.exit(this, "setActive");
    }

    public int getActive() {
        return this.mode;
    }

    public void setTimeout(long l) {
        if (l < 0L) {
            Trace.trace(2, this, "setTimeout called with timeout < 0");
            throw new IllegalArgumentException();
        }
        this.scavenger.setTimeout(l);
    }

    public long getTimeout() {
        return this.scavenger.getTimeout();
    }

    public void setHighThreshold(int n) {
        if (n < 0) {
            Trace.trace(2, this, "setHighThreshold called with thresdhold < 0");
            throw new IllegalArgumentException();
        }
        this.scavenger.setHighThreshold(n);
    }

    public int getHighThreshold() {
        return this.scavenger.getHighThreshold();
    }

    void _setActive(boolean bl) {
        Enumeration enumeration;
        Vector vector;
        Trace.entry(this, "_setActive");
        MQSimpleConnectionManager mQSimpleConnectionManager = this;
        synchronized (mQSimpleConnectionManager) {
            this.active = bl;
            boolean bl2 = false;
            vector = (Vector)this.ownedSMCs.clone();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                StoredManagedConnection storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                storedManagedConnection.poolActive(bl);
            }
            if (bl) {
                this.scavenger.start();
            } else {
                this.scavenger.quit();
            }
        }
        if (!bl) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                StoredManagedConnection storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                storedManagedConnection.destroyIfMarked();
            }
        }
        Trace.exit(this, "_setActive");
    }

    void addStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.addElement(storedManagedConnection);
    }

    void removeStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.removeElement(storedManagedConnection);
    }

    synchronized void _tokenSetChanged(MQPoolServicesEvent mQPoolServicesEvent) {
        if (this.mode == 0) {
            if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                if (!this.active) {
                    this._setActive(true);
                }
            } else if (this.active) {
                this._setActive(false);
            }
        }
    }

    private class PSAdapter
    implements MQPoolServicesEventListener {
        private PSAdapter() {
        }

        public void tokenAdded(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void tokenRemoved(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void defaultConnectionManagerChanged(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }
    }
}

