/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BatchMatchingCriteria;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQInternalCommunications;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQXAResource;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.MQXid;
import com.ibm.mq.MessageBufferManager;
import com.ibm.mq.Pint;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

final class MQSESSIONClient
extends MQSESSION
implements MQXAVerbs {
    private static final String sccsid = "common/javabase/com/ibm/mq/MQSESSIONClient.java, java, j521, j521-L020614 02/06/13 15:16:11 @(#) 1.35.1.9";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5639-B43 (c) Copyright IBM Corp. 1997, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSIONClient";
    private static final int SPIVERB_QUERY = 1;
    private static final int SPIVERB_PUT = 2;
    private static final int SPIVERB_GET = 3;
    private static final int SPIVERB_ACTIVATE = 4;
    private static final int SPIGET_STATUS_EOB = 2;
    private static final int lpiPUTOPTS_NONE = 0;
    private static final int lpiPUTOPTS_BLANK_PADDED = 1;
    private static final int lpiPUTOPTS_SYNCPOINT_IF_YOU_LIKE = 2;
    private static final int lpiPUTOPTS_DEFERRED = 4;
    private static final int lpiACTIVATE_ACTIVATE = 1;
    private static final int lpiACTIVATE_CANCEL = 2;
    protected static final int ENC_ASCII = 1;
    private static final int spiQueryMaxReplySize = 10240;
    private Hashtable supportedSpiVerbs = null;
    private BatchMatchingCriteria batchCriteria = null;
    private boolean startBatchingASAP = false;
    private int batchabilityCount = 0;
    private boolean firstEntryToSpiBatchedGet = true;
    private MessageBufferManager msgBuffers = null;
    private boolean inMiddleOfBatch = false;
    private boolean inhibitNewBatches = false;
    private boolean batchingProhibited = false;
    private int batchSizeFloor = 20;
    private int batchSizeCeiling = 150;
    private int batchingThreshold = 20;
    private int batchIntervalParm = 20;
    private int batchSize = this.batchSizeFloor;
    private int maxMsgSizeForBatch = 0;
    private boolean deferredChecked = false;
    private boolean deferredSupported = false;
    private MQInternalCommunications comms = null;
    private static int nextAvailableConnectionHandle = 5;
    protected int transmissionLength = 0;
    BatchMatchingCriteria testCriteria = null;
    Pint batchedGetStatusPint = null;

    MQSESSIONClient() {
    }

    static final void writeInt(byte[] byArray, int n, int n2) {
        int n3 = n2;
        byArray[n + 3] = (byte)(n3 & 0xFF);
        byArray[n + 2] = (byte)((n3 >>>= 8) & 0xFF);
        byArray[n + 1] = (byte)((n3 >>>= 8) & 0xFF);
        byArray[n] = (byte)(n3 >>>= 8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xaOp(Xid xid, int n, int n2, int n3, int n4) throws Exception {
        int n5;
        block10: {
            int n6;
            block9: {
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                n5 = -1;
                Trace.entry(this, "xaOp");
                try {
                    try {
                        if (this.comms == null) {
                            Trace.trace(this, "null comms instance");
                            String string = MQException.getNLSMsg(2);
                            throw MQXAResource.createXAException(-3, string);
                        }
                        int n7 = xid.getFormatId();
                        byte[] byArray = xid.getBranchQualifier();
                        byte[] byArray2 = xid.getGlobalTransactionId();
                        int n8 = (byArray.length + byArray2.length + 6 + 3) / 4;
                        int n9 = n8 * 4;
                        byte[] byArray3 = new byte[n9];
                        MQSESSIONClient.writeInt(byArray3, 0, n7);
                        byArray3[4] = (byte)byArray2.length;
                        byArray3[5] = (byte)byArray.length;
                        System.arraycopy(byArray2, 0, byArray3, 6, byArray2.length);
                        System.arraycopy(byArray, 0, byArray3, 6 + byArray2.length, byArray.length);
                        byte[] byArray4 = this.comms.buildAPIHeader(byArray3.length, 0, n2, n);
                        pint.x = n3;
                        DataInputStream dataInputStream = this.lowLevelComms(pint, pint2, pint3, byArray3, byArray4);
                        if (pint.x != n4) {
                            Trace.trace(this, "unexpected segment type " + pint.x);
                            this.errorCloseComms();
                            n6 = -3;
                            Object var21_25 = null;
                            break block9;
                        }
                        dataInputStream.skipBytes(4);
                        n5 = dataInputStream.readInt();
                        break block10;
                    }
                    catch (IOException iOException) {
                        Trace.trace(this, "IOException occurred " + iOException);
                        int n10 = -3;
                        Object var21_27 = null;
                        Trace.exit(this, "xaOp");
                        return n10;
                    }
                    catch (MQException mQException) {
                        Trace.trace(this, "MQException occurred " + mQException);
                        int n11 = -3;
                        Object var21_28 = null;
                        Trace.exit(this, "xaOp");
                        return n11;
                    }
                    catch (Exception exception) {
                        Trace.trace(this, "throwing " + exception);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var21_29 = null;
                    Trace.exit(this, "xaOp");
                    throw throwable;
                }
            }
            Trace.exit(this, "xaOp");
            return n6;
        }
        Object var21_26 = null;
        Trace.exit(this, "xaOp");
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int XAOPEN(String string, int n, int n2) throws Exception {
        int n3;
        block13: {
            int n4;
            block12: {
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                n3 = -1;
                Trace.entry(this, "XAOPEN");
                try {
                    try {
                        byte[] byArray;
                        if (this.comms == null) {
                            Trace.trace(this, "null comms instance");
                            String string2 = MQException.getNLSMsg(2);
                            throw MQXAResource.createXAException(-3, string2);
                        }
                        if (!MQEnvironment.runningInWS() && !MQEnvironment.getXaClientEnabled()) {
                            Trace.trace(clsName, "client XA not enabled, failing the XAOPEN call");
                            String string3 = MQException.getNLSMsg(119);
                            throw MQXAResource.createXAException(-3, string3);
                        }
                        if (string == null) {
                            byArray = new byte[]{0, 0};
                        } else {
                            int n5 = string.length();
                            byArray = new byte[n5 + 2];
                            byArray[0] = (byte)n5;
                            System.arraycopy(string.getBytes(), 0, byArray, 1, n5);
                            byArray[n5 + 1] = 0;
                        }
                        byte[] byArray2 = this.comms.buildAPIHeader(byArray.length, 0, n2, n);
                        pint.x = 163;
                        DataInputStream dataInputStream = this.lowLevelComms(pint, pint2, pint3, byArray, byArray2);
                        if (pint.x != 179) {
                            Trace.trace(this, "unexpected segment type: " + pint.x);
                            this.errorCloseComms();
                            n4 = -1;
                            Object var14_18 = null;
                            break block12;
                        }
                        dataInputStream.skipBytes(4);
                        n3 = dataInputStream.readInt();
                        Trace.trace(this, "result=" + n3);
                        break block13;
                    }
                    catch (IOException iOException) {
                        Trace.trace(1, clsName, "IOException occurred: " + iOException);
                        int n6 = -1;
                        Object var14_20 = null;
                        Trace.exit(this, "XAOPEN");
                        return n6;
                    }
                    catch (MQException mQException) {
                        Trace.trace(1, clsName, "MQException occurred: " + mQException);
                        int n7 = -1;
                        Object var14_21 = null;
                        Trace.exit(this, "XAOPEN");
                        return n7;
                    }
                    catch (Exception exception) {
                        Trace.trace(this, "throwing " + exception);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    Trace.exit(this, "XAOPEN");
                    throw throwable;
                }
            }
            Trace.exit(this, "XAOPEN");
            return n4;
        }
        Object var14_19 = null;
        Trace.exit(this, "XAOPEN");
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int XACLOSE(String string, int n, int n2) throws Exception {
        int n3;
        block12: {
            int n4;
            block11: {
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                n3 = -1;
                Trace.entry(this, "XACLOSE");
                try {
                    try {
                        byte[] byArray;
                        if (this.comms == null) {
                            Trace.trace(this, "null comms instance");
                            String string2 = MQException.getNLSMsg(2);
                            throw MQXAResource.createXAException(-3, string2);
                        }
                        if (string == null) {
                            byArray = new byte[]{0, 0};
                        } else {
                            int n5 = string.length();
                            byArray = new byte[n5 + 2];
                            byArray[0] = (byte)n5;
                            System.arraycopy(string.getBytes(), 0, byArray, 1, n5);
                            byArray[n5 + 1] = 0;
                        }
                        byte[] byArray2 = this.comms.buildAPIHeader(byArray.length, 0, n2, n);
                        pint.x = 164;
                        DataInputStream dataInputStream = this.lowLevelComms(pint, pint2, pint3, byArray, byArray2);
                        if (pint.x != 180) {
                            Trace.trace(this, "unexpected segment type " + pint.x);
                            this.errorCloseComms();
                            n4 = -3;
                            Object var14_17 = null;
                            break block11;
                        }
                        dataInputStream.skipBytes(4);
                        n3 = dataInputStream.readInt();
                        break block12;
                    }
                    catch (IOException iOException) {
                        Trace.trace(1, this, "IOException occurred " + iOException);
                        int n6 = -3;
                        Object var14_19 = null;
                        Trace.exit(this, "XACLOSE");
                        return n6;
                    }
                    catch (MQException mQException) {
                        Trace.trace(1, this, "MQException occurred " + mQException);
                        int n7 = -3;
                        Object var14_20 = null;
                        Trace.exit(this, "XACLOSE");
                        return n7;
                    }
                    catch (Exception exception) {
                        Trace.trace(this, "throwing " + exception);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    Trace.exit(this, "XACLOSE");
                    throw throwable;
                }
            }
            Trace.exit(this, "XACLOSE");
            return n4;
        }
        Object var14_18 = null;
        Trace.exit(this, "XACLOSE");
        return n3;
    }

    public int XASTART(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XASTART");
            n3 = this.xaOp(xid, n, n2, 161, 177);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XASTART");
            throw throwable;
        }
        Trace.exit(this, "XASTART");
        return n3;
    }

    public int XAEND(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XAEND");
            n3 = this.xaOp(xid, n, n2, 162, 178);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XAEND");
            throw throwable;
        }
        Trace.exit(this, "XAEND");
        return n3;
    }

    public int XAPREPARE(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XAPREPARE");
            n3 = this.xaOp(xid, n, n2, 165, 181);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XAPREPARE");
            throw throwable;
        }
        Trace.exit(this, "XAPREPARE");
        return n3;
    }

    public int XACOMMIT(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XACOMMIT");
            n3 = this.xaOp(xid, n, n2, 166, 182);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XACOMMIT");
            throw throwable;
        }
        Trace.exit(this, "XACOMMIT");
        return n3;
    }

    public int XAROLLBACK(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XAROLLBACK");
            n3 = this.xaOp(xid, n, n2, 167, 183);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XAROLLBACK");
            throw throwable;
        }
        Trace.exit(this, "XAROLLBACK");
        return n3;
    }

    public int XAFORGET(Xid xid, int n, int n2) throws Exception {
        int n3;
        try {
            Trace.entry(this, "XAFORGET");
            n3 = this.xaOp(xid, n, n2, 168, 184);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.exit(this, "XAFORGET");
            throw throwable;
        }
        Trace.exit(this, "XAFORGET");
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int XARECOVER(Xid[] xidArray, int n, int n2) throws Exception {
        int n3;
        block11: {
            int n4;
            block10: {
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                int n5 = -1;
                Trace.entry(this, "XARECOVER");
                try {
                    try {
                        if (this.comms == null) {
                            Trace.trace(this, "null comms instance");
                            String string = MQException.getNLSMsg(2);
                            throw MQXAResource.createXAException(-3, string);
                        }
                        byte[] byArray = new byte[4];
                        MQSESSIONClient.writeInt(byArray, 0, xidArray.length);
                        byte[] byArray2 = this.comms.buildAPIHeader(byArray.length, 0, n2, n);
                        pint.x = 169;
                        DataInputStream dataInputStream = this.lowLevelComms(pint, pint2, pint3, byArray, byArray2);
                        if (pint.x != 185) {
                            Trace.trace(this, "unexpected segment type " + pint.x);
                            this.errorCloseComms();
                            n4 = -3;
                            Object var22_19 = null;
                            break block10;
                        }
                        dataInputStream.skipBytes(4);
                        n5 = dataInputStream.readInt();
                        Trace.trace(this, "result = " + n5);
                        dataInputStream.skipBytes(8);
                        int n6 = dataInputStream.readInt();
                        Trace.trace(this, "server returned " + n6 + " xids");
                        int n7 = 0;
                        while (true) {
                            if (n7 >= n6) {
                                n3 = n5;
                                break block11;
                            }
                            n3 = dataInputStream.readInt();
                            byte by = dataInputStream.readByte();
                            byte by2 = dataInputStream.readByte();
                            byte[] byArray3 = new byte[by];
                            dataInputStream.readFully(byArray3);
                            byte[] byArray4 = new byte[by2];
                            dataInputStream.readFully(byArray4);
                            int n8 = 6 + by + by2;
                            int n9 = (4 - n8 % 4) % 4;
                            Trace.trace(this, "unpaddedLen = " + n8 + ", padBytes = " + n9);
                            dataInputStream.skipBytes(n9);
                            xidArray[n7] = new MQXid(n3, byArray3, byArray4);
                            ++n7;
                        }
                    }
                    catch (IOException iOException) {
                        Trace.trace(1, this, "IOException occurred " + iOException);
                        int n10 = -3;
                        Object var22_21 = null;
                        Trace.exit(this, "XARECOVER");
                        return n10;
                    }
                    catch (MQException mQException) {
                        Trace.trace(1, this, "MQException occurred " + mQException);
                        int n11 = -3;
                        Object var22_22 = null;
                        Trace.exit(this, "XARECOVER");
                        return n11;
                    }
                    catch (Exception exception) {
                        Trace.trace(this, "throwing " + exception);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_23 = null;
                    Trace.exit(this, "XARECOVER");
                    throw throwable;
                }
            }
            Trace.exit(this, "XARECOVER");
            return n4;
        }
        Object var22_20 = null;
        Trace.exit(this, "XARECOVER");
        return n3;
    }

    public final void MQBACK(int n, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQBACK");
        Trace.trace(2, clsName, "Connection handle = " + n);
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQDISC");
            return;
        }
        try {
            byte[] byArray = this.comms.buildAPIHeader(0, 0, 0, 0);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 139;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, null, byArray);
            if (pint3.x != 155) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQBACK");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQBACK");
        }
    }

    public final void MQBEGIN(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQBEGIN");
            Trace.trace(2, clsName, "Conn Handle = " + n);
        }
        pint.x = 2;
        pint2.x = 2012;
        Trace.exit(clsName, "MQBEGIN");
    }

    public final void MQCLOSE(int n, Pint pint, int n2, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQCLOSE");
            Trace.trace(2, clsName, "Conn Handle = " + n + " Object Handle = " + pint.x);
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2019;
            Trace.exit(clsName, "MQCLOSE");
            return;
        }
        try {
            if (this.msgBuffers != null) {
                this.msgBuffers.purgeBuffer(n, pint.x);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n2);
            byte[] byArray = this.comms.buildAPIHeader(4, 0, 0, pint.x);
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            Pint pint6 = new Pint();
            pint4.x = 132;
            DataInputStream dataInputStream = this.lowLevelComms(pint4, pint5, pint6, byteArrayOutputStream.toByteArray(), byArray);
            if (pint4.x != 148) {
                this.analyseError(dataInputStream, pint4, pint5, pint2, pint3);
                pint.x = -1;
                this.errorCloseComms();
                Trace.exit(clsName, "MQCLOSE");
                return;
            }
            dataInputStream.skipBytes(4);
            pint2.x = dataInputStream.readInt();
            pint3.x = dataInputStream.readInt();
            if (pint3.x != 2055) {
                pint.x = -1;
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = -1;
            pint2.x = mQException.completionCode;
            pint3.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQCLOSE");
        }
    }

    public final void MQCMIT(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQCMIT");
            Trace.trace(2, clsName, "Handle = " + n);
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQCMIT");
            return;
        }
        try {
            byte[] byArray = this.comms.buildAPIHeader(0, 0, 0, 0);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 138;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, null, byArray);
            if (pint3.x != 154) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQCMIT");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQCMIT");
        }
    }

    public final synchronized void MQCONN(String string, Pint pint, Pint pint2, Pint pint3) {
        String string2;
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQCONN");
            Trace.trace(2, clsName, sccsid);
            if (string != null) {
                Trace.trace(1, clsName, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, clsName, "Connecting to default queue manager");
            }
        }
        if ((string2 = string) == null) {
            string2 = new String();
        }
        string2 = MQSESSION.setStringToLength(string2, 48);
        String string3 = this.mqManCon.getStringProperty("channel", "");
        if (string3.startsWith("*")) {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2195;
            if (MQException.log != null) {
                try {
                    MQException.log.write("Connection Failure : " + pint2.x + " " + pint3.x + " Channel names beginning with * are not supported.\n");
                }
                catch (IOException iOException) {
                    Trace.trace(1, clsName, "Exception writing to log stream: " + iOException);
                }
            }
            Trace.trace(1, clsName, "A Channel name beginning with * was specified.\nThis is not supported by the MQSeries Client for Java.");
            Trace.exit(clsName, "MQCONN");
            return;
        }
        int n = this.mqManCon.getIntegerProperty("connectOptions", 0);
        if (n != 1 && n != 0 && n != 0) {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2046;
            if (MQException.log != null) {
                try {
                    MQException.log.write("Connection Failure : " + pint2.x + " " + pint3.x + " Non-default connectOptions not supported by client.\n");
                }
                catch (IOException iOException) {
                    Trace.trace(1, clsName, "Exception writing to log stream: " + iOException);
                }
            }
            Trace.trace(1, clsName, "A non-default connectOptions value was specified.\nThis is not supported by the MQSeries Client for Java.");
            Trace.exit(clsName, "MQCONN");
            return;
        }
        try {
            this.comms = new MQInternalCommunications(string2, nextAvailableConnectionHandle, this.mqManCon);
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred whilst connecting");
            if (this.comms != null) {
                this.errorCloseComms();
            }
            pint.x = -1;
            pint2.x = mQException.completionCode;
            pint3.x = mQException.reasonCode;
            Trace.exit(clsName, "MQCONN");
            return;
        }
        pint.x = nextAvailableConnectionHandle++;
        pint2.x = 0;
        pint3.x = 0;
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQCONN");
        }
    }

    public final void MQCONNX(String string, int n, Pint pint, Pint pint2, Pint pint3) {
        Trace.entry(clsName, "MQCONNX");
        Trace.trace(2, clsName, sccsid);
        if (n == 0 || n == 1) {
            this.MQCONN(string, pint, pint2, pint3);
        } else {
            pint2.x = 2;
            pint3.x = 2046;
        }
        Trace.exit(clsName, "MQCONNX");
    }

    public final void MQDISC(Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQDISC");
            Trace.trace(1, clsName, "Handle = " + pint.x);
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + pint.x);
            pint2.x = 2;
            pint3.x = 2018;
            Trace.exit(clsName, "MQDISC");
            return;
        }
        this.MQCMIT(pint.x, pint2, pint3);
        if (this.comms != null) {
            this.comms.close();
        }
        this.comms = null;
        if (this.msgBuffers != null) {
            this.msgBuffers.purgeAllBuffers();
        }
        pint.x = -1;
        pint2.x = 0;
        pint3.x = 0;
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQDISC");
        }
    }

    public final void MQGET(int n, int n2, MQMD mQMD, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        MQGetMessageOptions mQGetMessageOptions2;
        block17: {
            Trace.entry(clsName, "MQGET");
            mQGetMessageOptions2 = null;
            if ((mQGetMessageOptions.options & 4) == 0 && (mQGetMessageOptions.options & 2) == 0 && (mQGetMessageOptions.options & 0x1000) == 0) {
                Trace.trace(2, clsName, "No SyncPoint action specified- implicit MQGMO_NO_SYNCPOINT...");
                mQGetMessageOptions2 = mQGetMessageOptions;
                mQGetMessageOptions.options |= 4;
            }
            if (this.comms == null) {
                Trace.trace(1, clsName, "Invalid connection handle: " + n);
                pint2.x = 2;
                pint3.x = 2019;
                Trace.exit(clsName, "MQGET");
                return;
            }
            if (mQMD == null) {
                pint2.x = 2;
                pint3.x = 2026;
                Trace.exit(clsName, "MQGET (null message descriptor)");
                return;
            }
            if (mQGetMessageOptions == null) {
                pint2.x = 2;
                pint3.x = 2186;
                Trace.exit(clsName, "MQGET (null get message options)");
                return;
            }
            if (byArray == null || byArray.length == 0) {
                pint2.x = 2;
                pint3.x = 2004;
                Trace.exit(clsName, "MQGET (null or zero length message buffer)");
                return;
            }
            if (n3 > byArray.length) {
                pint2.x = 2;
                pint3.x = 2005;
                Trace.exit(clsName, "MQGET (buffer too small)");
                return;
            }
            try {
                if (!this.supportsV2Structures(n)) {
                    if (mQGetMessageOptions.matchOptions == 0) {
                        mQGetMessageOptions.matchOptions = 3;
                        mQMD.messageId = new byte[24];
                        mQMD.correlationId = new byte[24];
                    }
                    mQGetMessageOptions.setVersion(1);
                    mQMD.setVersion(1);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream = mQMD.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
                dataOutputStream = mQGetMessageOptions.writeTo(dataOutputStream);
                dataOutputStream.writeInt(n3);
                int n4 = mQMD.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + 4 + n3;
                byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
                Pint pint4 = new Pint();
                Pint pint5 = new Pint();
                Pint pint6 = new Pint();
                pint4.x = 133;
                DataInputStream dataInputStream = this.lowLevelComms(pint4, pint5, pint6, byteArrayOutputStream.toByteArray(), byArray2);
                if (pint4.x != 149) {
                    this.analyseError(dataInputStream, pint4, pint5, pint2, pint3);
                    this.errorCloseComms();
                    Trace.exit(clsName, "MQGET");
                    return;
                }
                dataInputStream.skipBytes(4);
                pint2.x = dataInputStream.readInt();
                pint3.x = dataInputStream.readInt();
                dataInputStream.skipBytes(4);
                dataInputStream = mQMD.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
                dataInputStream = mQGetMessageOptions.readFrom(dataInputStream);
                pint.x = dataInputStream.readInt();
                try {
                    if (pint3.x != 2079) {
                        dataInputStream.read(byArray, 0, pint.x);
                        break block17;
                    }
                    dataInputStream.read(byArray, 0, n3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Trace.trace(1, clsName, "IndexOutOfBoundsException occurred");
                }
            }
            catch (IOException iOException) {
                Trace.trace(1, clsName, "IOException occurred");
                pint2.x = 2;
                pint3.x = 2195;
            }
            catch (MQException mQException) {
                Trace.trace(1, clsName, "MQException occurred");
                pint2.x = mQException.completionCode;
                pint3.x = mQException.reasonCode;
            }
        }
        if (mQGetMessageOptions2 != null) {
            mQGetMessageOptions = mQGetMessageOptions2;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQGET");
        }
    }

    public final void MQGET(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        MQGetMessageOptions mQGetMessageOptions2;
        block17: {
            Trace.entry(clsName, "MQGET (MQMsg2)");
            mQGetMessageOptions2 = null;
            if ((mQGetMessageOptions.options & 4) == 0 && (mQGetMessageOptions.options & 2) == 0 && (mQGetMessageOptions.options & 0x1000) == 0) {
                Trace.trace(2, clsName, "No SyncPoint action specified- implicit MQGMO_NO_SYNCPOINT...");
                mQGetMessageOptions2 = mQGetMessageOptions;
                mQGetMessageOptions.options |= 4;
            }
            if (this.comms == null) {
                Trace.trace(1, clsName, "Invalid connection handle: " + n);
                pint2.x = 2;
                pint3.x = 2019;
                Trace.exit(clsName, "MQGET (MQMsg2)");
                return;
            }
            if (mQMsg2 == null) {
                pint2.x = 2;
                pint3.x = 2026;
                Trace.exit(clsName, "MQGET (MQMsg2) (null message descriptor)");
                return;
            }
            if (mQGetMessageOptions == null) {
                pint2.x = 2;
                pint3.x = 2186;
                Trace.exit(clsName, "MQGET (MQMsg2) (null get message options)");
                return;
            }
            if (byArray == null || byArray.length == 0) {
                pint2.x = 2;
                pint3.x = 2004;
                Trace.exit(clsName, "MQGET (MQMsg2) (null or zero length message buffer)");
                return;
            }
            if (n3 > byArray.length) {
                pint2.x = 2;
                pint3.x = 2005;
                Trace.exit(clsName, "MQGET (MQMsg2) (buffer too small)");
                return;
            }
            try {
                if (!this.supportsV2Structures(n)) {
                    if (mQGetMessageOptions.matchOptions == 0) {
                        mQGetMessageOptions.matchOptions = 3;
                        mQMsg2.setMessageId(new byte[24]);
                        mQMsg2.setCorrelationId(new byte[24]);
                    }
                    mQGetMessageOptions.setVersion(1);
                    mQMsg2.setVersion(1);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream = mQMsg2.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
                dataOutputStream = mQGetMessageOptions.writeTo(dataOutputStream);
                dataOutputStream.writeInt(n3);
                int n4 = mQMsg2.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + 4 + n3;
                byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
                Pint pint4 = new Pint();
                Pint pint5 = new Pint();
                Pint pint6 = new Pint();
                pint4.x = 133;
                DataInputStream dataInputStream = this.lowLevelComms(pint4, pint5, pint6, byteArrayOutputStream.toByteArray(), byArray2);
                if (pint4.x != 149) {
                    this.analyseError(dataInputStream, pint4, pint5, pint2, pint3);
                    this.errorCloseComms();
                    Trace.exit(clsName, "MQGET (MQMsg2)");
                    return;
                }
                dataInputStream.skipBytes(4);
                pint2.x = dataInputStream.readInt();
                pint3.x = dataInputStream.readInt();
                dataInputStream.skipBytes(4);
                dataInputStream = mQMsg2.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
                dataInputStream = mQGetMessageOptions.readFrom(dataInputStream);
                pint.x = dataInputStream.readInt();
                try {
                    if (pint3.x != 2079) {
                        dataInputStream.read(byArray, 0, pint.x);
                        break block17;
                    }
                    dataInputStream.read(byArray, 0, n3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Trace.trace(1, clsName, "IndexOutOfBoundsException occurred");
                }
            }
            catch (IOException iOException) {
                Trace.trace(1, clsName, "IOException occurred");
                pint2.x = 2;
                pint3.x = 2195;
            }
            catch (MQException mQException) {
                Trace.trace(1, clsName, "MQException occurred");
                pint2.x = mQException.completionCode;
                pint3.x = mQException.reasonCode;
            }
        }
        if (mQGetMessageOptions2 != null) {
            mQGetMessageOptions = mQGetMessageOptions2;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQGET (MQMsg2)");
        }
    }

    protected final void spiBatchedGet(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        Trace.entry(this, "spiBatchedGet");
        Integer n4 = this.comms.communicationsLock;
        synchronized (n4) {
            if (this.firstEntryToSpiBatchedGet) {
                Integer n5;
                VerbInfo verbInfo;
                this.firstEntryToSpiBatchedGet = false;
                boolean bl = false;
                if (this.supportedSpiVerbs != null && (verbInfo = (VerbInfo)this.supportedSpiVerbs.get(n5 = new Integer(3))) != null && verbInfo.maxInOutVersion > 0 && verbInfo.maxInVersion > 0 && verbInfo.maxOutVersion > 0 && verbInfo.flags == 1) {
                    bl = true;
                }
                if (!bl) {
                    Trace.trace(2, this, "SPI batching not available");
                    this.batchingProhibited = true;
                } else {
                    this.msgBuffers = new MessageBufferManager();
                    this.initialiseBatchingParameters();
                }
            }
            if (this.batchingProhibited) {
                this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else if (this.msgBuffers.bufferExists(n, n2, mQMsg2, mQGetMessageOptions)) {
                Trace.trace(2, this, "Obtaining msg from buffer");
                this.getMessageFromBatchedBuffer(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                if (!this.msgBuffers.bufferExists(n, n2, mQMsg2, mQGetMessageOptions)) {
                    this.inhibitNewBatches = !this.msgBuffers.canCreateNewBuffer();
                }
            } else if (this.inhibitNewBatches) {
                Trace.trace(2, this, "New batching currently inhibited");
                this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else if (this.inMiddleOfBatch) {
                if (this.messageMatchesBatchCriteria(n, n2, mQMsg2, mQGetMessageOptions)) {
                    this.getBatchedMessage(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                    if (pint2.x == 2 && pint3.x == 2033 && !this.inMiddleOfBatch) {
                        this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                    }
                } else {
                    Trace.trace(2, this, "Dropping out of batching");
                    this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                    this.batchabilityCount = 0;
                    this.startBatchingASAP = false;
                    this.setNewBatchCriteria(n, n2, mQMsg2, mQGetMessageOptions);
                }
            } else if (this.startBatchingASAP && this.messageMatchesBatchCriteria(n, n2, mQMsg2, mQGetMessageOptions)) {
                Trace.trace(2, this, "Starting to batch!");
                this.startBatchingASAP = false;
                this.inMiddleOfBatch = true;
                this.startBatching(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                if (this.batchSize < this.batchSizeCeiling) {
                    ++this.batchSize;
                }
            } else {
                if (this.messageMatchesBatchCriteria(n, n2, mQMsg2, mQGetMessageOptions)) {
                    Trace.trace(2, this, "Incrementing batching count");
                    ++this.batchabilityCount;
                    if (this.batchabilityCount >= this.batchingThreshold) {
                        this.startBatchingASAP = true;
                    }
                } else {
                    Trace.trace(2, this, "Reset batching count");
                    this.batchabilityCount = 0;
                    this.startBatchingASAP = false;
                    this.setNewBatchCriteria(n, n2, mQMsg2, mQGetMessageOptions);
                }
                this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                if (pint2.x != 0) {
                    this.startBatchingASAP = false;
                    this.batchabilityCount = 0;
                }
            }
        }
        Trace.exit(this, "spiBatchedGet");
    }

    private void initialiseBatchingParameters() {
        Trace.entry(this, "initialiseBatchingParameters");
        String string = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.tuning.batchedGet");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jms.tuning.batchFloor");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        n2 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jms.tuning.batchCeiling");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jms.tuning.batchThreshold");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        n4 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jms.tuning.batchInterval");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (string != null) {
            if (string.equalsIgnoreCase("ON")) {
                this.batchingProhibited = false;
            } else if (string.equalsIgnoreCase("OFF")) {
                this.batchingProhibited = true;
            } else {
                Object object = this.mqManCon.getProperty("Batching enabled");
                if (object instanceof Boolean) {
                    this.batchingProhibited = (Boolean)object == false;
                }
            }
        } else {
            Object object = this.mqManCon.getProperty("Batching enabled");
            if (object instanceof Boolean) {
                boolean bl = this.batchingProhibited = (Boolean)object == false;
            }
        }
        if (n != null) {
            this.batchSizeFloor = n;
            if (this.batchSizeFloor < 0) {
                this.batchSizeFloor = 0;
            }
        } else {
            this.batchSizeFloor = this.mqManCon.getIntegerProperty("Batch size floor", this.batchSizeFloor);
        }
        this.batchSize = this.batchSizeFloor;
        if (n2 != null) {
            this.batchSizeCeiling = n2;
            if (this.batchSizeCeiling < 0) {
                this.batchSizeCeiling = 0;
            }
        } else {
            this.batchSizeCeiling = this.mqManCon.getIntegerProperty("Batch size ceiling", this.batchSizeCeiling);
        }
        if (n3 != null) {
            this.batchingThreshold = n3;
            if (this.batchingThreshold < 0) {
                this.batchingThreshold = 0;
            }
        } else {
            this.batchingThreshold = this.mqManCon.getIntegerProperty("Batching threshold", this.batchingThreshold);
        }
        if (n4 != null) {
            this.batchIntervalParm = n4;
            if (this.batchIntervalParm < 0) {
                this.batchIntervalParm = 0;
            }
        } else {
            this.batchIntervalParm = this.mqManCon.getIntegerProperty("Batch interval", this.batchIntervalParm);
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "batchingProhibited = " + this.batchingProhibited);
            Trace.trace(2, this, "batchSizeFloor     = " + this.batchSizeFloor);
            Trace.trace(2, this, "batchSizeCeiling   = " + this.batchSizeCeiling);
            Trace.trace(2, this, "batchingThreshold  = " + this.batchingThreshold);
            Trace.trace(2, this, "batchIntervalParm  = " + this.batchIntervalParm);
        }
        Trace.exit(this, "initialiseBatchingParameters");
    }

    protected int getMaxMessageSizeForBatch() {
        return this.maxMsgSizeForBatch;
    }

    private boolean messageMatchesBatchCriteria(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        boolean bl = false;
        if (this.batchCriteria != null) {
            if (this.testCriteria == null) {
                this.testCriteria = new BatchMatchingCriteria();
            }
            this.testCriteria.set(n, n2, mQMsg2, mQGetMessageOptions);
            bl = this.testCriteria.matches(this.batchCriteria);
        }
        return bl;
    }

    private void setNewBatchCriteria(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        if (this.batchCriteria == null) {
            this.batchCriteria = new BatchMatchingCriteria();
        }
        this.batchCriteria.set(n, n2, mQMsg2, mQGetMessageOptions);
    }

    private void parseBatchedMessage(DataInputStream dataInputStream, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n, byte[] byArray, Pint pint, Pint pint2, Pint pint3, Pint pint4) throws MQException {
        block5: {
            Trace.entry(this, "parseBatchedMessage");
            try {
                dataInputStream.skipBytes(4);
                pint2.x = dataInputStream.readInt();
                pint3.x = dataInputStream.readInt();
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream = mQMsg2.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
                dataInputStream = mQGetMessageOptions.readFrom(dataInputStream);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                pint4.x = dataInputStream.readInt();
                pint.x = dataInputStream.readInt();
                try {
                    if (pint3.x != 2079) {
                        dataInputStream.read(byArray, 0, pint.x);
                        break block5;
                    }
                    dataInputStream.read(byArray, 0, n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Trace.trace(2, this, "index out of bounds exception");
                }
            }
            catch (IOException iOException) {
                Trace.trace(1, this, "IOException thrown = " + iOException);
                Trace.exit(this, "parseBatchedMessage (via exception)");
                throw new MQInternalException(2, 2195, 117);
            }
        }
        Trace.exit(this, "parseBatchedMessage");
    }

    private void getMessageFromBatchedBuffer(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        Trace.entry(this, "getMessageFromBatchedBuffer");
        byte[] byArray2 = this.msgBuffers.getBufferedMessage(n, n2, mQMsg2, mQGetMessageOptions);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        if (this.batchedGetStatusPint == null) {
            this.batchedGetStatusPint = new Pint();
        }
        this.parseBatchedMessage(dataInputStream, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3, this.batchedGetStatusPint);
        Trace.exit(this, "getMessageFromBatchedBuffer");
    }

    private void getBatchedMessage(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        Trace.entry(this, "getBatchedMessage");
        Pint pint4 = new Pint();
        Pint pint5 = new Pint();
        Pint pint6 = new Pint();
        Trace.trace(2, clsName, "Obtaining lock on MQInternalCommunications object");
        DataInputStream dataInputStream = null;
        Integer n4 = this.comms.communicationsLock;
        synchronized (n4) {
            dataInputStream = this.comms.receive(pint4, pint5, pint6);
        }
        Trace.trace(2, clsName, "Releasing lock on MQInternalCommunications object");
        if (pint4.x != 156) {
            this.analyseError(dataInputStream, pint4, pint5, pint2, pint3);
            this.errorCloseComms();
            Trace.exit(clsName, "getBatchedMessage");
            return;
        }
        if (this.batchedGetStatusPint == null) {
            this.batchedGetStatusPint = new Pint();
        }
        this.parseBatchedMessage(dataInputStream, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3, this.batchedGetStatusPint);
        if ((this.batchedGetStatusPint.x & 2) != 0) {
            Trace.trace(2, this, "Batched status == end of batch");
            this.inMiddleOfBatch = false;
            this.maxMsgSizeForBatch = 0;
            this.startBatchingASAP = true;
        }
        Trace.exit(this, "getBatchedMessage");
    }

    private void startBatching(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        Trace.entry(this, "startBatching");
        try {
            if (!this.supportsV2Structures(n)) {
                if (mQGetMessageOptions.matchOptions == 0) {
                    mQGetMessageOptions.matchOptions = 3;
                    mQMsg2.setMessageId(new byte[24]);
                    mQMsg2.setCorrelationId(new byte[24]);
                }
                mQGetMessageOptions.setVersion(1);
                mQMsg2.setVersion(1);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(n3 + 20);
            dataOutputStream.writeBytes("SPGU");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(mQMsg2.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + 12);
            dataOutputStream = mQMsg2.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataOutputStream = mQGetMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeBytes("SPGI");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(24);
            dataOutputStream.writeInt(this.batchSize);
            dataOutputStream.writeInt(this.batchIntervalParm);
            dataOutputStream.writeInt(mQMsg2.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + n3);
            this.maxMsgSizeForBatch = mQMsg2.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + n3;
            int n4 = mQMsg2.sizeOfMQMD() + mQGetMessageOptions.sizeOfMQGetMessageOptions() + 4 + n3;
            byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            Pint pint6 = new Pint();
            Trace.trace(2, clsName, "Obtaining lock on MQInternalCommunications object");
            Integer n5 = this.comms.communicationsLock;
            synchronized (n5) {
                this.comms.send(140, 0, byteArrayOutputStream.toByteArray(), byArray2);
            }
            Trace.trace(2, clsName, "Releasing lock on MQInternalCommunications object");
            this.getBatchedMessage(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint2.x = 2;
            pint3.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint2.x = mQException.completionCode;
            pint3.x = mQException.reasonCode;
        }
        Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
        Trace.exit(this, "startBatching");
    }

    private DataInputStream lowLevelComms(Pint pint, Pint pint2, Pint pint3, byte[] byArray, byte[] byArray2) throws MQException, IOException {
        Trace.entry(this, "lowLevelComms");
        DataInputStream dataInputStream = null;
        Trace.trace(2, clsName, "Obtaining lock on MQInternalCommunications object");
        Integer n = this.comms.communicationsLock;
        synchronized (n) {
            this.comms.send(pint.x, pint2.x, byArray, byArray2);
            if (this.inMiddleOfBatch) {
                boolean bl;
                Trace.trace(2, this, "interrupting current batching operation");
                do {
                    bl = false;
                    byte[] byArray3 = this.comms.receiveBytes(pint, pint2, pint3);
                    if (pint.x == 156) {
                        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray3));
                        dataInputStream2.skipBytes(4);
                        int n2 = dataInputStream2.readInt();
                        int n3 = dataInputStream2.readInt();
                        dataInputStream2.skipBytes(4);
                        int n4 = dataInputStream2.readInt();
                        if (Trace.isOn()) {
                            Trace.trace(2, this, "CC=" + n2 + " RC=" + n3 + " verbId=" + n4);
                        }
                        if (n4 == 3) {
                            if (n2 != 2) {
                                this.msgBuffers.bufferMessage(byArray3, this.batchCriteria);
                            }
                            dataInputStream2.skipBytes(4);
                            dataInputStream2.skipBytes(4);
                            dataInputStream2.skipBytes(4);
                            dataInputStream2.skipBytes(4);
                            int n5 = dataInputStream2.readInt();
                            dataInputStream2.skipBytes(n5 - 12);
                            dataInputStream2.skipBytes(4);
                            dataInputStream2.skipBytes(4);
                            dataInputStream2.skipBytes(4);
                            int n6 = dataInputStream2.readInt();
                            if ((n6 & 2) == 0) {
                                bl = true;
                            }
                        }
                    }
                    boolean bl2 = this.inhibitNewBatches = !this.msgBuffers.canCreateNewBuffer();
                } while (bl);
                this.inMiddleOfBatch = false;
                this.maxMsgSizeForBatch = 0;
                this.batchSize = this.batchSizeFloor;
                this.startBatchingASAP = false;
            }
            dataInputStream = this.comms.receive(pint, pint2, pint3);
            this.transmissionLength = this.comms.transmissionLength;
        }
        Trace.trace(2, clsName, "Releasing lock on MQInternalCommunications object");
        Trace.exit(this, "lowLevelComms");
        return dataInputStream;
    }

    private void errorCloseComms() {
        if (this.comms != null) {
            this.comms.close();
        }
        this.comms = null;
        if (this.msgBuffers != null) {
            this.msgBuffers.purgeAllBuffers();
        }
    }

    private final void spiQuery(int n, Pint pint, Pint pint2) throws MQException {
        Trace.entry(this, "spiQuery");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (!this.comms.supportsSPI()) {
            Trace.trace(2, this, "spiQuery called on connection which does not support SPI!");
            return;
        }
        try {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(10240);
            dataOutputStream.writeBytes("SPQU");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(12);
            dataOutputStream.writeBytes("SPQI");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(12);
            byte[] byArray = this.comms.buildAPIHeader(dataOutputStream.size() + 10240, 0, 0, n);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 140;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray);
            if (pint3.x != 156) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "spiQuery");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            if (pint.x == 2) {
                Trace.trace(2, this, "spiQuery CC=" + pint.x + " RC=" + pint2.x);
            } else {
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                dataInputStream.skipBytes(4);
                int n2 = dataInputStream.readInt();
                this.supportedSpiVerbs = new Hashtable();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = dataInputStream.readInt();
                    int n5 = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    int n7 = dataInputStream.readInt();
                    int n8 = dataInputStream.readInt();
                    if (n4 != 0) {
                        if (Trace.isOn()) {
                            Trace.trace(2, this, "Verb ID=" + n4 + " maxInOutVer=" + n5 + " maxInVer=" + n6 + " maxOutVer=" + n7 + " flags=" + n8);
                        }
                        Integer n9 = new Integer(n4);
                        VerbInfo verbInfo = new VerbInfo(n5, n6, n7, n8);
                        this.supportedSpiVerbs.put(n9, verbInfo);
                    }
                    ++n3;
                }
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "IOException thrown = " + iOException);
            Trace.exit(this, "spiQuery via exception");
            throw new MQInternalException(2, 2195, 117);
        }
        Trace.exit(this, "spiQuery");
    }

    public final void MQINQ(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQINQ");
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQINQ");
            return;
        }
        if (nArray == null) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(clsName, "MQINQ (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(clsName, "MQINQ (selector array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(clsName, "MQINQ (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(clsName, "MQINQ (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(clsName, "MQINQ (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(clsName, "MQINQ (characters array too small)");
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
            int n6 = 0;
            while (n6 < n3) {
                dataOutputStream.writeInt(nArray[n6]);
                ++n6;
            }
            int n7 = 12 + n3 * 4 + n4 * 4 + n5 + 1;
            byte[] byArray2 = this.comms.buildAPIHeader(n7, 0, 0, n2);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 137;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 153) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQINQ");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            if (pint.x == 2) {
                return;
            }
            dataInputStream.skipBytes(4);
            int n8 = dataInputStream.readInt();
            int n9 = dataInputStream.readInt();
            dataInputStream.skipBytes(n3 * 4);
            int n10 = Math.min(n8, n4);
            int n11 = 0;
            while (n11 < n10) {
                nArray2[n11] = dataInputStream.readInt();
                ++n11;
            }
            if (n10 < n8) {
                pint.x = 1;
                pint2.x = 2022;
            }
            int n12 = Math.min(n9, n5);
            int n13 = 0;
            while (n13 < n12) {
                byArray[n13] = dataInputStream.readByte();
                ++n13;
            }
            if (n12 < n9) {
                pint.x = 1;
                pint2.x = 2008;
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQINQ");
        }
    }

    protected String MQINQ(int n, int n2, int n3, int n4, Pint pint, Pint pint2) {
        Trace.trace(this, "STRANGE: 390/400 version of MQINQ called on client");
        return null;
    }

    public final void MQOPEN(int n, MQOD mQOD, int n2, Pint pint, Pint pint2, Pint pint3) {
        Trace.entry(clsName, "MQOPEN");
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2019;
            return;
        }
        if (mQOD == null) {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2044;
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream = mQOD.writeTo(dataOutputStream);
            dataOutputStream.writeInt(n2);
            byte[] byArray = this.comms.buildAPIHeader(4 + mQOD.sizeOfMQOD(), 0, 0, 0);
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            Pint pint6 = new Pint();
            pint4.x = 131;
            DataInputStream dataInputStream = this.lowLevelComms(pint4, pint5, pint6, byteArrayOutputStream.toByteArray(), byArray);
            if (pint4.x != 147) {
                this.analyseError(dataInputStream, pint4, pint5, pint2, pint3);
                pint.x = -1;
                this.errorCloseComms();
                Trace.exit(clsName, "MQOPEN");
                return;
            }
            dataInputStream.skipBytes(4);
            pint2.x = dataInputStream.readInt();
            pint3.x = dataInputStream.readInt();
            pint.x = dataInputStream.readInt();
            dataInputStream = mQOD.readFrom(dataInputStream);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = -1;
            pint2.x = mQException.completionCode;
            pint3.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(clsName, "MQOPEN");
        }
    }

    public final void MQPUT(int n, int n2, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQPUT");
        MQPutMessageOptions mQPutMessageOptions2 = null;
        if ((mQPutMessageOptions.options & 4) == 0 && (mQPutMessageOptions.options & 2) == 0) {
            Trace.trace(2, clsName, "No SyncPoint action specified- implicit MQPMO_NO_SYNCPOINT...");
            mQPutMessageOptions2 = mQPutMessageOptions;
            mQPutMessageOptions.options |= 4;
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQPUT");
            return;
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(clsName, "MQPUT (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(clsName, "MQPUT (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(clsName, "MQPUT (null message buffer)");
            return;
        }
        if (n3 > this.comms.maxMessageSize) {
            pint.x = 2;
            pint2.x = 2030;
            Trace.exit(clsName, "MQPUT (buffer too large)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(clsName, "MQPUT (buffer too small)");
            return;
        }
        try {
            if (!this.supportsV2Structures(n)) {
                mQMD.setVersion(1);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream = mQMD.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataOutputStream = mQPutMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeInt(n3);
            dataOutputStream.write(byArray, 0, n3);
            int n4 = mQMD.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions() + 4 + n3;
            byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 134;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 150) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQPUT");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream = mQMD.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataInputStream = mQPutMessageOptions.readFrom(dataInputStream);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (mQPutMessageOptions2 != null) {
            Trace.trace(2, clsName, "Restoring old PutMessageOptions...");
            mQPutMessageOptions = mQPutMessageOptions2;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQPUT");
        }
    }

    public final void MQPUT(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQPUT (MQMsg2)");
        MQPutMessageOptions mQPutMessageOptions2 = null;
        if ((mQPutMessageOptions.options & 4) == 0 && (mQPutMessageOptions.options & 2) == 0) {
            Trace.trace(2, clsName, "No SyncPoint action specified - implicit MQPMO_NO_SYNCPOINT...");
            mQPutMessageOptions2 = mQPutMessageOptions;
            mQPutMessageOptions.options |= 4;
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQPUT (MQMsg2)");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(clsName, "MQPUT (MQMsg2) (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(clsName, "MQPUT (MQMsg2) (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(clsName, "MQPUT (MQMsg2) (null message buffer)");
            return;
        }
        if (n3 > this.comms.maxMessageSize) {
            pint.x = 2;
            pint2.x = 2030;
            Trace.exit(clsName, "MQPUT (MQMsg2) (buffer too large)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(clsName, "MQPUT (MQMsg2) (buffer too small)");
            return;
        }
        try {
            if (!this.supportsV2Structures(n)) {
                mQMsg2.setVersion(1);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream = mQMsg2.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataOutputStream = mQPutMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeInt(n3);
            dataOutputStream.write(byArray, 0, n3);
            int n4 = mQMsg2.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions() + 4 + n3;
            byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 134;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 150) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQPUT (MQMsg2)");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream = mQMsg2.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataInputStream = mQPutMessageOptions.readFrom(dataInputStream);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (mQPutMessageOptions2 != null) {
            Trace.trace(2, clsName, "Restoring old PutMessageOptions...");
            mQPutMessageOptions = mQPutMessageOptions2;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQPUT (MQMsg2)");
        }
    }

    public final void MQPUT1(int n, MQOD mQOD, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQPUT1");
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQPUT1");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(clsName, "MQPUT1 (obj descriptor was null)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(clsName, "MQPUT1 (buffer was null)");
            return;
        }
        if (n2 > this.comms.maxMessageSize) {
            pint.x = 2;
            pint2.x = 2030;
            Trace.exit(clsName, "MQPUT1 (buffer too large)");
            return;
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(clsName, "MQPUT1 (msg descriptor was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(clsName, "MQPUT1 (put msg options was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(clsName, "MQPUT1 (buffer too small)");
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream = mQOD.writeTo(dataOutputStream);
            dataOutputStream = mQMD.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataOutputStream = mQPutMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray, 0, n2);
            int n3 = mQOD.sizeOfMQOD() + mQMD.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions() + 4 + n2;
            byte[] byArray2 = this.comms.buildAPIHeader(n3, 0, 0, 0);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 135;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 151) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQPUT1");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream = mQOD.readFrom(dataInputStream);
            dataInputStream = mQMD.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataInputStream = mQPutMessageOptions.readFrom(dataInputStream);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQPUT1");
        }
    }

    public final void MQPUT1(int n, MQOD mQOD, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQPUT1 - MQMsg2");
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQPUT1 - MQMsg2");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(clsName, "MQPUT1 - MQMsg2 (obj descriptor was null)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(clsName, "MQPUT1 - MQMsg2 (buffer was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(clsName, "MQPUT1 (buffer too small)");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(clsName, "MQPUT1 - MQMsg2 (MQMsg2 was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(clsName, "MQPUT1 - MQMsg2 (put msg options was null)");
            return;
        }
        if (n2 > this.comms.maxMessageSize) {
            pint.x = 2;
            pint2.x = 2030;
            Trace.exit(clsName, "MQPUT1 - MQMsg2 (buffer too large)");
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream = mQOD.writeTo(dataOutputStream);
            dataOutputStream = mQMsg2.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataOutputStream = mQPutMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray, 0, n2);
            int n3 = mQOD.sizeOfMQOD() + mQMsg2.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions() + 4 + n2;
            byte[] byArray2 = this.comms.buildAPIHeader(n3, 0, 0, 0);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 135;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 151) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQPUT1 - MQMsg2");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream = mQOD.readFrom(dataInputStream);
            dataInputStream = mQMsg2.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            dataInputStream = mQPutMessageOptions.readFrom(dataInputStream);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQPUT1 - MQMsg2");
        }
    }

    public final void MQSET(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        Trace.entry(clsName, "MQSET");
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "MQSET");
            return;
        }
        if (nArray == null || nArray.length == 0) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(clsName, "MQSET (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(clsName, "MQSET (selectors array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(clsName, "MQSET (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(clsName, "MQSET (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(clsName, "MQSET (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(clsName, "MQSET (character attributes array too small)");
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
            int n6 = 0;
            while (n6 < n3) {
                dataOutputStream.writeInt(nArray[n6]);
                ++n6;
            }
            int n7 = 0;
            while (n7 < n4) {
                dataOutputStream.writeInt(nArray2[n7]);
                ++n7;
            }
            if (n5 > 0) {
                dataOutputStream.write(byArray, 0, n5);
            }
            int n8 = 12 + n3 * 4 + n4 * 4 + n5 + 1;
            byte[] byArray2 = this.comms.buildAPIHeader(n8, 0, 0, n2);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 136;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 152) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "MQSET");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "MQSET");
        }
    }

    protected void MQSET(int n, int n2, int n3, String string, int n4, Pint pint, Pint pint2) {
        Trace.trace(this, "STRANGE: 390/400 version of MQSET called on client");
    }

    public void spiConnect(String string, int n, Pint pint, Pint pint2, Pint pint3) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiConnect");
        }
        this.MQCONNX(string, n, pint, pint2, pint3);
        if (pint2.x != 2 && this.comms.supportsSPI()) {
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            this.spiQuery(pint.x, pint4, pint5);
            if (pint4.x != 0) {
                Trace.trace(2, this, "spiQuery CC=" + pint4.x + " RC=" + pint5.x);
                this.supportedSpiVerbs = null;
            }
        }
        if (Trace.isOn()) {
            Trace.exit(clsName, "spiConnect");
        }
    }

    public boolean spiSupportsDeferred() {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiSupportsDeferred");
        }
        if (!this.deferredChecked) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.supportedSpiVerbs != null) {
                Integer n;
                Integer n2 = new Integer(2);
                VerbInfo verbInfo = (VerbInfo)this.supportedSpiVerbs.get(n2);
                if (verbInfo != null && verbInfo.maxInOutVersion > 0 && verbInfo.maxInVersion > 0 && verbInfo.maxOutVersion > 0 && verbInfo.flags == 1) {
                    bl = true;
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "spiPutSupported: " + bl);
                }
                if ((verbInfo = (VerbInfo)this.supportedSpiVerbs.get(n = new Integer(4))) != null && verbInfo.maxInOutVersion > 0 && verbInfo.maxInVersion > 0 && verbInfo.maxOutVersion > 0 && verbInfo.flags == 1) {
                    bl2 = true;
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "spiActivateSupported: " + bl2);
                }
            }
            this.deferredSupported = bl && bl2;
            this.deferredChecked = true;
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "spiSupportsDeferred returning " + this.deferredSupported);
        }
        return this.deferredSupported;
    }

    public void spiDefPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefPut");
        }
        if (!this.spiSupportsDeferred()) {
            pint.x = 2;
            pint2.x = 2195;
            if (Trace.isOn()) {
                Trace.trace(2, clsName, "spiDefPut not supported");
                Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
                Trace.exit(clsName, "spiDefPut");
            }
            return;
        }
        MQPutMessageOptions mQPutMessageOptions2 = null;
        if ((mQPutMessageOptions.options & 4) == 0 && (mQPutMessageOptions.options & 2) == 0) {
            if (Trace.isOn()) {
                Trace.trace(2, clsName, "No syncpoint action specified- implicit MQPMO_NO_SYNCPOINT");
            }
            mQPutMessageOptions2 = mQPutMessageOptions;
            mQPutMessageOptions.options |= 4;
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "spiDefPut");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(clsName, "spiDefPut (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(clsName, "spiDefPut (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(clsName, "spiDefPut (null message buffer)");
            return;
        }
        if (n3 > this.comms.maxMessageSize) {
            pint.x = 2;
            pint2.x = 2030;
            Trace.exit(clsName, "spiDefPut (buffer too large)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(clsName, "MQPUT (buffer too small)");
            return;
        }
        try {
            if (!this.supportsV2Structures(n)) {
                mQMsg2.setVersion(1);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(20);
            dataOutputStream.writeBytes("SPPU");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(12 + mQMsg2.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions());
            mQMsg2.writeTo(dataOutputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            mQPutMessageOptions.writeTo(dataOutputStream);
            dataOutputStream.writeBytes("SPPI");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(20 + n3);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeInt(n3);
            dataOutputStream.write(byArray, 0, n3);
            int n4 = dataOutputStream.size();
            byte[] byArray2 = this.comms.buildAPIHeader(n4, 0, 0, n2);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 140;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 156) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "spiDefPut");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream.skipBytes(8);
            int n5 = dataInputStream.readInt();
            dataInputStream.skipBytes(8);
            int n6 = dataInputStream.readInt();
            mQMsg2.readFrom(dataInputStream, this.comms.ccsid, this.comms.ccsidIsAscii);
            mQPutMessageOptions.readFrom(dataInputStream);
            int n7 = n6 - (12 + mQMsg2.sizeOfMQMD() + mQPutMessageOptions.sizeOfMQPutMessageOptions());
            if (n7 > 0) {
                dataInputStream.skipBytes(n7);
            }
            if ((n7 = n5 - (12 + n6)) > 0) {
                dataInputStream.skipBytes(n7);
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (mQPutMessageOptions2 != null) {
            Trace.trace(2, clsName, "Restoring old PutMessageOptions");
            mQPutMessageOptions = mQPutMessageOptions2;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefPut");
        }
    }

    public void spiDefActivate(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefActivate");
        }
        this._spiActivate(n, byArray, pint, pint2, 1);
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefActivate");
        }
    }

    public void spiDefCancel(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefCancel");
        }
        this._spiActivate(n, byArray, pint, pint2, 2);
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefCancel");
        }
    }

    public void _spiActivate(int n, byte[] byArray, Pint pint, Pint pint2, int n2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "_spiActivate");
        }
        if (!this.spiSupportsDeferred()) {
            pint.x = 2;
            pint2.x = 2195;
            if (Trace.isOn()) {
                Trace.trace(2, clsName, "Deferred messages not supported");
                Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
                Trace.exit(clsName, "_spiActivate");
            }
            return;
        }
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
            pint.x = 2;
            pint2.x = 2019;
            Trace.exit(clsName, "_spiActivate");
            return;
        }
        if (byArray == null || byArray.length != 24) {
            Trace.trace(1, clsName, "Invalid messageId");
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(clsName, "_spiActivate");
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(12);
            String string = "                                                ";
            dataOutputStream.writeBytes("SPAU");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(12);
            dataOutputStream.writeBytes("SPAI");
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(136);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeBytes(string);
            dataOutputStream.write(byArray, 0, 24);
            int n3 = dataOutputStream.size();
            byte[] byArray2 = this.comms.buildAPIHeader(n3, 0, 0, 0);
            Pint pint3 = new Pint();
            Pint pint4 = new Pint();
            Pint pint5 = new Pint();
            pint3.x = 140;
            DataInputStream dataInputStream = this.lowLevelComms(pint3, pint4, pint5, byteArrayOutputStream.toByteArray(), byArray2);
            if (pint3.x != 156) {
                this.analyseError(dataInputStream, pint3, pint4, pint, pint2);
                this.errorCloseComms();
                Trace.exit(clsName, "_spiActivate");
                return;
            }
            dataInputStream.skipBytes(4);
            pint.x = dataInputStream.readInt();
            pint2.x = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            dataInputStream.skipBytes(8);
            int n4 = dataInputStream.readInt();
            int n5 = n4 - 12;
            if (n5 > 0) {
                dataInputStream.skipBytes(n5);
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, clsName, "IOException occurred");
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (MQException mQException) {
            Trace.trace(1, clsName, "MQException occurred");
            pint.x = mQException.completionCode;
            pint2.x = mQException.reasonCode;
        }
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "_spiActivate");
        }
    }

    public void honourRRSInternal(int n, Pint pint, Pint pint2) {
        Trace.trace(clsName, "WARNING: honourRRSInternal called");
    }

    public final boolean distributionListCapable(int n) {
        Trace.entry(clsName, "distributionListCapable");
        boolean bl = false;
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
        } else {
            bl = this.comms.distListCapable;
        }
        Trace.exit(clsName, "distributionListCapable");
        return bl;
    }

    protected final boolean supportsV2Structures(int n) {
        Trace.entry(clsName, "supportsV2Structures");
        boolean bl = false;
        if (this.comms == null) {
            Trace.trace(1, clsName, "Invalid connection handle: " + n);
        } else {
            bl = this.comms.fapLevel >= 4 && this.comms.distListCapable;
        }
        Trace.exit(clsName, "supportsV2Structures");
        return bl;
    }

    protected final void setThreadAccess(String string) throws MQException {
        Trace.entry(this, "setThreadAccess");
        if (string != null && !string.equals("MULTI_THREAD")) {
            if (string.equals("SINGLE_THREAD")) {
                Trace.trace(2, this, "Single thread access mode not supported.");
                Trace.exit(this, "setThreadAccess (via exception)");
                throw new MQException(2, 2012, this);
            }
            Trace.trace(2, this, "Unknown thread access mode specified");
            Trace.exit(this, "setThreadAccess (via exception)");
            throw new MQException(2, 2012, this);
        }
        Trace.trace(2, this, "Default multi-thread access will be used.");
        Trace.exit(this, "setThreadAccess");
    }

    private final void analyseError(DataInputStream dataInputStream, Pint pint, Pint pint2, Pint pint3, Pint pint4) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "analyseError");
            Trace.trace(clsName, "segment type = " + pint.x);
        }
        pint3.x = 2;
        pint4.x = 2009;
        int n = 0;
        if (pint.x == 5 && (pint2.x & 2) != 0) {
            try {
                if (this.transmissionLength > 28) {
                    dataInputStream.skipBytes(4);
                    n = dataInputStream.readInt();
                } else {
                    n = 22;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Trace.isOn()) {
            Trace.trace(clsName, "Err reason code = " + n);
        }
        if (MQException.log != null) {
            try {
                MQException.log.write("Error occured during API call - reason code" + n + "\n");
            }
            catch (IOException iOException) {
                Trace.trace(1, clsName, "Exception writing to log stream: " + iOException);
            }
        }
        Trace.exit(clsName, "analyseError");
    }

    protected int getConnectionCCSID() {
        return this.comms.ccsid;
    }

    protected int getCharEncoding() {
        if (Trace.isOn()) {
            Trace.trace(clsName, "getCharEncoding(). Client connection so always return ENC_ASCII");
        }
        return 1;
    }

    private class VerbInfo {
        public int maxInOutVersion;
        public int maxInVersion;
        public int maxOutVersion;
        public int flags;
        public static final int SPI_GENERIC_CALL = 1;
        public static final int SPI_SPECIFIC_CALL = 2;

        public VerbInfo(int n, int n2, int n3, int n4) {
            this.maxInOutVersion = n;
            this.maxInVersion = n2;
            this.maxOutVersion = n3;
            this.flags = n4;
        }
    }
}

