/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.io.IOException;

class MQS390PackedDecimalSupport {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQS390PackedDecimalSupport.java, java, j521, j521-L020126  02/01/25 15:52:32";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQS390PackedDecimalSupport";

    MQS390PackedDecimalSupport() {
    }

    protected static final long convertToBinary(byte[] byArray) throws IOException {
        Trace.entry(clsName, "convertToBinary");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(3, clsName, "packedDecimalBytes follow:");
        Trace.dataTrace(3, clsName, byArray);
        long l = 0L;
        long l2 = 1L;
        boolean bl = true;
        int n = byArray.length - 1;
        while (n >= 0) {
            byte by = byArray[n];
            int n2 = by & 0xF;
            int n3 = by >>> 4 & 0xF;
            if (n == byArray.length - 1) {
                switch (n2) {
                    case 12: {
                        bl = true;
                        break;
                    }
                    case 13: {
                        bl = false;
                        break;
                    }
                    case 15: {
                        bl = true;
                        break;
                    }
                    default: {
                        Trace.trace(1, clsName, "Invalid sign nibble: " + n2);
                        Trace.exit(clsName, "convertToBinary (via exception)");
                        throw new IOException("Invalid sign nibble in packed decimal");
                    }
                }
                n2 = n3;
                n3 = 0;
            }
            if (n2 > 9 || n3 > 9) {
                Trace.trace(1, clsName, "Digit outside of range 0..9");
                Trace.exit(clsName, "convertToBinary (via exception)");
                throw new IOException("Packed Decimal digit outside of range 0-9");
            }
            int n4 = n2 + 10 * n3;
            l += l2 * (long)n4;
            l2 = n == byArray.length - 1 ? (l2 *= 10L) : (l2 *= 100L);
            --n;
        }
        if (!bl) {
            l = -l;
        }
        Trace.trace(3, clsName, "Binary value = " + l);
        return l;
    }

    protected static final byte[] convertToPackedDecimal(short s) throws IOException {
        Trace.entry(clsName, "convertToPackedDecimal [short]");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(3, clsName, "Binary value = " + s);
        if (s > 999 || s < -999) {
            Trace.trace(1, clsName, "Outside of range for short packed decimal");
            Trace.exit(clsName, "convertToPackedDecimal (via exception)");
            throw new IOException("Outside of range for short packed decimal (+/-999)");
        }
        byte[] byArray = new byte[2];
        boolean bl = s >= 0;
        int n = Math.abs(s % 10);
        s = (short)(s / 10);
        byte by = bl ? (byte)(n << 4 | 0xC) : (byte)(n << 4 | 0xD);
        byArray[1] = by;
        int n2 = 0;
        while (n2 >= 0) {
            byte by2;
            int n3 = Math.abs(s % 10);
            s = (short)(s / 10);
            int n4 = Math.abs(s % 10);
            s = (short)(s / 10);
            byArray[n2] = by2 = (byte)(n3 | n4 << 4);
            --n2;
        }
        Trace.trace(3, clsName, "Packed Decimal bytes follow:");
        Trace.dataTrace(3, clsName, byArray);
        Trace.exit(clsName, "convertToPackedDecimal");
        return byArray;
    }

    protected static final byte[] convertToPackedDecimal(int n) throws IOException {
        Trace.entry(clsName, "convertToPackedDecimal [int]");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(3, clsName, "Binary value = " + n);
        if (n > 9999999 || n < -9999999) {
            Trace.trace(1, clsName, "Outside of range for integer packed decimal");
            Trace.exit(clsName, "convertToPackedDecimal (via exception)");
            throw new IOException("Outside of range for integer packed decimal (+/-9999999)");
        }
        byte[] byArray = new byte[4];
        boolean bl = n >= 0;
        int n2 = Math.abs(n % 10);
        n /= 10;
        byte by = bl ? (byte)(n2 << 4 | 0xC) : (byte)(n2 << 4 | 0xD);
        byArray[3] = by;
        int n3 = 2;
        while (n3 >= 0) {
            byte by2;
            int n4 = Math.abs(n % 10);
            int n5 = Math.abs((n /= 10) % 10);
            n /= 10;
            byArray[n3] = by2 = (byte)(n4 | n5 << 4);
            --n3;
        }
        Trace.trace(3, clsName, "Packed Decimal bytes follow:");
        Trace.dataTrace(3, clsName, byArray);
        Trace.exit(clsName, "convertToPackedDecimal");
        return byArray;
    }

    protected static final byte[] convertToPackedDecimal(long l) throws IOException {
        Trace.entry(clsName, "convertToPackedDecimal [long]");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(3, clsName, "Binary value = " + l);
        if (l > 999999999999999L || l < -999999999999999L) {
            Trace.trace(1, clsName, "Outside of range for long packed decimal");
            Trace.exit(clsName, "convertToPackedDecimal (via exception)");
            throw new IOException("Outside of range for long packed decimal (0+/-999999999999999)");
        }
        byte[] byArray = new byte[8];
        boolean bl = l >= 0L;
        int n = (int)Math.abs(l % 10L);
        l /= 10L;
        byte by = bl ? (byte)(n << 4 | 0xC) : (byte)(n << 4 | 0xD);
        byArray[7] = by;
        int n2 = 6;
        while (n2 >= 0) {
            byte by2;
            int n3 = (int)Math.abs(l % 10L);
            int n4 = (int)Math.abs((l /= 10L) % 10L);
            l /= 10L;
            byArray[n2] = by2 = (byte)(n3 | n4 << 4);
            --n2;
        }
        Trace.trace(3, clsName, "Packed Decimal bytes follow:");
        Trace.dataTrace(3, clsName, byArray);
        Trace.exit(clsName, "convertToPackedDecimal");
        return byArray;
    }
}

