/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQDistributionList;
import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQProcess;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.Pint;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.XAtoJTA;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XADataSource;

public class MQQueueManager
extends MQManagedObject {
    private static final String sccsid = "common/javabase/com/ibm/mq/MQQueueManager.java, java, j521, j521-L020326 02/03/25 16:24:34 @(#) 1.52.1.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1996, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String clsName = "MQQueueManager";
    private static final int MQOT_Q = 1;
    private static final int MQOT_PROCESS = 3;
    private static final int MQOT_Q_MGR = 5;
    protected static final int MQ_Q_NAME_LENGTH = 48;
    protected static final int MQIA_CODED_CHAR_SET_ID = 2;
    protected static final int MQIA_MAX_MSG_LENGTH = 13;
    protected static final int MQIA_COMMAND_LEVEL = 31;
    protected static final int MQCA_COMMAND_INPUT_Q_NAME = 2003;
    protected static final int MQIA_MAX_PRIORITY = 14;
    protected static final int MQIA_SYNCPOINT = 30;
    private Vector queues;
    private Vector processes;
    private Vector distributionLists;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private MQSESSION osession = null;
    private MQManagedConnectionJ11 mqManCon = null;
    private MQQueueManager copy = null;
    private MQQueueManager original = null;
    private MQException exceptionForDisconnect = null;
    private boolean allowErrorEvents = false;
    private boolean forSPI = false;
    public boolean isConnected = false;
    protected boolean connectStatus = false;

    public Connection getJDBCConnection(XADataSource xADataSource) throws MQException, SQLException, Exception {
        Connection connection;
        try {
            Trace.entry(this, "getJDBCConnection");
            connection = this.getJDBCConnection(xADataSource, null, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Trace.exit(this, "getJDBCConnection");
            throw throwable;
        }
        Trace.exit(this, "getJDBCConnection");
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getJDBCConnection(XADataSource xADataSource, String string, String string2) throws MQException, SQLException, Exception {
        Connection connection;
        try {
            try {
                Trace.entry(this, "getJDBCConnection(u,p)");
                if (!this.connectStatus) {
                    throw new MQException(2, 2018, this, 2);
                }
                if (this.mqManCon.getIntegerProperty("connectOptions", 0) == 1) {
                    throw new MQException(2, 2012, this);
                }
                connection = XAtoJTA.helpGetConnection(xADataSource, string, string2, this.osession);
                Object var8_6 = null;
            }
            catch (SQLException sQLException) {
                Trace.trace(this, "failure, throwing: " + sQLException);
                throw sQLException;
            }
            catch (MQException mQException) {
                Trace.trace(this, "failure, throwing: " + mQException);
                throw mQException;
            }
            catch (Exception exception) {
                Trace.trace(this, "failure, throwing: " + exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Trace.exit(this, "getJDBCConnection(u,p)");
            throw throwable;
        }
        Trace.exit(this, "getJDBCConnection(u,p)");
        return connection;
    }

    public boolean isConnected() {
        return this.connectStatus;
    }

    public int getCharacterSet() throws MQException {
        return this.getInt(2);
    }

    public int getMaximumMessageLength() throws MQException {
        return this.getInt(13);
    }

    public int getCommandLevel() throws MQException {
        return this.getInt(31);
    }

    public String getCommandInputQueueName() throws MQException {
        return this.getString(2003, 48);
    }

    public int getMaximumPriority() throws MQException {
        return this.getInt(14);
    }

    public int getSyncpointAvailability() throws MQException {
        return this.getInt(30);
    }

    public boolean getDistributionListCapable() {
        return this.osession.distributionListCapable(this.Hconn.x);
    }

    public MQQueueManager(String string) throws MQException {
        Trace.entry(this, "MQQueueManager constructor");
        Trace.trace(2, this, sccsid);
        this.construct(string, null, null, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor");
    }

    public MQQueueManager(String string, int n) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (MQCONNX)");
        Trace.trace(2, this, sccsid);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("connectOptions", new Integer(n));
        this.construct(string, hashtable, null, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (MQCONNX)");
    }

    public MQQueueManager(String string, Hashtable hashtable) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,Hashtable)");
        Trace.trace(2, this, sccsid);
        this.construct(string, hashtable, null, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String, Hashtable)");
    }

    public MQQueueManager(String string, MQConnectionManager mQConnectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,MQConnectionManager)");
        Trace.trace(2, this, sccsid);
        this.construct(string, null, mQConnectionManager, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String,MQConnectionManager)");
    }

    public MQQueueManager(String string, int n, MQConnectionManager mQConnectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,int,MQConnectionManager)");
        Trace.trace(2, this, sccsid);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("connectOptions", new Integer(n));
        this.construct(string, hashtable, mQConnectionManager, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String,int,MQConnectionManager)");
    }

    public MQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,Hashtable,MQConnectionManager)");
        Trace.trace(2, this, sccsid);
        this.construct(string, hashtable, mQConnectionManager, null);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String, Hashtable,MQConnectionManager)");
    }

    public MQQueueManager(String string, ConnectionManager connectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,ConnectionManager)");
        Trace.trace(2, this, sccsid);
        this.construct(string, null, null, connectionManager);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String,ConnectionManager)");
    }

    public MQQueueManager(String string, int n, ConnectionManager connectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,int,ConnectionManager)");
        Trace.trace(2, this, sccsid);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("connectOptions", new Integer(n));
        this.construct(string, hashtable, null, connectionManager);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String,int,ConnectionManager)");
    }

    public MQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager) throws MQException {
        Trace.entry(this, "MQQueueManager constructor (String,Hashtable,ConnectionManager)");
        Trace.trace(2, this, sccsid);
        this.construct(string, hashtable, null, connectionManager);
        this.allowErrorEvents = true;
        Trace.exit(this, "MQQueueManager constructor (String,Hashtable,ConnectionManager)");
    }

    private void construct(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager) throws MQException {
        Object object;
        Trace.entry(this, "construct");
        if (mQConnectionManager == null && connectionManager == null) {
            object = MQEnvironment.poolTokenSet;
            synchronized (object) {
                mQConnectionManager = MQEnvironment.defaultMQCxManager;
                connectionManager = MQEnvironment.defaultCxManager;
            }
        }
        if (mQConnectionManager == null && connectionManager != null && connectionManager instanceof MQConnectionManager) {
            mQConnectionManager = (MQConnectionManager)connectionManager;
            connectionManager = null;
        }
        object = null;
        object = mQConnectionManager != null ? MQQueueManager.obtainBaseMQQueueManager(string, hashtable, mQConnectionManager) : MQQueueManager.obtainBaseMQQueueManager(string, hashtable, connectionManager);
        this.initialize((MQQueueManager)object);
        Trace.exit(this, "construct");
    }

    private static MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        MQQueueManager mQQueueManager;
        Object object;
        Trace.entry(clsName, "obtainBaseMQQueueManager (Java 1.1 version");
        String string2 = MQEnvironment.getStringProperty("transport", hashtable);
        if (string2.equals("MQSeries")) {
            object = MQEnvironment.getStringProperty("hostname", hashtable);
            string2 = object == null || ((String)object).equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        object = MQSESSION.getMQManagedConnectionFactory(string2, string, hashtable, true);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string2, hashtable);
        try {
            mQQueueManager = (MQQueueManager)mQConnectionManager.allocateConnection((MQManagedConnectionFactory)object, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        Trace.exit(clsName, "obtainBaseMQQueueManager (Java 1.1 version)");
        return mQQueueManager;
    }

    private static MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager) throws MQException {
        MQQueueManager mQQueueManager;
        String string2;
        Trace.entry(clsName, "obtainBaseMQQueueManager (Java 2 version)");
        String string3 = MQEnvironment.getStringProperty("transport", hashtable);
        if (string3.equals("MQSeries")) {
            string2 = MQEnvironment.getStringProperty("hostname", hashtable);
            string3 = string2 == null || string2.equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        string2 = (ManagedConnectionFactory)MQSESSION.getMQManagedConnectionFactory(string3, string, hashtable, false);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string3, hashtable);
        try {
            mQQueueManager = (MQQueueManager)connectionManager.allocateConnection((ManagedConnectionFactory)string2, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        Trace.exit(clsName, "obtainBaseMQQueueManager (Java 2 version)");
        return mQQueueManager;
    }

    MQQueueManager(MQManagedConnectionJ11 mQManagedConnectionJ11) throws MQException {
        Trace.entry(this, "MQQueueManager constructor - based on MQManagedConnection");
        this.name = this.pszName = mQManagedConnectionJ11.getQmgrName();
        this.queues = new Vector(5);
        this.processes = new Vector(5);
        this.distributionLists = new Vector(5);
        this.mqManCon = mQManagedConnectionJ11;
        this.osession = mQManagedConnectionJ11.getMQSESSION();
        this.Hconn = mQManagedConnectionJ11.getHConn();
        this.isConnected = this.connected = this.mqManCon.isConnected();
        this.connectStatus = this.connected;
        this.connectionReference = this;
        this.parentQmgr = this;
        this.resourceOpen = false;
        this.isOpen = false;
        this.openStatus = false;
        this.forSPI = "SPI_ENABLE".equals(mQManagedConnectionJ11.getStringProperty("SPI"));
        if (this.connected) {
            Trace.trace(2, this, "Opening Qmgr for inquire");
            MQOD mQOD = new MQOD();
            mQOD.ObjectType = 5;
            this.osession.MQOPEN(this.Hconn.x, mQOD, 32, this.Hobj, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                Trace.exit(this, "MQQueueManager constructor (via exception)");
                throw new MQException(this.completionCode.x, this.reason.x, this);
            }
            this.resourceOpen = true;
            this.isOpen = true;
            this.openStatus = true;
        }
        Trace.exit(this, "MQQueueManager constructor");
    }

    private void initialize(MQQueueManager mQQueueManager) {
        Trace.entry(this, "initialize");
        MQQueueManager mQQueueManager2 = mQQueueManager;
        synchronized (mQQueueManager2) {
            this.pszName = mQQueueManager.pszName;
            this.name = mQQueueManager.name;
            this.queues = mQQueueManager.queues;
            this.processes = mQQueueManager.processes;
            this.distributionLists = mQQueueManager.distributionLists;
            this.mqManCon = mQQueueManager.mqManCon;
            this.osession = mQQueueManager.osession;
            this.Hconn = mQQueueManager.Hconn;
            this.Hobj = mQQueueManager.Hobj;
            this.connected = mQQueueManager.connected;
            this.isConnected = mQQueueManager.isConnected;
            this.connectStatus = mQQueueManager.connectStatus;
            this.resourceOpen = mQQueueManager.resourceOpen;
            this.isOpen = mQQueueManager.isOpen;
            this.openStatus = mQQueueManager.openStatus;
            this.forSPI = mQQueueManager.forSPI;
            this.parentQmgr = this;
            this.connectionReference = this;
            this.original = mQQueueManager;
            mQQueueManager.copy = this;
        }
        Trace.exit(this, "initialize");
    }

    public void disconnect() throws MQException {
        Trace.entry(this, "disconnect");
        this.allowErrorEvents = false;
        MQQueueManager mQQueueManager = this;
        synchronized (mQQueueManager) {
            if (!this.connected) {
                Trace.exit(this, "disconnect (already disconnected)");
                return;
            }
            this.cleanup();
        }
        MQQueueManager mQQueueManager2 = this;
        synchronized (mQQueueManager2) {
            if (this.original != null) {
                this.mqManCon.fireConnectionClosedEvent(this.original);
            } else {
                this.mqManCon.fireConnectionClosedEvent(this);
            }
            if (this.exceptionForDisconnect != null) {
                Trace.exit(this, "disconnect (via exception)");
                throw this.exceptionForDisconnect;
            }
        }
        Trace.exit(this, "disconnect");
    }

    public synchronized void commit() throws MQException {
        Trace.entry(this, "commit");
        if (!this.connected) {
            Trace.exit(this, "commit (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        this.osession.MQCMIT(this.Hconn.x, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            Trace.exit(this, "commit (via exception)");
            throw mQException;
        }
        Trace.exit(this, "commit");
    }

    public synchronized void backout() throws MQException {
        Trace.entry(this, "backout");
        if (!this.connected) {
            Trace.exit(this, "backout (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        this.osession.MQBACK(this.Hconn.x, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            Trace.exit(this, "backout (via exception)");
            throw mQException;
        }
        Trace.exit(this, "backout");
    }

    public synchronized void begin() throws MQException {
        Trace.entry(this, "begin");
        if (!this.connected) {
            Trace.exit(this, "begin (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        this.osession.MQBEGIN(this.Hconn.x, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            if (this.reason.x == 2122) {
                this.reason.x = 2195;
                this.completionCode.x = 2;
            }
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            Trace.exit(this, "begin (via exception)");
            throw mQException;
        }
        Trace.exit(this, "begin");
    }

    MQSESSION getSession() {
        return this.osession;
    }

    MQManagedConnectionJ11 getMQManagedConnection() {
        return this.mqManCon;
    }

    public synchronized void put(String string, String string2, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions, String string3) throws MQException {
        Object object;
        Trace.entry(this, "put");
        if (!this.connected) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2018, this);
        }
        MQOD mQOD = new MQOD();
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.AlternateUserId = string3;
        }
        if (mQMessage != null) {
            object = mQMessage.toByteArray();
            this.osession.MQPUT1(this.Hconn.x, mQOD, mQMessage, mQPutMessageOptions, ((byte[])object).length, (byte[])object, this.completionCode, this.reason);
        } else {
            this.osession.MQPUT1(this.Hconn.x, mQOD, (MQMD)null, mQPutMessageOptions, 0, null, this.completionCode, this.reason);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            object = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred((MQException)object);
            Trace.exit(this, "put (via exception)");
            throw object;
        }
        Trace.exit(this, "put");
    }

    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, String string3) throws MQException {
        Trace.entry(this, "putMsg2");
        if (!this.connected) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQException(2, 2018, this);
        }
        MQOD mQOD = new MQOD();
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.AlternateUserId = string3;
        }
        byte[] byArray = null;
        try {
            if (mQMsg2 != null) {
                byArray = mQMsg2.getMessageData(false);
            }
        }
        catch (IOException iOException) {
            Trace.exit(this, "putMsg2 (viaException)");
            MQInternalException mQInternalException = new MQInternalException(2, 2195, 48);
            this.errorOccurred(mQInternalException);
            throw mQInternalException;
        }
        if (mQMsg2 != null) {
            this.osession.MQPUT1(this.Hconn.x, mQOD, mQMsg2, mQPutMessageOptions, byArray.length, byArray, this.completionCode, this.reason);
        } else {
            this.osession.MQPUT1(this.Hconn.x, mQOD, (MQMsg2)null, mQPutMessageOptions, 0, null, this.completionCode, this.reason);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            Trace.exit(this, "putMsg2 (via exception)");
            throw mQException;
        }
        Trace.exit(this, "putMsg2");
    }

    public synchronized void put(String string, String string2, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.put(string, string2, mQMessage, mQPutMessageOptions, "");
    }

    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.putMsg2(string, string2, mQMsg2, mQPutMessageOptions, "");
    }

    public synchronized void put(String string, String string2, MQMessage mQMessage) throws MQException {
        this.put(string, string2, mQMessage, new MQPutMessageOptions(), null);
    }

    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(string, string2, mQMsg2, new MQPutMessageOptions(), null);
    }

    public synchronized void put(String string, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.put(string, "", mQMessage, mQPutMessageOptions, "");
    }

    public synchronized void putMsg2(String string, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.putMsg2(string, "", mQMsg2, mQPutMessageOptions, "");
    }

    public synchronized void put(String string, MQMessage mQMessage) throws MQException {
        this.put(string, "", mQMessage, new MQPutMessageOptions(), null);
    }

    public synchronized void putMsg2(String string, MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(string, "", mQMsg2, new MQPutMessageOptions(), null);
    }

    public synchronized MQQueue accessQueue(String string, int n, String string2, String string3, String string4) throws MQException {
        Trace.entry(this, "accessQueue");
        if (!this.connected) {
            Trace.exit(this, "accessQueue (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        MQOD mQOD = new MQOD();
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.DynamicQName = string3;
        }
        if (string4 != null && string4.length() > 0) {
            mQOD.AlternateUserId = string4;
        }
        MQQueue mQQueue = this.forSPI ? new MQSPIQueue() : new MQQueue();
        mQQueue.Hconn = this.Hconn;
        mQQueue.connected = this.connected;
        if (Trace.isOn()) {
            Trace.trace(2, this, "queue = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\ndynamic queue name = " + mQOD.DynamicQName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession.MQOPEN(mQQueue.Hconn.x, mQOD, n, mQQueue.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            mQQueue.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            Trace.exit(this, "accessQueue (via exception)");
            throw mQException;
        }
        mQQueue.resourceOpen = true;
        mQQueue.mgr = this;
        this.queues.addElement(mQQueue);
        mQQueue.name = mQOD.ObjectName;
        mQQueue.openOptions = n;
        mQQueue.isOpen = true;
        mQQueue.openStatus = true;
        mQQueue.parentQmgr = this;
        mQQueue.connectionReference = this;
        if (string4 != null) {
            mQQueue.alternateUserId = string4;
        }
        mQQueue.mqca_description = 2013;
        if (Trace.isOn()) {
            Trace.trace(2, this, "Opened queue name = " + mQQueue.name);
            Trace.exit(this, "accessQueue");
        }
        return mQQueue;
    }

    public synchronized MQQueue accessQueue(String string, int n) throws MQException {
        return this.accessQueue(string, n, null, null, null);
    }

    public synchronized MQProcess accessProcess(String string, int n, String string2, String string3) throws MQException {
        Trace.entry(this, "accessProcess");
        if (!this.connected) {
            Trace.exit(this, "accessProcess (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        MQOD mQOD = new MQOD();
        mQOD.ObjectType = 3;
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.AlternateUserId = string3;
        }
        MQProcess mQProcess = new MQProcess();
        mQProcess.Hconn = this.Hconn;
        mQProcess.connected = this.connected;
        n |= 0x20;
        if (Trace.isOn()) {
            Trace.trace(2, this, "process = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession.MQOPEN(mQProcess.Hconn.x, mQOD, n, mQProcess.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            mQProcess.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            Trace.exit(this, "accessProcess (via exception)");
            throw mQException;
        }
        mQProcess.resourceOpen = true;
        this.processes.addElement(mQProcess);
        mQProcess.name = string;
        mQProcess.openOptions = n;
        mQProcess.isOpen = true;
        mQProcess.openStatus = true;
        mQProcess.parentQmgr = this;
        mQProcess.connectionReference = this;
        if (string3 != null) {
            mQProcess.alternateUserId = string3;
        }
        mQProcess.mqca_description = 2011;
        Trace.exit(this, "accessProcess");
        return mQProcess;
    }

    public synchronized MQProcess accessProcess(String string, int n) throws MQException {
        return this.accessProcess(string, n, null, null);
    }

    public synchronized MQDistributionList accessDistributionList(MQDistributionListItem[] mQDistributionListItemArray, int n, String string) throws MQException {
        Trace.entry(this, "accessDistributionList");
        MQDistributionList mQDistributionList = new MQDistributionList(this, mQDistributionListItemArray, n, string);
        Trace.exit(this, "accessDistributionList");
        return mQDistributionList;
    }

    public MQDistributionList accessDistributionList(MQDistributionListItem[] mQDistributionListItemArray, int n) throws MQException {
        return this.accessDistributionList(mQDistributionListItemArray, n, null);
    }

    void cleanup() {
        MQManagedObject mQManagedObject;
        int n;
        Vector vector;
        Trace.entry(this, "cleanup");
        if (this.copy != null) {
            MQQueueManager mQQueueManager = this.copy;
            synchronized (mQQueueManager) {
                this.copy.cleanup();
                this.isConnected = false;
                this.connectStatus = false;
                this.connected = false;
                this.isOpen = false;
                this.openStatus = false;
                this.resourceOpen = false;
            }
        }
        try {
            vector = (Vector)this.queues.clone();
            n = 0;
            while (n < vector.size()) {
                mQManagedObject = (MQQueue)vector.elementAt(n);
                if (mQManagedObject.resourceOpen) {
                    ((MQQueue)mQManagedObject).close();
                }
                mQManagedObject.connected = false;
                ++n;
            }
        }
        catch (Exception exception) {
            Trace.trace(2, this, "Queue cleanup() exception " + exception);
        }
        this.queues.removeAllElements();
        Trace.trace(2, this, "All queues closed.");
        try {
            vector = (Vector)this.processes.clone();
            n = 0;
            while (n < vector.size()) {
                mQManagedObject = (MQProcess)vector.elementAt(n);
                if (mQManagedObject.resourceOpen) {
                    ((MQProcess)mQManagedObject).close();
                }
                mQManagedObject.connected = false;
                ++n;
            }
        }
        catch (Exception exception) {
            Trace.trace(2, this, "Process cleanup() exception " + exception);
        }
        this.processes.removeAllElements();
        Trace.trace(2, this, "All processes closed.");
        try {
            vector = (Vector)this.distributionLists.clone();
            n = 0;
            while (n < vector.size()) {
                mQManagedObject = (MQDistributionList)vector.elementAt(n);
                if (mQManagedObject.resourceOpen) {
                    ((MQDistributionList)mQManagedObject).close();
                }
                mQManagedObject.connected = false;
                ++n;
            }
        }
        catch (Exception exception) {
            Trace.trace(2, this, "Distribution List cleanup() exception " + exception);
        }
        this.distributionLists.removeAllElements();
        Trace.trace(2, this, "All distribution lists closed.");
        try {
            this.close();
        }
        catch (MQException mQException) {
            Trace.trace(1, this, "Exception during close, proceeding anyway.");
        }
        this.isConnected = false;
        this.connectStatus = false;
        this.connected = false;
        this.connectionReference = null;
        Trace.exit(this, "cleanup");
    }

    protected final void registerQueue(MQQueue mQQueue) {
        this.queues.addElement(mQQueue);
    }

    protected final void registerProcess(MQProcess mQProcess) {
        this.processes.addElement(mQProcess);
    }

    protected final void registerDistributionList(MQDistributionList mQDistributionList) {
        this.distributionLists.addElement(mQDistributionList);
    }

    protected final void unregisterQueue(MQQueue mQQueue) {
        this.queues.removeElement(mQQueue);
    }

    protected final void unregisterProcess(MQProcess mQProcess) {
        this.processes.removeElement(mQProcess);
    }

    protected final void unregisterDistributionList(MQDistributionList mQDistributionList) {
        this.distributionLists.removeElement(mQDistributionList);
    }

    protected final boolean supportsV2Structures() {
        return this.osession.supportsV2Structures(this.Hconn.x);
    }

    void errorOccurred(MQException mQException) {
        Trace.entry(this, "errorOccurred");
        if (this.allowErrorEvents && mQException.completionCode == 2) {
            int n = ReasonCodeInfo.getReasonCodeCategory(mQException.reasonCode);
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    this.mqManCon.setNotReusable();
                    if (this.original != null) {
                        this.mqManCon.fireConnectionErrorEvent(this.original, mQException);
                        break;
                    }
                    this.mqManCon.fireConnectionErrorEvent(this, mQException);
                    break;
                }
                default: {
                    Trace.trace(2, this, "Bad Reason Code Category encountered");
                    this.mqManCon.setNotReusable();
                    if (this.original != null) {
                        this.mqManCon.fireConnectionErrorEvent(this.original, mQException);
                        break;
                    }
                    this.mqManCon.fireConnectionErrorEvent(this, mQException);
                }
            }
        }
        Trace.exit(this, "errorOccurred");
    }

    void setExceptionForDisconnect(MQException mQException) {
        this.exceptionForDisconnect = mQException;
        if (this.copy != null) {
            this.copy.exceptionForDisconnect = mQException;
        }
    }

    synchronized void honourRRS() throws MQException {
        Trace.entry(this, "honourRRS");
        this.mqManCon.setNotReusable();
        this.osession.honourRRS(this.Hconn.x, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            Trace.exit(this, "honourRRS (via exception)");
            throw mQException;
        }
    }

    protected void finalize() {
        this.allowErrorEvents = false;
        if (this.connected) {
            this.cleanup();
        }
    }

    public int _getConnectionCCSID() {
        return this.osession.getConnectionCCSID();
    }
}

