/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQQueue
extends MQManagedObject {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQQueue.java, java, j521, j521-L020703  02/07/02 11:42:24";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    protected MQQueueManager mgr = null;
    protected MQSESSION osession = null;
    private int DefaultMsgLength = 4096;
    private GregorianCalendar putCalendar = null;
    private static final int MQCA_CREATION_DATE = 2004;
    private static final int MQ_CREATION_DATE_LENGTH = 12;
    private static final int MQCA_CREATION_TIME = 2005;
    private static final int MQ_CREATION_TIME_LENGTH = 8;
    private static final int MQIA_CURRENT_Q_DEPTH = 3;
    private static final int MQIA_DEFINITION_TYPE = 7;
    private static final int MQIA_Q_TYPE = 20;
    private static final int MQIA_MAX_Q_DEPTH = 15;
    private static final int MQIA_MAX_MSG_LENGTH = 13;
    private static final int MQIA_OPEN_INPUT_COUNT = 17;
    private static final int MQIA_OPEN_OUTPUT_COUNT = 18;
    private static final int MQIA_SHAREABILITY = 23;
    private static final int MQIA_INHIBIT_PUT = 10;
    private static final int MQIA_INHIBIT_GET = 9;
    private static final int MQIA_TRIGGER_CONTROL = 24;
    private static final int MQCA_TRIGGER_DATA = 2023;
    private static final int MQ_TRIGGER_DATA_LENGTH = 64;
    private static final int MQIA_TRIGGER_DEPTH = 29;
    private static final int MQIA_TRIGGER_MSG_PRIORITY = 26;
    private static final int MQIA_TRIGGER_TYPE = 28;
    private static final byte[] MQMI_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected MQQueue() {
        Trace.entry(this, "MQQueue default constructor");
        Trace.trace(2, this, sccsid);
        Trace.exit(this, "MQQueue default constructor");
    }

    public MQQueue(MQQueueManager mQQueueManager, String string, int n, String string2, String string3, String string4) throws MQException {
        Trace.entry(this, "MQQueue public constructor");
        Trace.trace(2, this, sccsid);
        if (mQQueueManager == null) {
            Trace.exit(this, "MQQueue constructor (via exception)");
            throw new MQException(2, 2018, this, 1);
        }
        if (!mQQueueManager.connected) {
            Trace.exit(this, "MQQueue public constructor (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        MQOD mQOD = new MQOD();
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.DynamicQName = string3;
        }
        if (string4 != null && string4.length() > 0) {
            mQOD.AlternateUserId = string4;
        }
        this.Hconn = mQQueueManager.Hconn;
        this.connected = mQQueueManager.connected;
        if (Trace.isOn()) {
            Trace.trace(2, this, "queue = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\ndynamic queue name = " + mQOD.DynamicQName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession = mQQueueManager.getSession();
        this.osession.MQOPEN(this.Hconn.x, mQOD, n, this.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            this.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            mQQueueManager.errorOccurred(mQException);
            Trace.exit(this, "MQQueue public constructor (via exception)");
            throw mQException;
        }
        this.resourceOpen = true;
        this.mgr = mQQueueManager;
        this.name = mQOD.ObjectName;
        this.openOptions = n;
        this.isOpen = true;
        this.openStatus = true;
        this.parentQmgr = mQQueueManager;
        this.connectionReference = mQQueueManager;
        if (string4 != null) {
            this.alternateUserId = string4;
        }
        this.mqca_description = 2013;
        mQQueueManager.registerQueue(this);
        Trace.exit(this, "MQQueue public constructor");
    }

    public synchronized void get(MQMessage mQMessage, MQGetMessageOptions mQGetMessageOptions, int n) throws MQException {
        Trace.entry(this, "get (with max size)");
        Trace.trace(2, this, "Max msg size = " + n);
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        if (mQMessage == null) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2026, this, 27);
        }
        if (n <= 0) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2005, this);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2186, this, 28);
        }
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if ((n2 = mQGetMessageOptions.matchOptions) == 0 || n2 == 1) {
            byArray2 = mQMessage.correlationId;
            mQMessage.correlationId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMessage.messageId;
            mQMessage.messageId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 1;
        }
        MQMessage mQMessage2 = mQMessage;
        Pint pint = new Pint();
        byte[] byArray3 = new byte[n];
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2019, this, 29);
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, byArray3.length, byArray3, pint, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
        }
        if (pint.x <= 0) {
            Trace.exit(this, "get (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMessage.messageId = byArray;
            }
            if (byArray2 != null) {
                mQMessage.correlationId = byArray2;
            }
        }
        mQMessage.setMessageData(byArray3, Math.min(byArray3.length, pint.x), pint.x);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "get (via exception)");
            throw mQException;
        }
        Trace.exit(this, "get");
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n) throws MQException {
        Trace.entry(this, "getMsg2 (with max size)");
        Trace.trace(2, this, "Max msg size = " + n);
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        if (mQMsg2 == null) {
            Trace.exit(this, "getMsg2 (via exception)");
            throw new MQException(2, 2026, this, 27);
        }
        if (n <= 0) {
            Trace.exit(this, "getMsg2 (via exception)");
            throw new MQException(2, 2005, this);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "getMsg2 (via exception)");
            throw new MQException(2, 2186, this, 28);
        }
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if ((n2 = mQGetMessageOptions.matchOptions) == 0 || n2 == 1) {
            byArray2 = mQMsg2.getCorrelationId();
            mQMsg2.setCorrelationId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMsg2.getMessageId();
            mQMsg2.setMessageId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 1;
        }
        Pint pint = new Pint();
        byte[] byArray3 = new byte[n];
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "getMsg2 (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "getMsg2 (via exception)");
            throw new MQException(2, 2019, this, 29);
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray3.length, byArray3, pint, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
        }
        if (pint.x <= 0) {
            Trace.exit(this, "getMsg2 (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMsg2.setMessageId(byArray);
            }
            if (byArray2 != null) {
                mQMsg2.setCorrelationId(byArray2);
            }
        }
        mQMsg2.setMessageData(byArray3, Math.min(byArray3.length, pint.x));
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "getMsg2 (via exception)");
            throw mQException;
        }
        Trace.exit(this, "getMsg2");
    }

    public synchronized void get(MQMessage mQMessage, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        Trace.entry(this, "get (no size specified)");
        if (mQMessage == null) {
            Trace.exit(this, "get");
            throw new MQException(2, 2026, this, 27);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "get");
            throw new MQException(2, 2186, this, 28);
        }
        MQMessage mQMessage2 = mQMessage;
        Pint pint = new Pint();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 0;
        n = mQGetMessageOptions.matchOptions;
        if (n == 0 || n == 1) {
            byArray2 = mQMessage.correlationId;
            mQMessage.correlationId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n == 0 || n == 2) {
            byArray = mQMessage.messageId;
            mQMessage.messageId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 1;
        }
        int n2 = mQMessage.encoding;
        int n3 = mQMessage.characterSet;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        if (mQMessage.messageId != null) {
            byArray3 = new byte[mQMessage.messageId.length];
            System.arraycopy(mQMessage.messageId, 0, byArray3, 0, mQMessage.messageId.length);
        } else {
            Trace.trace(this, "Saved NullPointerException on message.messageId");
        }
        if (mQMessage.correlationId != null) {
            byArray4 = new byte[mQMessage.correlationId.length];
            System.arraycopy(mQMessage.correlationId, 0, byArray4, 0, mQMessage.correlationId.length);
        } else {
            Trace.trace(this, "Saved NullPointerException on message.correlationId");
        }
        if (mQMessage.getBufferSizeHint() != -1) {
            this.DefaultMsgLength = mQMessage.getBufferSizeHint();
        }
        byte[] byArray5 = new byte[this.DefaultMsgLength];
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "get");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "get");
            throw new MQException(2, 2019, this, 29);
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
        }
        while (this.completionCode.x != 0 && this.reason.x == 2080) {
            Trace.trace(1, this, "Retrying MQGET with increased buffer size.");
            this.DefaultMsgLength = pint.x;
            byArray5 = new byte[this.DefaultMsgLength];
            mQMessage2.encoding = n2;
            mQMessage2.characterSet = n3;
            mQMessage2.messageId = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, mQMessage2.messageId, 0, byArray3.length);
            mQMessage2.correlationId = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, mQMessage2.correlationId, 0, byArray4.length);
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        }
        if (pint.x <= 0) {
            Trace.exit(this, "get (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMessage.messageId = byArray;
            }
            if (byArray2 != null) {
                mQMessage.correlationId = byArray2;
            }
        }
        mQMessage.setMessageData(byArray5, Math.min(byArray5.length, pint.x), pint.x);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "get (via exception)");
            throw mQException;
        }
        Trace.exit(this, "get");
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        Trace.entry(this, "getMsg2 (no size specified)");
        if (mQMsg2 == null) {
            Trace.exit(this, "getMsg2");
            throw new MQException(2, 2026, this, 27);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "getMsg2");
            throw new MQException(2, 2186, this, 28);
        }
        Pint pint = new Pint();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 0;
        n = mQGetMessageOptions.matchOptions;
        if (n == 0 || n == 1) {
            byArray2 = mQMsg2.getCorrelationId();
            mQMsg2.setCorrelationId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n == 0 || n == 2) {
            byArray = mQMsg2.getMessageId();
            mQMsg2.setMessageId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 1;
        }
        int n2 = mQMsg2.getEncoding();
        int n3 = mQMsg2.getCharacterSet();
        byte[] byArray3 = mQMsg2.getMessageId();
        byte[] byArray4 = mQMsg2.getCorrelationId();
        byte[] byArray5 = new byte[this.DefaultMsgLength];
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "getMsg2");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "getMsg2");
            throw new MQException(2, 2019, this, 29);
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
        }
        while (this.completionCode.x != 0 && this.reason.x == 2080) {
            Trace.trace(1, this, "Retrying MQGET with increased buffer size.");
            this.DefaultMsgLength = pint.x;
            byArray5 = new byte[this.DefaultMsgLength];
            mQMsg2.setEncoding(n2);
            mQMsg2.setCharacterSet(n3);
            mQMsg2.setMessageId(byArray3);
            mQMsg2.setCorrelationId(byArray4);
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        }
        if (pint.x <= 0) {
            Trace.exit(this, "getMsg2 (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMsg2.setMessageId(byArray);
            }
            if (byArray2 != null) {
                mQMsg2.setCorrelationId(byArray2);
            }
        }
        mQMsg2.setMessageData(byArray5, Math.min(byArray5.length, pint.x));
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "getMsg2 (via exception)");
            throw mQException;
        }
        Trace.exit(this, "getMsg2");
    }

    public synchronized void get(MQMessage mQMessage) throws MQException {
        this.get(mQMessage, new MQGetMessageOptions());
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2) throws MQException {
        this.getMsg2(mQMsg2, new MQGetMessageOptions());
    }

    public synchronized void put(MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        Object object;
        Trace.entry(this, "put");
        MQMessage mQMessage2 = mQMessage;
        if (mQMessage == null) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2026, this, 30);
        }
        if (mQPutMessageOptions == null) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2173, this, 31);
        }
        mQPutMessageOptions.invalidDestCount = 1;
        mQPutMessageOptions.knownDestCount = 0;
        mQPutMessageOptions.unknownDestCount = 0;
        if ((mQPutMessageOptions.options & 6) == 0) {
            mQPutMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2019, this, 29);
        }
        if ((mQPutMessageOptions.options & 0x300) != 0) {
            if (mQPutMessageOptions.contextReference != null) {
                mQPutMessageOptions.contextReferenceHandle = mQPutMessageOptions.contextReference.getHandle();
                if (mQPutMessageOptions.contextReferenceHandle == -1) {
                    Trace.exit(this, "put (via exception)");
                    throw new MQException(2, 2097, this);
                }
                if (this.mgr != mQPutMessageOptions.contextReference.mgr) {
                    Trace.trace(2, this, "Connection references do not match");
                    Trace.exit(this, "put (via exception)");
                    throw new MQException(2, 2097, this);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Obtained context reference handle:" + mQPutMessageOptions.contextReferenceHandle);
                }
            } else {
                Trace.trace(2, this, "Context reference queue is null");
                Trace.exit(this, "put (via exception)");
                throw new MQException(2, 2097, this);
            }
        }
        if ((mQPutMessageOptions.options & 0x800) != 0) {
            if (mQMessage2.putDateTime == null) {
                mQMessage2.putDate = MQMD.getDate(null);
                mQMessage2.putTime = MQMD.getTime(null);
            } else {
                if (this.putCalendar == null) {
                    object = TimeZone.getTimeZone("GMT");
                    this.putCalendar = new GregorianCalendar((TimeZone)object);
                }
                this.putCalendar.setTime(mQMessage2.putDateTime.getTime());
                mQMessage2.putDate = MQMD.getDate(this.putCalendar);
                mQMessage2.putTime = MQMD.getTime(this.putCalendar);
            }
        }
        object = mQMessage.toByteArray();
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message length = " + ((byte[])object).length + " bytes.");
            Trace.trace(3, this, "put options = " + mQPutMessageOptions.options + "\nmessage type = " + mQMessage.messageType + "\nencoding = " + mQMessage.encoding + "\ncharacter set = " + mQMessage.characterSet + "\nformat = " + mQMessage.format + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQPUT(this.Hconn.x, this.Hobj.x, mQMessage2, mQPutMessageOptions, ((byte[])object).length, (byte[])object, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(3, this, "Returned message id follows:");
            Trace.dataTrace(3, this, mQMessage.messageId);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "put (via exception)");
            throw mQException;
        }
        Trace.exit(this, "put");
    }

    public synchronized void put(MQMessage mQMessage) throws MQException {
        this.put(mQMessage, new MQPutMessageOptions());
    }

    public synchronized void putMsg2(MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        Trace.entry(this, "putMsg2");
        if (mQMsg2 == null) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQException(2, 2026, this, 30);
        }
        if (mQPutMessageOptions == null) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQException(2, 2173, this, 31);
        }
        mQPutMessageOptions.invalidDestCount = 1;
        mQPutMessageOptions.knownDestCount = 0;
        mQPutMessageOptions.unknownDestCount = 0;
        if ((mQPutMessageOptions.options & 6) == 0) {
            mQPutMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQException(2, 2018, this, 2);
        }
        if (!this.resourceOpen) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQException(2, 2019, this, 29);
        }
        if ((mQPutMessageOptions.options & 0x300) != 0) {
            if (mQPutMessageOptions.contextReference != null) {
                mQPutMessageOptions.contextReferenceHandle = mQPutMessageOptions.contextReference.getHandle();
                if (mQPutMessageOptions.contextReferenceHandle == -1) {
                    Trace.exit(this, "putMsg2 (via exception)");
                    throw new MQException(2, 2097, this);
                }
                if (this.mgr != mQPutMessageOptions.contextReference.mgr) {
                    Trace.trace(2, this, "Connection references do not match");
                    Trace.exit(this, "putMsg2 (via exception)");
                    throw new MQException(2, 2097, this);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Obtained context reference handle:" + mQPutMessageOptions.contextReferenceHandle);
                }
            } else {
                Trace.trace(2, this, "Context reference queue is null");
                Trace.exit(this, "putMsg2 (via exception)");
                throw new MQException(2, 2097, this);
            }
        }
        byte[] byArray = null;
        try {
            byArray = mQMsg2.getMessageData(false);
        }
        catch (IOException iOException) {
            Trace.exit(this, "putMsg2 (via exception)");
            throw new MQInternalException(2, 2195, 48);
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message length = " + byArray.length + " bytes.");
            Trace.trace(3, this, "put options = " + mQPutMessageOptions.options + "\nmessage type = " + mQMsg2.getMessageType() + "\nencoding = " + mQMsg2.getEncoding() + "\ncharacter set = " + mQMsg2.getCharacterSet() + "\nformat = " + mQMsg2.getFormat() + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQPUT(this.Hconn.x, this.Hobj.x, mQMsg2, mQPutMessageOptions, byArray.length, byArray, this.completionCode, this.reason);
        if (Trace.isOn()) {
            Trace.trace(3, this, "Returned message id follows:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "putMsg2 (via exception)");
            throw mQException;
        }
        Trace.exit(this, "putMsg2");
    }

    public synchronized void putMsg2(MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(mQMsg2, new MQPutMessageOptions());
    }

    public synchronized void close() throws MQException {
        Trace.entry(this, "close");
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterQueue(this);
        }
        this.mgr = null;
        this.connectionReference = null;
        Trace.exit(this, "close");
    }

    public GregorianCalendar getCreationDateTime() throws MQException {
        Trace.entry(this, "getCreationDateTime");
        String string = this.getString(2004, 12);
        String string2 = this.getString(2005, 8);
        if (Trace.isOn()) {
            Trace.trace(2, this, "date = " + string + " time = " + string2);
        }
        GregorianCalendar gregorianCalendar = MQSESSION.getInquireCalendar();
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(5, 7));
            int n3 = Integer.parseInt(string.substring(8, 10));
            int n4 = Integer.parseInt(string2.substring(0, 2));
            int n5 = Integer.parseInt(string2.substring(3, 5));
            int n6 = Integer.parseInt(string2.substring(6, 8));
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Trace.trace(1, this, "String index error" + stringIndexOutOfBoundsException);
            gregorianCalendar = new GregorianCalendar();
        }
        catch (NumberFormatException numberFormatException) {
            Trace.trace(1, this, "Number format error" + numberFormatException);
            gregorianCalendar = new GregorianCalendar();
        }
        Trace.exit(this, "getCreationDateTime");
        return gregorianCalendar;
    }

    public int getQueueType() throws MQException {
        return this.getInt(20);
    }

    public int getCurrentDepth() throws MQException {
        return this.getInt(3);
    }

    public int getDefinitionType() throws MQException {
        return this.getInt(7);
    }

    public int getMaximumDepth() throws MQException {
        return this.getInt(15);
    }

    public int getMaximumMessageLength() throws MQException {
        return this.getInt(13);
    }

    public int getOpenInputCount() throws MQException {
        return this.getInt(17);
    }

    public int getOpenOutputCount() throws MQException {
        return this.getInt(18);
    }

    public int getShareability() throws MQException {
        return this.getInt(23);
    }

    public int getInhibitPut() throws MQException {
        return this.getInt(10);
    }

    public void setInhibitPut(int n) throws MQException {
        this.setInt(10, n);
    }

    public int getInhibitGet() throws MQException {
        return this.getInt(9);
    }

    public void setInhibitGet(int n) throws MQException {
        this.setInt(9, n);
    }

    public int getTriggerControl() throws MQException {
        return this.getInt(24);
    }

    public void setTriggerControl(int n) throws MQException {
        this.setInt(24, n);
    }

    public String getTriggerData() throws MQException {
        return this.getString(2023, 64);
    }

    public void setTriggerData(String string) throws MQException {
        this.setString(2023, string, 64);
    }

    public int getTriggerDepth() throws MQException {
        return this.getInt(29);
    }

    public void setTriggerDepth(int n) throws MQException {
        this.setInt(29, n);
    }

    public int getTriggerMessagePriority() throws MQException {
        return this.getInt(26);
    }

    public void setTriggerMessagePriority(int n) throws MQException {
        this.setInt(26, n);
    }

    public int getTriggerType() throws MQException {
        return this.getInt(28);
    }

    public void setTriggerType(int n) throws MQException {
        this.setInt(28, n);
    }

    final int getHandle() {
        if (!this.resourceOpen) {
            return -1;
        }
        return this.Hobj.x;
    }

    public final int _getConnectionCCSID() {
        if (this.osession == null) {
            this.osession = this.mgr.getSession();
        }
        return this.osession.getConnectionCCSID();
    }
}

