/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQPoolServicesEvent;
import com.ibm.mq.MQPoolServicesEventListener;
import com.ibm.mq.MQPoolToken;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Vector;

public final class MQPoolServices {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQPoolServices.java, java, j521, j521-L020126  02/01/25 14:57:35";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector listeners = new Vector();

    public void addMQPoolServicesEventListener(MQPoolServicesEventListener mQPoolServicesEventListener) {
        Trace.entry(this, "addMQPoolServicesEventListener");
        if (mQPoolServicesEventListener == null) {
            Trace.exit(this, "addMQPoolServicesEventListener (via exception)");
            throw new NullPointerException();
        }
        if (this.listeners.isEmpty()) {
            MQEnvironment.registerPoolServices(this);
        }
        this.listeners.addElement(mQPoolServicesEventListener);
        Trace.exit(this, "addMQPoolServicesEventListener");
    }

    public void removeMQPoolServicesEventListener(MQPoolServicesEventListener mQPoolServicesEventListener) {
        Trace.entry(this, "removeMQPoolServicesEventListener");
        if (mQPoolServicesEventListener == null) {
            Trace.exit(this, "addMQPoolServicesEventListener (via exception)");
            throw new NullPointerException();
        }
        this.listeners.removeElement(mQPoolServicesEventListener);
        if (this.listeners.isEmpty()) {
            MQEnvironment.deregisterPoolServices(this);
        }
        Trace.exit(this, "addMQPoolServicesEventListener");
    }

    public int getTokenCount() {
        return MQEnvironment.poolTokenSet.size();
    }

    void fireTokenAdded(MQPoolToken mQPoolToken) {
        Trace.entry(this, "fireTokenAdded");
        MQPoolServicesEvent mQPoolServicesEvent = new MQPoolServicesEvent(this, 0, mQPoolToken);
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServicesEventListener mQPoolServicesEventListener = (MQPoolServicesEventListener)enumeration.nextElement();
            mQPoolServicesEventListener.tokenAdded(mQPoolServicesEvent);
        }
        Trace.exit(this, "fireTokenAdded");
    }

    void fireTokenRemoved(MQPoolToken mQPoolToken) {
        Trace.entry(this, "fireTokenRemoved");
        MQPoolServicesEvent mQPoolServicesEvent = new MQPoolServicesEvent(this, 1, mQPoolToken);
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServicesEventListener mQPoolServicesEventListener = (MQPoolServicesEventListener)enumeration.nextElement();
            mQPoolServicesEventListener.tokenRemoved(mQPoolServicesEvent);
        }
        Trace.exit(this, "fireTokenRemoved");
    }

    void fireDefaultConnectionManagerChanged() {
        Trace.entry(this, "fireDefaultConnectionManagerChanged");
        MQPoolServicesEvent mQPoolServicesEvent = new MQPoolServicesEvent(this, 2);
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServicesEventListener mQPoolServicesEventListener = (MQPoolServicesEventListener)enumeration.nextElement();
            mQPoolServicesEventListener.defaultConnectionManagerChanged(mQPoolServicesEvent);
        }
        Trace.exit(this, "fireDefaultConnectionManagerChanged");
    }
}

