/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQObjectRecord;
import com.ibm.mq.MQResponseRecord;
import com.ibm.mq.MQSESSION;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MQOD {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQOD.java, java, j521, j521-L020126  02/01/25 15:51:00";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int StrucId = 1329864736;
    protected int Version = 1;
    public int ObjectType = 1;
    public String ObjectName = "";
    public String ObjectQMgrName = "";
    public String DynamicQName = MQSESSION.getProductPrefix() + ".*";
    public String AlternateUserId = "";
    protected static final int sizeOfMQODv1 = 168;
    protected static final int sizeOfMQODv2 = 200;
    protected MQObjectRecord[] objectRecords = null;
    protected MQResponseRecord[] responseRecords = null;
    private MQDistributionListItem[] ditems = null;
    protected int KnownDestCount = 0;
    protected int UnknownDestCount = 0;
    protected int InvalidDestCount = 0;

    public MQOD() {
        Trace.entry(this, "MQOD constructor");
        Trace.trace(2, this, sccsid);
        this.Version = 1;
        Trace.exit(this, "MQOD constructor");
    }

    protected MQOD(MQDistributionListItem[] mQDistributionListItemArray) {
        Trace.entry(this, "MQOD v2 constructor");
        Trace.trace(2, this, sccsid);
        this.Version = 2;
        this.ditems = mQDistributionListItemArray;
        this.objectRecords = new MQObjectRecord[mQDistributionListItemArray.length];
        this.responseRecords = new MQResponseRecord[mQDistributionListItemArray.length];
        int n = 0;
        while (n < mQDistributionListItemArray.length) {
            this.objectRecords[n] = new MQObjectRecord();
            this.objectRecords[n].objectQMgrName = mQDistributionListItemArray[n].queueManagerName;
            this.objectRecords[n].objectName = mQDistributionListItemArray[n].queueName;
            this.responseRecords[n] = new MQResponseRecord();
            ++n;
        }
        Trace.exit(this, "MQOD constructor");
    }

    protected final int sizeOfMQOD() {
        if (this.Version == 1) {
            return 168;
        }
        int n = 0;
        if (this.objectRecords != null) {
            n += this.objectRecords.length * (MQObjectRecord.sizeOfMQObjectRecord + MQResponseRecord.sizeOfMQResponseRecord);
        }
        return 200 + n;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream) throws IOException, MQException {
        Trace.entry(this, "writeTo");
        dataOutputStream.writeBytes("OD  ");
        dataOutputStream.writeInt(this.Version);
        dataOutputStream.writeInt(this.ObjectType);
        String string = MQSESSION.setStringToLength(this.ObjectName, 48);
        dataOutputStream.writeBytes(string);
        String string2 = MQSESSION.setStringToLength(this.ObjectQMgrName, 48);
        dataOutputStream.writeBytes(string2);
        String string3 = MQSESSION.setStringToLength(this.DynamicQName, 48);
        dataOutputStream.writeBytes(string3);
        String string4 = MQSESSION.setStringToLength(this.AlternateUserId, 12);
        dataOutputStream.writeBytes(string4);
        if (this.Version > 1) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.objectRecords != null) {
                n = this.objectRecords.length;
                n2 = 200;
                n3 = n2 + n * MQObjectRecord.sizeOfMQObjectRecord;
            }
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            if (n > 0) {
                if (this.responseRecords == null || this.responseRecords.length != this.objectRecords.length) {
                    Trace.exit(this, "writeTo (via exception");
                    throw new MQInternalException(2, 2154, 24);
                }
                int n4 = 0;
                while (n4 < n) {
                    dataOutputStream = this.objectRecords[n4].writeTo(dataOutputStream);
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n) {
                    dataOutputStream = this.responseRecords[n5].writeTo(dataOutputStream);
                    ++n5;
                }
            }
        }
        Trace.exit(this, "writeTo");
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream) throws IOException, MQException {
        Trace.entry(this, "readFrom");
        if (dataInputStream.available() < 168) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 84);
        }
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray, 0, 4);
        String string = MQEnvironment.stringFromBytes(byArray);
        if (!string.equals("OD  ")) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 83, string);
        }
        this.Version = dataInputStream.readInt();
        this.ObjectType = dataInputStream.readInt();
        byte[] byArray2 = new byte[48];
        dataInputStream.read(byArray2, 0, 48);
        this.ObjectName = MQEnvironment.stringFromBytes(byArray2);
        byte[] byArray3 = new byte[48];
        dataInputStream.read(byArray3, 0, 48);
        this.ObjectQMgrName = MQEnvironment.stringFromBytes(byArray3);
        byte[] byArray4 = new byte[48];
        dataInputStream.read(byArray4, 0, 48);
        this.DynamicQName = MQEnvironment.stringFromBytes(byArray4);
        byte[] byArray5 = new byte[12];
        dataInputStream.read(byArray5, 0, 12);
        this.AlternateUserId = MQEnvironment.stringFromBytes(byArray5);
        if (this.Version > 1) {
            int n;
            int n2 = dataInputStream.readInt();
            this.KnownDestCount = dataInputStream.readInt();
            this.UnknownDestCount = dataInputStream.readInt();
            this.InvalidDestCount = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            if (n2 > 0) {
                if (this.objectRecords == null || this.responseRecords == null || this.objectRecords.length != n2 || this.responseRecords.length != n2) {
                    Trace.exit(this, "readFrom (via exception)");
                    throw new MQInternalException(2, 2154, 100);
                }
                n = 0;
                while (n < n2) {
                    dataInputStream = this.objectRecords[n].readFrom(dataInputStream);
                    ++n;
                }
                int n3 = 0;
                while (n3 < n2) {
                    dataInputStream = this.responseRecords[n3].readFrom(dataInputStream);
                    ++n3;
                }
            }
            if (this.ditems != null) {
                n = 0;
                while (n < this.ditems.length) {
                    this.ditems[n].queueManagerName = this.objectRecords[n].objectQMgrName;
                    this.ditems[n].queueName = this.objectRecords[n].objectName;
                    this.ditems[n].completionCode = this.responseRecords[n].completionCode;
                    this.ditems[n].reasonCode = this.responseRecords[n].reason;
                    ++n;
                }
            }
        }
        Trace.exit(this, "readFrom");
        return dataInputStream;
    }

    protected int GetNumberofRecords() {
        int n = 0;
        if (this.objectRecords != null) {
            n = this.objectRecords.length;
        }
        return n;
    }

    public void updateDistributionListItems() {
        Trace.entry(this, "updateDistributionListItems");
        if (this.ditems != null && this.Version > 1) {
            int n = 0;
            while (n < this.ditems.length) {
                this.ditems[n].queueManagerName = this.objectRecords[n].objectQMgrName;
                this.ditems[n].queueName = this.objectRecords[n].objectName;
                this.ditems[n].completionCode = this.responseRecords[n].completionCode;
                this.ditems[n].reasonCode = this.responseRecords[n].reason;
                ++n;
            }
        }
        Trace.exit(this, "updateDistributionListItems");
    }
}

