/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQS390FloatSupport;
import com.ibm.mq.MQS390PackedDecimalSupport;
import com.ibm.mq.MQSESSION;
import com.ibm.mqservices.Trace;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;

public class MQMessage
extends MQMD
implements DataInput,
DataOutput {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQMessage.java, java, j521, j521-L020321  02/03/20 07:52:15";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean jvmHas1051CodePage = false;
    private static boolean haveCheckedIfJVMHas1051 = false;
    private byte[] dataBuffer;
    private ByteArrayInputStream _readBytes;
    private ByteArrayOutputStream _writeBytes;
    private DataInputStream readStream;
    private DataOutputStream writeStream;
    protected static final int READ_MODE = 1;
    protected static final int WRITE_MODE = 2;
    private int mode;
    private int cursorPos;
    private int _dataLength;
    private int _totalMessageLength;
    private int _bufferSizeHint = -1;
    private static final int BOOLEAN_SIZEOF = 1;
    private static final int BYTE_SIZEOF = 1;
    private static final int CHAR_SIZEOF = 2;
    private static final int SHORT_SIZEOF = 2;
    private static final int UTF_SIZEOF = 2;
    private static final int UNBYTE_SIZEOF = 2;
    private static final int INT_SIZEOF = 4;
    private static final int UNSHORT_SIZEOF = 4;
    private static final int LONG_SIZEOF = 8;
    private static final int FLOAT_SIZEOF = 4;
    private static final int DOUBLE_SIZEOF = 8;
    private static final int EXPAND_SIZE = 1024;
    private static final int CODESET_UTF = 1208;
    private static final int CODESET_UCS = 1200;
    private static final int CODESET_819 = 819;
    private static final int CODESET_850 = 850;
    private static final int CODESET_37 = 37;
    private byte[] reversingBuffer = new byte[8];
    private ByteArrayOutputStream reversingOutBytes = new ByteArrayOutputStream();
    private DataOutputStream reversingOutStream;
    private static char[] codepage1051 = null;

    public MQMessage() {
        Trace.entry(this, "MQMessage constructor");
        Trace.trace(2, this, sccsid);
        this.dataBuffer = new byte[0];
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this._writeBytes = new ByteArrayOutputStream(100);
        this.readStream = new DataInputStream(this._readBytes);
        this.writeStream = new DataOutputStream(this._writeBytes);
        this.mode = 2;
        this.cursorPos = 0;
        this._dataLength = 0;
        this.reversingOutStream = new DataOutputStream(this.reversingOutBytes);
        Trace.exit(this, "MQMessage constructor");
    }

    public int getTotalMessageLength() {
        try {
            this.setMode(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(this._dataLength, this._totalMessageLength);
    }

    public int getMessageLength() throws IOException {
        this.setMode(1);
        return this._dataLength;
    }

    public int getDataLength() throws IOException {
        this.setMode(1);
        return this._readBytes.available();
    }

    public void seek(int n) throws IOException {
        if (Trace.isOn()) {
            Trace.entry(this, "seek");
            Trace.trace(2, this, "Seeking to pos: " + n);
        }
        this.setMode(1);
        if (n > this._dataLength) {
            Trace.exit(this, "seek (via exception)");
            throw new EOFException();
        }
        this._readBytes.reset();
        this._readBytes.skip(n);
        this.cursorPos = n;
        Trace.exit(this, "seek");
    }

    public void setDataOffset(int n) throws IOException {
        this.seek(n);
    }

    public int getDataOffset() throws IOException {
        this.setMode(1);
        return this._dataLength - this._readBytes.available();
    }

    public void clearMessage() throws IOException {
        this.reset();
    }

    public void resizeBuffer(int n) throws IOException {
        Trace.entry(this, "resizeBuffer");
        this.setMode(1);
        if (n < this._dataLength) {
            if (Trace.isOn()) {
                Trace.trace(1, this, "truncating message by " + (this._dataLength - n) + " bytes.");
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataBuffer, 0, byArray, 0, n);
            this.dataBuffer = byArray;
            this._readBytes = new ByteArrayInputStream(this.dataBuffer);
            this.readStream = new DataInputStream(this._readBytes);
            if (this.cursorPos > n) {
                this.cursorPos = n;
            }
            this._readBytes.skip(this.cursorPos);
            this._dataLength = n;
        }
        this._bufferSizeHint = n;
        Trace.exit(this, "buffer");
    }

    private final synchronized void reset() {
        Trace.entry(this, "reset");
        this._writeBytes.reset();
        this.dataBuffer = new byte[0];
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this.readStream = new DataInputStream(this._readBytes);
        this.mode = 2;
        this.cursorPos = 0;
        this._dataLength = 0;
        this._totalMessageLength = 0;
        Trace.exit(this, "reset");
    }

    public boolean readBoolean() throws IOException, EOFException {
        this.setMode(1);
        return this.readStream.readBoolean();
    }

    public byte readByte() throws IOException, EOFException {
        this.setMode(1);
        return this.readStream.readByte();
    }

    public char readChar() throws IOException, EOFException {
        char c = '\u0000';
        Trace.entry(this, "readChar");
        this.setMode(1);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                c = this.readStream.readChar();
                break;
            }
            case 2: {
                DataInputStream dataInputStream = this.readReverse(2);
                c = dataInputStream.readChar();
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF00));
                Trace.exit(this, "readChar (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readChar");
        return c;
    }

    public double readDouble() throws IOException, EOFException {
        double d;
        Trace.entry(this, "readDouble");
        this.setMode(1);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                d = this.readStream.readDouble();
                break;
            }
            case 512: {
                DataInputStream dataInputStream = this.readReverse(8);
                d = dataInputStream.readDouble();
                break;
            }
            case 768: {
                long l = this.readStream.readLong();
                d = MQS390FloatSupport.longS390BitsToDouble(l);
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF00));
                Trace.exit(this, "readDouble (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readDouble");
        return d;
    }

    public float readFloat() throws IOException, EOFException {
        float f;
        Trace.entry(this, "readFloat");
        this.setMode(1);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                f = this.readStream.readFloat();
                break;
            }
            case 512: {
                DataInputStream dataInputStream = this.readReverse(4);
                f = dataInputStream.readFloat();
                break;
            }
            case 768: {
                int n = this.readStream.readInt();
                f = MQS390FloatSupport.intS390BitsToFloat(n);
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF00));
                Trace.exit(this, "readFloat (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readFloat");
        return f;
    }

    public void readFully(byte[] byArray) throws IOException, EOFException {
        this.setMode(1);
        this.readStream.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException, EOFException {
        this.setMode(1);
        this.readStream.readFully(byArray, n, n2);
    }

    public int readInt() throws IOException, EOFException {
        int n;
        Trace.entry(this, "readInt");
        this.setMode(1);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                n = this.readStream.readInt();
                break;
            }
            case 2: {
                DataInputStream dataInputStream = this.readReverse(4);
                n = dataInputStream.readInt();
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF00));
                Trace.exit(this, "readInt (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readInt");
        return n;
    }

    public int readInt4() throws IOException, EOFException {
        return this.readInt();
    }

    public String readLine() throws IOException {
        Trace.entry(this, "readLine");
        this.setMode(1);
        String string = "";
        switch (this.characterSet) {
            case 1200: {
                return this.readUnicodeLine();
            }
            case 1051: {
                return this.read1051Line();
            }
        }
        return this.readConvertedLine();
    }

    private String read1051Line() throws IOException {
        String string;
        Trace.entry(this, "read1051Line");
        if (!haveCheckedIfJVMHas1051) {
            try {
                String string2 = this.readConvertedLine();
                jvmHas1051CodePage = true;
                Trace.exit(this, "read1051Line");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                jvmHas1051CodePage = false;
                haveCheckedIfJVMHas1051 = true;
            }
        }
        if (jvmHas1051CodePage) {
            string = this.readConvertedLine();
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.getDataLength() / 2);
            char[] cArray = this.get1051Codepage();
            try {
                boolean bl = false;
                block8: while (!bl) {
                    char c = cArray[this.readByte()];
                    switch (c) {
                        case '\n': {
                            bl = true;
                            break;
                        }
                        case '\r': {
                            char c2;
                            bl = true;
                            if (this.getDataLength() < 1 || (c2 = cArray[this.readByte()]) == '\n') continue block8;
                            this.seek(this.getDataOffset() - 1);
                            break;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                Trace.trace(1, this, "hit end of file!");
            }
            string = stringBuffer.toString();
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "Read 1051 string: " + string);
            Trace.exit(this, "read1051Line");
        }
        return string;
    }

    private String readUnicodeLine() throws IOException {
        Trace.entry(this, "readUnicodeLine");
        StringBuffer stringBuffer = new StringBuffer(this.getDataLength() / 2);
        try {
            boolean bl = false;
            block6: while (!bl) {
                char c = this.readChar();
                switch (c) {
                    case '\n': {
                        bl = true;
                        break;
                    }
                    case '\r': {
                        char c2;
                        bl = true;
                        if (this.getDataLength() < 2 || (c2 = this.readChar()) == '\n') continue block6;
                        this.seek(this.getDataOffset() - 2);
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            Trace.trace(1, this, "hit end of file!");
        }
        if (Trace.isOn()) {
            Trace.trace(3, this, "Read Unicode string: " + stringBuffer);
            Trace.exit(this, "readUnicodeLine");
        }
        return stringBuffer.toString();
    }

    private String readConvertedLine() throws IOException {
        int n;
        Trace.entry(this, "readConvertedLine");
        byte[] byArray = new byte[this.getDataLength()];
        System.arraycopy(this.dataBuffer, this.getDataOffset(), byArray, 0, byArray.length);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, this.getCharacterSetString(this.characterSet)));
        Trace.trace(3, this, "Built InputStreamReader");
        StringBuffer stringBuffer = new StringBuffer(this.getDataLength());
        String string = "";
        boolean bl = false;
        block5: while (!bl) {
            if (bufferedReader.ready()) {
                n = bufferedReader.read();
                switch (n) {
                    case -1: {
                        bl = true;
                        break;
                    }
                    case 10: {
                        string = "\n";
                        bl = true;
                        break;
                    }
                    case 13: {
                        int n2;
                        bl = true;
                        string = "\r";
                        if (!bufferedReader.ready() || (n2 = bufferedReader.read()) != 10) continue block5;
                        string = "\r\n";
                        break;
                    }
                    default: {
                        stringBuffer.append((char)n);
                        break;
                    }
                }
                continue;
            }
            bl = true;
        }
        n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.getCharacterSetString(this.characterSet));
        String string2 = stringBuffer + string;
        outputStreamWriter.write(string2, 0, string2.length());
        outputStreamWriter.flush();
        n = byteArrayOutputStream.toByteArray().length;
        this.readStream.skip(n);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Read string: '" + stringBuffer + "', " + n + " bytes.");
            Trace.exit(this, "readConvertedLine");
        }
        return stringBuffer.toString();
    }

    public long readLong() throws IOException, EOFException {
        long l;
        Trace.entry(this, "readLong");
        this.setMode(1);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                l = this.readStream.readLong();
                break;
            }
            case 2: {
                DataInputStream dataInputStream = this.readReverse(8);
                l = dataInputStream.readLong();
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF));
                Trace.exit(this, "readLong (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readLong");
        return l;
    }

    public long readInt8() throws IOException, EOFException {
        return this.readLong();
    }

    public short readShort() throws IOException, EOFException {
        short s;
        Trace.entry(this, "readShort");
        this.setMode(1);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                s = this.readStream.readShort();
                break;
            }
            case 2: {
                DataInputStream dataInputStream = this.readReverse(2);
                s = dataInputStream.readShort();
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF));
                Trace.exit(this, "readShort (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readShort");
        return s;
    }

    public short readInt2() throws IOException, EOFException {
        return this.readShort();
    }

    public String readUTF() throws IOException {
        this.setMode(1);
        return this.readStream.readUTF();
    }

    public int readUnsignedByte() throws IOException, EOFException {
        this.setMode(1);
        return this.readStream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException, EOFException {
        int n;
        Trace.entry(this, "readUnsignedShort");
        this.setMode(1);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                n = this.readStream.readUnsignedShort();
                break;
            }
            case 2: {
                DataInputStream dataInputStream = this.readReverse(2);
                n = dataInputStream.readUnsignedShort();
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding : " + (this.encoding & 0xF));
                Trace.exit(this, "readUnsignedShort (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "readUnsignedShort");
        return n;
    }

    public int readUInt2() throws IOException, EOFException {
        return this.readUnsignedShort();
    }

    public String readString(int n) throws IOException, EOFException {
        String string;
        Trace.entry(this, "readString");
        this.setMode(1);
        int n2 = this.getDataOffset();
        try {
            switch (this.characterSet) {
                case 1200: {
                    char[] cArray = new char[n];
                    int n3 = 0;
                    while (n3 < n) {
                        cArray[n3] = this.readChar();
                        ++n3;
                    }
                    string = new String(cArray);
                    break;
                }
                case 1051: {
                    string = this.read1051String(n);
                    break;
                }
                default: {
                    string = this.readConvertedString(n);
                    break;
                }
            }
        }
        catch (EOFException eOFException) {
            this.setDataOffset(n2);
            Trace.exit(this, "readString (via EOFException)");
            throw eOFException;
        }
        Trace.exit(this, "readString");
        return string;
    }

    private String read1051String(int n) throws IOException {
        String string;
        if (Trace.isOn()) {
            Trace.entry(this, "read1051String");
        }
        if (!haveCheckedIfJVMHas1051) {
            try {
                String string2 = this.readConvertedString(n);
                jvmHas1051CodePage = true;
                Trace.exit(this, "read1051String");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                jvmHas1051CodePage = false;
                haveCheckedIfJVMHas1051 = true;
            }
        }
        if (jvmHas1051CodePage) {
            string = this.readConvertedString(n);
        } else {
            char[] cArray = this.get1051Codepage();
            char[] cArray2 = new char[n];
            int n2 = 0;
            while (n2 < n) {
                cArray2[n2] = cArray[this.readByte()];
                ++n2;
            }
            string = new String(cArray2);
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "Read string: '" + string);
            Trace.exit(this, "readString1051");
        }
        return string;
    }

    private String readConvertedString(int n) throws IOException, EOFException {
        Trace.entry(this, "readConvertedString");
        String string = "";
        byte[] byArray = new byte[this.getDataLength()];
        System.arraycopy(this.dataBuffer, this.getDataOffset(), byArray, 0, byArray.length);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, this.getCharacterSetString(this.characterSet));
        Trace.trace(3, this, "Built InputStreamReader");
        char[] cArray = new char[n];
        int n2 = inputStreamReader.read(cArray, 0, n);
        if (n2 < n) {
            Trace.exit(this, "readConvertedString (via exception)");
            throw new EOFException();
        }
        string = new String(cArray);
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.getCharacterSetString(this.characterSet));
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
        n3 = byteArrayOutputStream.toByteArray().length;
        this.readStream.skip(n3);
        if (Trace.isOn()) {
            Trace.trace(2, this, "Read string: '" + string + "', " + n3 + " bytes.");
            Trace.exit(this, "readConvertedString");
        }
        return string;
    }

    public short readDecimal2() throws IOException, EOFException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, byArray.length);
        }
        long l = MQS390PackedDecimalSupport.convertToBinary(byArray);
        return (short)l;
    }

    public int readDecimal4() throws IOException, EOFException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, byArray.length);
        }
        long l = MQS390PackedDecimalSupport.convertToBinary(byArray);
        return (int)l;
    }

    public long readDecimal8() throws IOException, EOFException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, byArray.length);
        }
        long l = MQS390PackedDecimalSupport.convertToBinary(byArray);
        return l;
    }

    public int skipBytes(int n) throws IOException, EOFException {
        Trace.entry(this, "skipBytes");
        this.setMode(1);
        int n2 = Math.min(n, this._readBytes.available());
        if (Trace.isOn()) {
            Trace.trace(2, this, "Skipping " + n2 + " bytes.");
        }
        this.readStream.skipBytes(n2);
        if (n2 < n) {
            Trace.exit(this, "skipBytes (via exception)");
            throw new EOFException();
        }
        Trace.exit(this, "skipBytes");
        return n2;
    }

    public void readMQMDE() throws MQException, IOException {
        Trace.entry(this, "readMQMDE");
        this.setMode(1);
        String string = this.readString(4);
        if (!string.equals("MDE ")) {
            Trace.exit(this, "readMQMDE (via exception)");
            throw new MQException(2, 2248, this, 15, string);
        }
        this.readStream.skipBytes(8);
        int n = this.readStream.readInt();
        int n2 = this.readStream.readInt();
        this.format = this.readString(8);
        this.readStream.skipBytes(4);
        this.groupId = this.setArrayToLength(this.groupId, 24);
        this.readStream.read(this.groupId, 0, 24);
        this.messageSequenceNumber = this.readStream.readInt();
        this.offset = this.readStream.readInt();
        this.messageFlags = this.readStream.readInt();
        this.originalLength = this.readStream.readInt();
        this.encoding = n;
        this.characterSet = n2;
        Trace.exit(this, "readMQMDE");
    }

    public Object readObject() throws ClassNotFoundException, InvalidClassException, StreamCorruptedException, OptionalDataException, IOException {
        Trace.entry(this, "readObject");
        Object object = null;
        this.setMode(1);
        ObjectInputStream objectInputStream = new ObjectInputStream(this.readStream);
        object = objectInputStream.readObject();
        Trace.exit(this, "readObject");
        return object;
    }

    public void write(int n) throws IOException {
        this.setMode(2);
        this.writeStream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.setMode(2);
        this.writeStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.setMode(2);
        this.writeStream.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.setMode(2);
        this.writeStream.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.setMode(2);
        this.writeStream.writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.setMode(2);
        if (this.characterSet == 0) {
            this.characterSet = MQSESSION.getDefaultCCSID();
        }
        this.writeStream.writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        Trace.entry(this, "writeChar");
        this.setMode(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeChar(n);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeChar(n);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 2);
                this.writeStream.write(byArray);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF));
                Trace.exit(this, "writeChar (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeChar");
    }

    public void writeChars(String string) throws IOException {
        Trace.entry(this, "writeChars");
        this.setMode(2);
        try {
            int n = 0;
            while (n < string.length()) {
                this.writeChar(string.charAt(n));
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Trace.exit(this, "writeChars (via exception)" + stringIndexOutOfBoundsException);
            throw new IOException(stringIndexOutOfBoundsException.toString());
        }
        Trace.exit(this, "writeChars");
    }

    public void writeDouble(double d) throws IOException {
        Trace.entry(this, "writeDouble");
        this.setMode(2);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.writeStream.writeDouble(d);
                break;
            }
            case 512: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeDouble(d);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 8);
                this.writeStream.write(byArray);
                break;
            }
            case 768: {
                long l = MQS390FloatSupport.doubleToS390LongBits(d);
                this.writeStream.writeLong(l);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF00));
                Trace.exit(this, "writeDouble (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeDouble");
    }

    public void writeFloat(float f) throws IOException {
        Trace.entry(this, "writeFloat");
        this.setMode(2);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.writeStream.writeFloat(f);
                break;
            }
            case 512: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeFloat(f);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 4);
                this.writeStream.write(byArray);
                break;
            }
            case 768: {
                int n = MQS390FloatSupport.floatToS390IntBits(f);
                this.writeStream.writeInt(n);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF00));
                Trace.exit(this, "writeFloat (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeFloat");
    }

    public void writeInt(int n) throws IOException {
        Trace.entry(this, "writeInt");
        this.setMode(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeInt(n);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeInt(n);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 4);
                this.writeStream.write(byArray);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF));
                Trace.exit(this, "writeInt (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeInt");
    }

    public void writeInt4(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        Trace.entry(this, "writeLong");
        this.setMode(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeLong(l);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeLong(l);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 8);
                this.writeStream.write(byArray);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF00));
                Trace.exit(this, "writeLong (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeLong");
    }

    public void writeInt8(long l) throws IOException {
        this.writeLong(l);
    }

    public void writeShort(int n) throws IOException {
        Trace.entry(this, "writeShort");
        this.setMode(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeShort(n);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeShort(n);
                byte[] byArray = this.reversingOutBytes.toByteArray();
                this.reverse(byArray, 2);
                this.writeStream.write(byArray);
                break;
            }
            default: {
                Trace.trace(1, this, "Unsupported encoding: " + (this.encoding & 0xF00));
                Trace.exit(this, "writeShort (via exception)");
                throw new IOException();
            }
        }
        Trace.exit(this, "writeShort");
    }

    public void writeInt2(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeDecimal2(short s) throws IOException {
        byte[] byArray = MQS390PackedDecimalSupport.convertToPackedDecimal(s);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, 2);
        }
        this.write(byArray);
    }

    public void writeDecimal4(int n) throws IOException {
        byte[] byArray = MQS390PackedDecimalSupport.convertToPackedDecimal(n);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, 4);
        }
        this.write(byArray);
    }

    public void writeDecimal8(long l) throws IOException {
        byte[] byArray = MQS390PackedDecimalSupport.convertToPackedDecimal(l);
        if ((this.encoding & 0xF0) == 32) {
            this.reverse(byArray, 8);
        }
        this.write(byArray);
    }

    public void writeUTF(String string) throws IOException {
        this.setMode(2);
        this.writeStream.writeUTF(string);
    }

    public void writeString(String string) throws IOException {
        Trace.entry(this, "writeString");
        this.setMode(2);
        switch (this.characterSet) {
            case 1200: {
                this.writeChars(string);
                break;
            }
            case 0: {
                this.characterSet = MQSESSION.getDefaultCCSID();
            }
            default: {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.writeStream, this.getCharacterSetString(this.characterSet));
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.flush();
            }
        }
        Trace.exit(this, "writeString");
    }

    public void writeMQMDE() throws IOException, MQException {
        Trace.entry(this, "writeMQMDE");
        this.setMode(2);
        this.writeStream.writeBytes("\u00d4\u00c4\u00c5@");
        this.writeStream.writeInt(2);
        this.writeStream.writeInt(72);
        this.writeStream.writeInt(this.encoding);
        this.writeStream.writeInt(this.characterSet);
        this.format = MQSESSION.setStringToLength(this.format, 8);
        this.writeStream.writeBytes(this.format);
        this.writeStream.writeInt(0);
        this.groupId = this.setArrayToLength(this.groupId, 24);
        this.writeStream.write(this.groupId);
        this.writeStream.writeInt(this.messageSequenceNumber);
        this.writeStream.writeInt(this.offset);
        this.writeStream.writeInt(this.messageFlags);
        this.writeStream.writeInt(this.originalLength);
        this.format = "MQHMDE  ";
        Trace.exit(this, "writeMQMDE");
    }

    public void writeObject(Object object) throws IOException {
        Trace.entry(this, "writeObject");
        this.setMode(2);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.writeStream);
        objectOutputStream.writeObject(object);
        Trace.exit(this, "writeObject");
    }

    protected final byte[] toByteArray() {
        this.setMode(1);
        return this.dataBuffer;
    }

    protected final void setMessageData(byte[] byArray, int n, int n2) {
        if (Trace.isOn()) {
            Trace.entry(this, "setMessageData");
            Trace.trace(2, this, "byte array of length " + byArray.length + " msg length " + n + " total msg length " + n2);
        }
        this._writeBytes.reset();
        this.dataBuffer = new byte[n];
        System.arraycopy(byArray, 0, this.dataBuffer, 0, n);
        this._dataLength = n;
        this.cursorPos = 0;
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this.readStream = new DataInputStream(this._readBytes);
        this.mode = 1;
        this._totalMessageLength = n2;
        Trace.exit(this, "setMessageData");
    }

    protected int getBufferSizeHint() {
        return this._bufferSizeHint;
    }

    protected void setTotalMessageLength(int n) {
        this._totalMessageLength = n;
    }

    private final void setMode(int n) {
        Trace.entry(this, "setMode");
        if (n != this.mode) {
            switch (n) {
                case 1: {
                    Trace.trace(2, this, "Switching to read mode");
                    byte[] byArray = this._writeBytes.toByteArray();
                    this._dataLength = this.cursorPos + Math.max(byArray.length, this.dataBuffer.length - this.cursorPos);
                    byte[] byArray2 = new byte[this._dataLength];
                    try {
                        System.arraycopy(this.dataBuffer, 0, byArray2, 0, this.cursorPos);
                        System.arraycopy(byArray, 0, byArray2, this.cursorPos, byArray.length);
                        int n2 = this.dataBuffer.length - this.cursorPos - byArray.length;
                        if (n2 > 0) {
                            System.arraycopy(this.dataBuffer, this.cursorPos + byArray.length, byArray2, this.cursorPos + byArray.length, n2);
                        }
                    }
                    catch (Exception exception) {
                        Trace.trace(1, this, "Exception building message data " + exception);
                    }
                    this.dataBuffer = byArray2;
                    this._readBytes = new ByteArrayInputStream(this.dataBuffer);
                    this.readStream = new DataInputStream(this._readBytes);
                    this.cursorPos += byArray.length;
                    this._readBytes.skip(this.cursorPos);
                    this._writeBytes.reset();
                    this.mode = 1;
                    break;
                }
                case 2: {
                    Trace.trace(2, this, "Switching to write mode");
                    this.cursorPos = this._dataLength - this._readBytes.available();
                    this.mode = 2;
                    break;
                }
                default: {
                    Trace.trace(1, this, "Invalid mode : " + n);
                }
            }
        }
        Trace.exit(this, "setMode");
    }

    private final DataInputStream readReverse(int n) throws IOException {
        this.readStream.read(this.reversingBuffer, 0, n);
        this.reverse(this.reversingBuffer, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.reversingBuffer);
        return new DataInputStream(byteArrayInputStream);
    }

    private final void reverse(byte[] byArray, int n) {
        if (Trace.isOn()) {
            Trace.entry(this, "reverse");
            Trace.trace(4, this, "length = " + n + " data follows: ");
            Trace.dataTrace(4, this, byArray);
        }
        int n2 = 0;
        while (n2 < n / 2) {
            byte by = byArray[n2];
            byArray[n2] = byArray[n - 1 - n2];
            byArray[n - 1 - n2] = by;
            ++n2;
        }
        Trace.exit(this, "reverse");
    }

    private String getCharacterSetString(int n) {
        String string;
        String string2;
        Trace.entry(this, "getCharacterSetString");
        if (n == 0) {
            n = MQSESSION.getDefaultCCSID();
        }
        if ((string2 = MQCcsidTable.lookup(string = Integer.toString(n))) == null) {
            string2 = "Cp" + string;
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "Mapped " + n + " -> " + string2);
            Trace.exit(this, "getCharacterSetString");
        }
        return string2;
    }

    public String unicodeFrom1051(byte[] byArray, int n) {
        if (Trace.isOn()) {
            Trace.entry(this, "unicodeFrom1051");
        }
        int n2 = byArray.length - n;
        char[] cArray = new char[n2];
        if (codepage1051 == null) {
            codepage1051 = this.get1051Codepage();
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = codepage1051[byArray[n3]];
            ++n3;
            ++n4;
        }
        if (Trace.isOn()) {
            Trace.exit(this, "unicodeFrom1051");
        }
        return new String(cArray);
    }

    private char[] get1051Codepage() {
        if (Trace.isOn()) {
            Trace.entry(this, "get1051codepage");
        }
        char[] cArray = new char[255];
        char[] cArray2 = new char[]{'\u00c0', '\u00c2', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u02ca', '\u02cb', '\u02c6', '\u00a8', '\u02dc', '\u00d9', '\u00db', '\u20a4', '\u00af', '\u00dd', '\u00fd', '\u00b0', '\u00c7', '\u00e7', '\u00d1', '\u00f1', '\u00a1', '\u00bf', '\u00a4', '\u00a3', '\u00a5', '\u00a7', '\u0192', '\u00a2', '\u00e2', '\u00ea', '\u00f4', '\u00fb', '\u00e1', '\u00e9', '\u00f3', '\u00fa', '\u00e0', '\u00e8', '\u00f2', '\u00f9', '\u00e4', '\u00eb', '\u00f6', '\u00fc', '\u00c5', '\u00ee', '\u00d8', '\u00c6', '\u00e5', '\u00ed', '\u00f8', '\u00e6', '\u00c4', '\u00ec', '\u00d6', '\u00dc', '\u00c9', '\u00ef', '\u00df', '\u00d4', '\u00c1', '\u00c3', '\u00e3', '\u00d0', '\u00f0', '\u00cd', '\u00cc', '\u00d3', '\u00d2', '\u00d5', '\u00f5', '\u0160', '\u0161', '\u00da', '\u0178', '\u00ff', '\u00de', '\u00fe', '\u00b7', '\u00b5', '\u00b6', '\u00be', '\u00ad', '\u00bc', '\u00bd', '\u00aa', '\u00ba', '\u00ab', '\u25a0', '\u00bb', '\u00b1'};
        int n = 0;
        while (n < 161) {
            cArray[n] = (char)n;
            ++n;
        }
        int n2 = 161;
        while (n2 <= 254) {
            cArray[n2] = cArray2[n2 - 161];
            ++n2;
        }
        if (Trace.isOn()) {
            Trace.exit(this, "get1051codepage");
        }
        return cArray;
    }
}

